/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.util.Enumeration;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.eclipse.aperi.TStorm.gui.ReportingTreeLabel;
import org.eclipse.aperi.TStorm.gui.SavedReportDDI;
import org.eclipse.aperi.TStorm.gui.SavedReportNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.NameListTreeCellRenderer;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class SavedReportLabel
extends BaseTreeNode
implements GuiRequestor,
ObjectChangeListener {
    private boolean expanded;
    private boolean systemReports;
    private String reportOwner;
    private byte productCode;

    public SavedReportLabel(boolean systemReports, byte productCode) {
        this(systemReports, productCode, 0);
    }

    public SavedReportLabel(boolean systemReports, byte productCode, int userid) {
        this.systemReports = systemReports;
        this.productCode = productCode;
        String label = "";
        if (systemReports) {
            if (userid == 1) {
                label = Util.getString("DATA");
                this.reportOwner = "Default";
            } else if (userid == 3) {
                label = Util.getString("STG1240L");
                this.reportOwner = "DiskDefault";
            } else if (userid == 2) {
                label = Util.getString("LABEL_FABRIC");
                this.reportOwner = "FabricDefault";
            }
        } else {
            this.reportOwner = GuiUtil.getUserName();
            label = MessageLog.getMessageNoID("STG4152L", this.reportOwner);
            ChangeManager.addListener(this, (short)35);
        }
        this.setUserObject(label);
    }

    public void expand(TreeExpansionEvent event) {
        if (!this.expanded) {
            Request request = new Request();
            GuiRequest.computerList(request);
            GuiListReq requestData = (GuiListReq)request.requestData;
            requestData.listRequested = 10035;
            requestData.resourceType = this.productCode;
            requestData.qualifier = (short)(this.systemReports ? 1 : 0);
            requestData.qualifierObject = this.reportOwner;
            GuiClient.doRequest(this, request);
        }
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        this.expanded = true;
        this.removeAllChildren();
        NameList listElement = (NameList)response.responseData;
        String[][] tempNames = Constants.REPORT_NAMES;
        int index = 0;
        while (listElement != null) {
            String nodeName = listElement.nlName;
            for (int i = 0; i < Constants.REPORT_NAMES.length; ++i) {
                if (!nodeName.equals(Constants.REPORT_NAMES[i][0]) && !nodeName.equals(Constants.REPORT_NAMES[i][1])) continue;
                listElement.nlName = Util.getString(Constants.REPORT_NAMES[i][1]);
                break;
            }
            SavedReportNode node = new SavedReportNode(listElement);
            BaseTree.MyTree.insertNodeInto(node, this, index++);
            listElement = listElement.nlNext;
        }
    }

    public void changeOccurred(int changeType, NameList name) {
        switch (changeType) {
            case 1: {
                BaseTreeNode child;
                if (!this.expanded || (child = this.find(name.nlID)) != null) break;
                child = new SavedReportNode(name);
                this.addSorted(child);
                SavedReportDDI currentDDI = (SavedReportDDI)DataDisplayInfo.getCurrent();
                if (currentDDI.treeNode != null) {
                    currentDDI.treeNode.ddi = null;
                }
                SavedReportNode treeNode = (SavedReportNode)child;
                currentDDI.treeNode = treeNode;
                treeNode.ddi = currentDDI;
                treeNode.selectionServices = ReportingTreeLabel.selectionServiceArray[currentDDI.gsrr.grr.reportType];
                guiMain.getBaseTree().reselect(treeNode, true);
                break;
            }
            case 0: {
                BaseTreeNode child = this.find(name.nlID);
                if (child == null) break;
                BaseTree.MyTree.removeNodeFromParent(child);
                int start = name.nlName.indexOf(46) + 1;
                if (start > 0) {
                    name.nlName = name.nlName.substring(start);
                }
                child.setUserObject(name);
                this.addSorted(child);
                break;
            }
            case -1: {
                BaseTreeNode child = this.find(name.nlID);
                if (child == null) break;
                BaseTree.MyTree.removeNodeFromParent(child);
            }
        }
    }

    private BaseTreeNode find(int id) {
        BaseTreeNode child = null;
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            child = (BaseTreeNode)e.nextElement();
            NameList element = (NameList)child.getUserObject();
            if (element.nlID == id) break;
            child = null;
        }
        return child;
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean selected, boolean expanded, boolean isLeaf, int row, boolean hasFocus) {
        renderer.setIcon(NameListTreeCellRenderer.iconForType((short)35));
        renderer.setFont(BaseTree.boldFont);
    }

    public boolean isSystemReport() {
        return this.systemReports;
    }
}

