/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.ReportingTreeNode;
import org.eclipse.aperi.TStorm.gui.SavedReportNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiSavedReportReq;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.ExportTableData;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class UnTabbedReportingDDI
extends ReportingDDI {
    boolean isTable;
    boolean saveEnabled;
    boolean saveAz;

    public UnTabbedReportingDDI(GuiSavedReportReq gsrr, BaseTreeNode treeNodeIn) {
        this(gsrr.grr, (ReportingTreeNode)treeNodeIn);
        this.gsrr = gsrr;
        this.setDescription(gsrr.creator + "." + gsrr.getName());
    }

    public UnTabbedReportingDDI(GuiReportReq grr, ReportingTreeNode treeNodeIn) {
        super(grr, (BaseTreeNode)treeNodeIn);
        this.tabNodeTail = this.tabNodeHead = new ReportingDDI.TabNode(grr, null, null);
        this.isTable = true;
    }

    private UnTabbedReportingDDI(ReportingDDI.TabNode tabNode, BaseTreeNode treeNodeIn) {
        super(tabNode.grr, (BaseTreeNode)((ReportingTreeNode)treeNodeIn));
        this.setDescription(tabNode.toolTip);
        this.tabNodeHead = tabNode;
        this.tabNodeTail = tabNode;
        this.isTable = false;
    }

    protected void setJumpPrefs() {
    }

    public void losingFocus() {
        this.disableExport();
        if (this.saveEnabled) {
            this.saveEnabled = false;
            this.guiMain.setSaveActionEnabled(false, false);
            this.guiMain.setSaveActionToolTip(null);
            this.guiMain.removeSaveActionListener(this);
            this.guiMain.setSaveAsActionEnabled(false, false);
            this.guiMain.setSaveAsActionToolTip(null);
            this.guiMain.removeSaveAsActionListener(this);
        }
    }

    public void panelToBeNulled() {
    }

    public void goingAway() {
    }

    public void reDisplay() {
        if (!this.productAvailable) {
            return;
        }
        if (this.panel == null) {
            this.rebuild(this.tabNodeHead, 1);
            if (this.panel == null) {
                this.makeReport(this.grr, this.reportTabTitle, this.getDescription(), 0, this.tabNodeHead);
            }
        }
        this.show();
        if (this.isTable) {
            this.enableExport();
        } else {
            this.disableExport();
        }
        if (!this.saveEnabled) {
            this.saveEnabled = true;
            this.guiMain.setSaveActionEnabled(true, true);
            this.guiMain.setSaveActionToolTip(MessageLog.getMessageNoID("GUI5066T"));
            this.guiMain.addSaveActionListener(this);
            this.guiMain.setSaveAsActionEnabled(true, true);
            this.guiMain.setSaveAsActionToolTip(MessageLog.getMessageNoID("GUI5067T"));
            this.guiMain.addSaveAsActionListener(this);
        }
    }

    protected void makeTab(String title, Component component, String toolTip, int tabIndex, ReportingDDI.TabNode tabNode) {
        this.panel = (JComponent)component;
    }

    public void addRowCount(ReportDataAdjuster adjuster) {
    }

    public void addReport(GuiReportReq parentGrr, GuiReportReq childGrr, String name) {
        ReportingDDI.TabNode tabNode = new ReportingDDI.TabNode(childGrr, name, name);
        UnTabbedReportingDDI ddi = new UnTabbedReportingDDI(tabNode, this.treeNode);
        ddi.reDisplay();
    }

    public void addChart(GuiReportReq grr, JComponent chart, String toolTip) {
        ReportingDDI.TabNode tabNode = new ReportingDDI.TabNode(chart, CHART, toolTip, chart);
        this.newDDI(tabNode, grr);
    }

    private void newDDI(ReportingDDI.TabNode tabNode, GuiReportReq grr) {
        tabNode.grr = grr;
        UnTabbedReportingDDI ddi = new UnTabbedReportingDDI(tabNode, this.treeNode);
        ddi.reDisplay();
    }

    public void addObject(GuiReportReq grr, String className, Object object, String tabName, String toolTip, int tabIndex) {
        ReportingDDI.TabNode tabNode = new ReportingDDI.TabNode(object, tabName, toolTip, className, null);
        this.newDDI(tabNode, grr);
    }

    public void addObject(GuiReportReq grr, String className, Object object, String tabName, String toolTip) {
        this.addObject(grr, className, object, tabName, toolTip, -1);
    }

    public void actionPerformed(ActionEvent event) {
        String source = event.getActionCommand();
        if (source == "Save") {
            this.saveAz = false;
            this.save();
        } else if (source == "SaveAs") {
            this.saveAz = true;
            this.save();
        } else if (source == "Export") {
            JComponent reportPanel = this.panel;
            ExportTableData.export(reportPanel, null, this.getDescription());
        }
    }

    private void save() {
        GuiSavedReportReq newGsrr = new GuiSavedReportReq();
        if (this.gsrr == null || this.gsrr.ID <= 299) {
            this.saveAz = true;
            newGsrr.creator = GuiUtil.getUserName();
            newGsrr.grr = this.grr;
        } else {
            newGsrr.creator = this.gsrr.creator;
            newGsrr.setName(this.gsrr.getTrueName());
            newGsrr.ID = this.gsrr.ID;
            newGsrr.grr = this.gsrr.grr;
        }
        newGsrr.productCode = this.productCode;
        if (this.saveAz) {
            newGsrr.ID = -1;
            String title = MessageLog.getMessageNoID("GUI5007L");
            String str = MessageLog.getMessageNoID("STG4207L");
            String prompt = MessageLog.getMessageNoID("GUI5011L", new Object[]{str});
            boolean going = true;
            while (going) {
                newGsrr.setName(GuiUtil.displayOkCancelPane(title, prompt, 32, false, null, this.guiMain.getFrame()));
                going = newGsrr.getName() != null && !newGsrr.getName().equals("") && newGsrr.getName().indexOf(46) >= 0;
                if (!going) continue;
                String s = MessageLog.getMessageNoTS("GUI0056E", null);
                GuiUtil.displayErrorMessage(s);
            }
        }
        if (newGsrr.getName() != null && !newGsrr.getName().equals("")) {
            SavedReportNode.doRequest(this, newGsrr);
        }
    }
}

