/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.xmsg.MessageLog;

public class DateFreeForm
extends FreeForm {
    private static void twoDigits(int x, StringBuffer out) {
        out.append((char)(48 + x / 10));
        out.append((char)(48 + x % 10));
    }

    private static String formatDuration(ColumnFilterValue v, short dataType) {
        String result;
        Object obj = v.fvValue;
        if (!(obj instanceof MutableLong)) {
            result = "***ERROR***";
        } else {
            MutableLong x = (MutableLong)obj;
            int duration = (int)x.value;
            if (dataType == 6) {
                duration = (int)(x.value / 1000L);
            }
            long days = duration / 86400;
            duration = (int)((long)duration - days * 86400L);
            StringBuffer buf = new StringBuffer(8);
            int y = duration / 3600;
            DateFreeForm.twoDigits(y, buf);
            buf.append(':');
            duration -= y * 3600;
            y = duration / 60;
            DateFreeForm.twoDigits(y, buf);
            buf.append(':');
            DateFreeForm.twoDigits(duration -= y * 60, buf);
            String msgID = dataType == 4 ? "STG3269T" : "STG3268T";
            Object[] parms = new Object[]{new Long(days), buf.toString()};
            result = MessageLog.getMessageNoID(msgID, parms);
        }
        return result;
    }

    private static String formatDate(ColumnFilterValue v) {
        Object obj = v.fvValue;
        String result = obj instanceof Date ? Util.formatDateTime((Date)obj) : "***ERROR***";
        return result;
    }

    public DateFreeForm(ColumnFilter pFilter) {
        super(pFilter);
        this.textField.setEditable(false);
    }

    public void getData() throws GeneralException {
        if (this.filter.clfValueList == null) {
            String s = MessageLog.getMessageNoTS("STG3265E");
            throw new GeneralException(s);
        }
    }

    public void refresh() {
        ColumnFilterValue value = this.filter.clfValueList;
        if (value == null) {
            return;
        }
        short dataType = this.filter.clfDataType;
        String s = dataType == 3 ? DateFreeForm.formatDate(value) : DateFreeForm.formatDuration(value, dataType);
        this.textField.setText(s);
    }
}

