/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.text.DecimalFormatSymbols;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.xmsg.MessageLog;

public class IntegerFreeForm
extends FreeForm {
    public static char decimalPoint;
    private int escala;

    public static String format(MutableLong x, int scale) {
        String result = Long.toString(x.value);
        if (scale > 0) {
            int length = result.length();
            StringBuffer buf = new StringBuffer(length + 1);
            int decimalHere = length - scale;
            for (int i = 0; i < length; ++i) {
                if (i == decimalHere) {
                    buf.append(decimalPoint);
                }
                buf.append(result.charAt(i));
            }
            result = buf.toString();
        }
        return result;
    }

    public static MutableLong parse(String s, int scale) throws GeneralException {
        int i;
        int length;
        int radixPos = length = s.length();
        boolean wellFormed = true;
        for (i = 0; wellFormed && i < length; ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) continue;
            if (c != decimalPoint || radixPos < length) {
                wellFormed = false;
                continue;
            }
            radixPos = i;
        }
        if (!wellFormed) {
            Object[] parms = new Object[]{s};
            String msg = MessageLog.getMessageNoTS("STG3266E", parms);
            throw new GeneralException(msg);
        }
        StringBuffer numberBuf = new StringBuffer();
        i = 0;
        while (i < radixPos) {
            numberBuf.append(s.charAt(i++));
        }
        ++i;
        while (scale > 0) {
            if (i < length) {
                numberBuf.append(s.charAt(i++));
            } else {
                numberBuf.append('0');
            }
            --scale;
        }
        try {
            long result = Long.parseLong(numberBuf.toString());
            return new MutableLong(result);
        }
        catch (NumberFormatException e) {
            Object[] parms = new Object[]{s};
            String msg = MessageLog.getMessageNoTS("STG3266E", parms);
            throw new GeneralException(msg);
        }
    }

    public IntegerFreeForm(ColumnFilter pFilter) {
        super(pFilter);
        this.escala = pFilter.clfColumn.cdScale;
    }

    public void refresh() {
        String s = "";
        ColumnFilterValue value = this.filter.clfValueList;
        if (value != null) {
            Object obj = value.fvValue;
            if (!(obj instanceof MutableLong)) {
                s = "***ERROR***";
            } else {
                MutableLong x = (MutableLong)obj;
                s = IntegerFreeForm.format(x, this.escala);
            }
        }
        this.textField.setText(s);
    }

    public void getData() throws GeneralException {
        ColumnFilterValue value;
        this.ensureNonEmpty();
        String s = this.textField.getText().trim();
        MutableLong datum = IntegerFreeForm.parse(s, this.escala);
        this.filter.clfValueList = value = new ColumnFilterValue(datum);
    }

    static {
        DecimalFormatSymbols thingy = new DecimalFormatSymbols();
        decimalPoint = thingy.getDecimalSeparator();
    }
}

