/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditorDialog;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.gui.EditableList;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.ListElementEditor;
import org.eclipse.aperi.gui.TTextField;

public abstract class MultipleEditor
implements ValueEditor,
ListElementEditor,
ActionListener {
    protected ColumnFilter filter;
    private EditableList list;
    private FreeForm smartTextField;
    protected ValueEditorDialog dialog;

    protected abstract FreeForm makeTextField(ColumnFilter var1);

    protected abstract Object toDisplayable(ColumnFilterValue var1);

    protected abstract ColumnFilterValue toStored(Object var1);

    public MultipleEditor(ColumnFilter pFilter, ValueEditorDialog pDialog) {
        this.filter = pFilter;
        this.dialog = pDialog;
        ColumnFilterValue values = this.filter.clfValueList;
        if (values == null) {
            this.dialog.setOKEnabled(false);
        }
        this.filter.clfValueList = null;
        this.smartTextField = this.makeTextField(this.filter);
        TTextField cast = (TTextField)this.smartTextField.textField;
        cast.removeActionListener(cast);
        cast.addActionListener(this);
        this.list = new EditableList("", this, null, 15);
        while (values != null) {
            this.list.addObject(this.toDisplayable(values));
            values = values.fvNext;
        }
        this.list.setAddEnabled(true);
    }

    public Component getWholeComponent() {
        return this.list;
    }

    public void getData() {
        Object[] array = this.list.getElements();
        ColumnFilterValue tail = null;
        this.filter.clfValueList = null;
        for (int i = 0; i < array.length; ++i) {
            ColumnFilterValue value = this.toStored(array[i]);
            if (tail != null) {
                tail.fvNext = value;
            } else {
                this.filter.clfValueList = value;
            }
            tail = value;
        }
    }

    public void setFocus() {
        this.smartTextField.textField.requestFocus();
    }

    public Component getComponent() {
        return this.smartTextField.getComponent();
    }

    public void setObject(Object obj) {
        ColumnFilterValue value;
        this.filter.clfValueList = value = this.toStored(obj);
        this.smartTextField.refresh();
    }

    public void setEnabled(boolean ignored) {
    }

    public Object getObject() {
        try {
            this.smartTextField.getData();
        }
        catch (GeneralException e) {
            Toolkit.getDefaultToolkit().beep();
            GuiUtil.displayException(e);
            return null;
        }
        ColumnFilterValue value = this.filter.clfValueList;
        this.filter.clfValueList = null;
        this.smartTextField.refresh();
        this.dialog.setOKEnabled(true);
        return this.toDisplayable(value);
    }

    public void objectRemoved(Object ignored) {
        if (this.list.editList.getModel().getSize() <= 0) {
            this.dialog.setOKEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent original) {
        ActionEvent forwarded = new ActionEvent(this.list.addButton, original.getID(), original.getActionCommand(), original.getModifiers());
        this.list.actionPerformed(forwarded);
    }
}

