/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.gui.PrimitiveConditionEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.TableDataSource;
import org.eclipse.aperi.gui.BaseTree;

public class SimpleMindedTable
extends JPanel {
    private static final int SPACE_ABOVE_SEPARATOR = 2;
    private static final int SPACE_BELOW_SEPARATOR = 4;
    private static final int HORIZONTAL_POOCH = 1;
    private static final int VERTICAL_POOCH = 1;
    private static final int SIDE_INSETS = 10;
    private static final int TOP_INSET = 10;
    private static final int BOTTOM_INSET = 3;
    private TableDataSource dataSource;
    private JComponent[][] cells;
    private Component[][] nullComponents;
    private int nColumns;
    private int weightedColumn;
    private Dimension[] sizes;

    public SimpleMindedTable(TableDataSource pDataSource, String[] columnNames, int maxRows, Dimension[] templateRow, int pWeightedColumn) {
        super(new GridBagLayout());
        this.dataSource = pDataSource;
        this.sizes = templateRow;
        this.weightedColumn = pWeightedColumn;
        int cellHeight = 0;
        this.nColumns = columnNames.length;
        if (templateRow.length != this.nColumns) {
            throw new RuntimeException();
        }
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 10;
        c.insets.bottom = 2;
        c.insets.left = 10;
        c.insets.right = 1;
        c.anchor = 10;
        JLabel[] labels = new JLabel[this.nColumns];
        for (int i = 0; i < this.nColumns; ++i) {
            if (cellHeight < templateRow[i].height) {
                cellHeight = templateRow[i].height;
            }
            labels[i] = new JLabel(columnNames[i], 0);
            labels[i].setFont(BaseTree.boldFont);
            Dimension labelSize = labels[i].getPreferredSize();
            if (labelSize.width < templateRow[i].width) {
                labelSize.width = templateRow[i].width;
                labels[i].setPreferredSize(labelSize);
            }
            c.weightx = i == this.weightedColumn ? 1.0 : 0.0;
            if (i == this.nColumns - 1) {
                c.gridwidth = 0;
                c.insets.right = 10;
            }
            this.add((Component)labels[i], c);
            c.insets.left = 1;
        }
        c.weightx = 0.0;
        Color background = this.getBackground();
        c.insets.top = 0;
        c.insets.bottom = 1;
        c.fill = 2;
        GridBagConstraints separatorConstraints = new GridBagConstraints();
        separatorConstraints.insets.left = 10;
        separatorConstraints.insets.right = 10;
        separatorConstraints.insets.bottom = 1;
        separatorConstraints.fill = 2;
        separatorConstraints.gridwidth = 0;
        this.cells = new JComponent[maxRows][];
        this.nullComponents = new Component[maxRows][];
        for (int i = 0; i < maxRows; ++i) {
            PrimitiveConditionEditor.HorizontalSeparator separator = new PrimitiveConditionEditor.HorizontalSeparator(background);
            this.add((Component)separator, separatorConstraints);
            c.gridwidth = 1;
            c.insets.left = 10;
            c.insets.right = 1;
            this.cells[i] = new JComponent[this.nColumns];
            this.nullComponents[i] = new Component[this.nColumns];
            for (int j = 0; j < this.nColumns; ++j) {
                this.cells[i][j] = new JPanel(new BorderLayout());
                if (j == this.nColumns - 1) {
                    c.gridwidth = 0;
                    c.insets.right = 10;
                }
                this.add((Component)this.cells[i][j], c);
                this.nullComponents[i][j] = Box.createVerticalStrut(cellHeight);
            }
        }
        separatorConstraints.gridheight = 0;
        separatorConstraints.weighty = 1.0;
        this.add(Box.createVerticalStrut(3), separatorConstraints);
        this.refresh();
    }

    public void refresh() {
        int j;
        int i;
        int nRows = this.dataSource.getRowCount();
        for (i = 0; i < nRows; ++i) {
            for (j = 0; j < this.nColumns; ++j) {
                Component component = this.dataSource.getComponentAt(i, j);
                if (component == null) {
                    component = this.nullComponents[i][j];
                }
                this.cells[i][j].removeAll();
                this.cells[i][j].add(component, "Center");
            }
        }
        while (i < this.cells.length) {
            for (j = 0; j < this.nColumns; ++j) {
                this.cells[i][j].removeAll();
                this.cells[i][j].add(this.nullComponents[i][j], "Center");
            }
            ++i;
        }
        this.validate();
        this.repaint();
    }

    public void fixNonWeighted() {
        for (int j = 0; j < this.nColumns; ++j) {
            JComponent panel = this.cells[0][j];
            Component component = panel.getComponent(0);
            if (component == this.nullComponents[0][j]) continue;
            this.sizes[j] = component.getSize();
        }
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.nColumns; ++j) {
                if (j == this.weightedColumn) continue;
                this.cells[i][j].setPreferredSize(this.sizes[j]);
                this.cells[i][j].setMinimumSize(this.sizes[j]);
                this.cells[i][j].setMaximumSize(this.sizes[j]);
            }
        }
        this.sizes = null;
    }
}

