/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;

public class StringMultipleFreeForm
extends FreeForm {
    public StringMultipleFreeForm(ColumnFilter pFilter) {
        super(pFilter);
    }

    private static boolean hasSpaces(String s) {
        boolean result = false;
        int length = s.length();
        int pos = 0;
        while (!result && pos < length) {
            char c = s.charAt(pos);
            if (Character.isWhitespace(c)) {
                result = true;
                continue;
            }
            ++pos;
        }
        return result;
    }

    public static char quoteAt(String s, int pos) {
        char c = '\u0000';
        if (s.length() > pos) {
            char ch = s.charAt(pos);
            switch (ch) {
                case '\"': 
                case '\'': {
                    c = ch;
                }
            }
        }
        return c;
    }

    private static boolean startsWithQuote(String s) {
        return StringMultipleFreeForm.quoteAt(s, 0) != '\u0000';
    }

    private static boolean needsQuoting(String s) {
        return StringMultipleFreeForm.hasSpaces(s) || StringMultipleFreeForm.startsWithQuote(s);
    }

    public static void appendQuoted(StringBuffer buf, String s) {
        int length = s.length();
        int pos = 0;
        buf.append('\"');
        while (pos < length) {
            boolean addQuote;
            int newPos = s.indexOf(34, pos);
            boolean bl = addQuote = newPos >= 0;
            newPos = addQuote ? ++newPos : length;
            buf.append(s.substring(pos, newPos));
            if (addQuote) {
                buf.append('\"');
            }
            pos = newPos;
        }
        buf.append('\"');
    }

    public void refresh() {
        boolean needSpace = false;
        StringBuffer buf = new StringBuffer(200);
        ColumnFilterValue value = this.filter.clfValueList;
        while (value != null) {
            if (needSpace) {
                buf.append(' ');
            } else {
                needSpace = true;
            }
            Object obj = value.fvValue;
            if (!(obj instanceof String)) {
                buf.append("***ERROR***");
            } else {
                String s = (String)obj;
                if (StringMultipleFreeForm.needsQuoting(s)) {
                    StringMultipleFreeForm.appendQuoted(buf, s);
                } else {
                    buf.append(s);
                }
            }
            value = value.fvNext;
        }
        this.textField.setText(buf.toString());
    }

    public static void breezeBySpace(String s, MutableInteger pos) {
        int length = s.length();
        boolean going = true;
        while (going && pos.value < length) {
            char c = s.charAt(pos.value);
            if (Character.isWhitespace(c)) {
                ++pos.value;
                continue;
            }
            going = false;
        }
    }

    public static void breezeByNonSpace(String s, MutableInteger pos) {
        int length = s.length();
        boolean going = true;
        while (going && pos.value < length) {
            char c = s.charAt(pos.value);
            if (Character.isWhitespace(c)) {
                going = false;
                continue;
            }
            ++pos.value;
        }
    }

    private static String quotedSegment(String s, MutableInteger pos, char quoteChar) {
        int length = s.length();
        StringBuffer buf = new StringBuffer(length);
        boolean going = true;
        ++pos.value;
        while (going && pos.value < length) {
            int newPos = s.indexOf(quoteChar, pos.value);
            if (newPos < 0) {
                buf.append(s.substring(pos.value));
                pos.value = length;
                continue;
            }
            char c = newPos == length - 1 ? (char)' ' : (char)s.charAt(newPos + 1);
            int skip = 1;
            if (Character.isWhitespace(c)) {
                going = false;
            } else {
                ++newPos;
                if (c != quoteChar) {
                    skip = 0;
                }
            }
            buf.append(s.substring(pos.value, newPos));
            pos.value = newPos + skip;
        }
        return buf.toString();
    }

    private static String spaceDelimitedSegment(String s, MutableInteger pos) {
        int start = pos.value;
        StringMultipleFreeForm.breezeByNonSpace(s, pos);
        return s.substring(start, pos.value);
    }

    public void getData() throws GeneralException {
        this.ensureNonEmpty();
        ColumnFilterValue tail = null;
        this.filter.clfValueList = null;
        String s = this.textField.getText();
        int length = s.length();
        MutableInteger pos = new MutableInteger();
        while (pos.value < length) {
            char quoteChar = StringMultipleFreeForm.quoteAt(s, pos.value);
            String segment = quoteChar != '\u0000' ? StringMultipleFreeForm.quotedSegment(s, pos, quoteChar) : StringMultipleFreeForm.spaceDelimitedSegment(s, pos);
            ColumnFilterValue value = new ColumnFilterValue(segment);
            if (tail != null) {
                tail.fvNext = value;
            } else {
                this.filter.clfValueList = value;
            }
            tail = value;
            StringMultipleFreeForm.breezeBySpace(s, pos);
        }
    }
}

