/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.server.guireq;

import java.io.Serializable;
import org.eclipse.aperi.TStorm.server.guireq.GuiInfoReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiSelectionReq;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;

public class GuiRequest {
    public static Request newRequest(String requestSubType, Serializable requestData) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(GuiRequest.class.getName(), "newRequest", "requestSubType, requestData");
        }
        Request request = new Request();
        GuiRequest.guiRequest(request);
        request.subType = requestSubType;
        request.requestData = requestData;
        Request traceResult = request;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(GuiRequest.class.getName(), "newRequest", traceResult);
        }
        return traceResult;
    }

    private static void guiRequest(Request request) {
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.flags = (byte)4;
    }

    public static void computerList(Request request) {
        GuiRequest.computerList(request, false);
    }

    public static void computerList(Request request, boolean excludingNAS) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq glReq = new GuiListReq();
        glReq.listRequested = 1;
        glReq.excludeNAS = excludingNAS;
        request.requestData = glReq;
    }

    public static void computerInfo(Request request, int computerID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq gir = new GuiInfoReq();
        gir.objectType = 1;
        gir.objectID = computerID;
        request.requestData = gir;
    }

    public static void clusterInfo(Request request, int clusterID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq gir = new GuiInfoReq();
        gir.objectType = 22;
        gir.objectID = clusterID;
        request.requestData = gir;
    }

    public static void selectionList(Request request) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr";
        request.requestData = new GuiSelectionReq();
    }

    public static void controllerList(Request request, int computerID, short qualifier) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq glReq = new GuiListReq();
        glReq.listRequested = 2;
        glReq.computerID = computerID;
        glReq.qualifier = qualifier;
        request.requestData = glReq;
    }

    public static void controllerList(Request request, int computerID) {
        GuiRequest.controllerList(request, computerID, (short)0);
    }

    public static void volumegroupList(Request request, int ID2, int groupID, int rankID, int cmpID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq glReq = new GuiListReq();
        glReq.listRequested = 10;
        glReq.vgID = ID2;
        glReq.rankID = rankID;
        glReq.groupID = groupID;
        glReq.computerID = cmpID;
        request.requestData = glReq;
    }

    public static void volumegroupList(Request request, int ID2, int groupID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq glReq = new GuiListReq();
        glReq.listRequested = 10;
        glReq.computerID = ID2;
        glReq.groupID = groupID;
        request.requestData = glReq;
    }

    public static void rankList(Request request, int ID2, int ctlrID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq glReq = new GuiListReq();
        glReq.listRequested = 14;
        glReq.computerID = ID2;
        glReq.controllerID = ctlrID;
        request.requestData = glReq;
    }

    public static void diskList(Request request, int computerID, int controllerID, short qualifier) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq glReq = new GuiListReq();
        glReq.listRequested = 3;
        glReq.computerID = computerID;
        glReq.controllerID = controllerID;
        glReq.qualifier = qualifier;
        request.requestData = glReq;
    }

    public static void diskList(Request request, int computerID, int controllerID) {
        GuiRequest.diskList(request, computerID, controllerID, (short)0);
    }

    public static void diskInfo(Request request, int diskID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq gir = new GuiInfoReq();
        gir.objectType = 2;
        gir.objectID = diskID;
        request.requestData = gir;
    }

    public static void lunInfo(Request request, int logicalDiskID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq gir = new GuiInfoReq();
        gir.objectType = 18;
        gir.objectID = logicalDiskID;
        request.requestData = gir;
    }

    public static void diskProbeInfo(Request request, int diskID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq gir = new GuiInfoReq();
        gir.objectType = 3;
        gir.objectID = diskID;
        request.requestData = gir;
    }

    public static void diskHistory(Request request, int diskID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq gir = new GuiInfoReq();
        gir.objectType = 4;
        gir.objectID = diskID;
        request.requestData = gir;
    }

    public static void logicalVolumeList(Request request, int computerID, int diskID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq glReq = new GuiListReq();
        glReq.listRequested = 4;
        glReq.computerID = computerID;
        glReq.diskID = diskID;
        request.requestData = glReq;
    }

    public static void logicalVolumeInfo(Request request, int lvID, int computerID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq gir = new GuiInfoReq();
        gir.objectType = 5;
        gir.objectID = lvID;
        gir.computerID = computerID;
        request.requestData = gir;
    }

    public static void exportList(Request request, int computerID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq glReq = new GuiListReq();
        glReq.listRequested = 6;
        glReq.computerID = computerID;
        request.requestData = glReq;
    }

    public static void exportInfo(Request request, int exportID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq gir = new GuiInfoReq();
        gir.objectType = 6;
        gir.objectID = exportID;
        request.requestData = gir;
    }

    public static void groupList(Request request, short groupType) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq glReq = new GuiListReq();
        glReq.listRequested = 10000 + groupType;
        request.requestData = glReq;
    }

    public static void filesystemList(Request request, int groupID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq glReq = new GuiListReq();
        glReq.listRequested = 10003;
        glReq.groupID = groupID;
        request.requestData = glReq;
    }

    public static void filesystemInfo(Request request, int fsID) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq gir = new GuiInfoReq();
        gir.objectType = 7;
        gir.objectID = fsID;
        request.requestData = gir;
    }

    public static void nasTreeList(Request request) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq glReq = new GuiListReq();
        glReq.listRequested = 8;
        request.requestData = glReq;
    }

    public static void nasFsList(Request request) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq glReq = new GuiListReq();
        glReq.listRequested = 9;
        request.requestData = glReq;
    }

    public static void manNasList(Request request) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq glReq = new GuiListReq();
        glReq.listRequested = 13;
        request.requestData = glReq;
    }

    public static Request makeDiskArrayInfoRequest(int diskArrayID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(GuiRequest.class.getName(), "makeDiskArrayInfoRequest", "diskArrayID");
        }
        GuiInfoReq gir = new GuiInfoReq();
        gir.objectType = 19;
        gir.objectID = diskArrayID;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr", gir);
        GuiRequest.guiRequest(request);
        Request traceResult = request;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(GuiRequest.class.getName(), "makeDiskArrayInfoRequest", traceResult);
        }
        return traceResult;
    }

    public static Request makeLogicalUnitRequest(int diskArrayID, int lunID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(GuiRequest.class.getName(), "makeLogicalUnitRequest", "diskArrayID, lunID");
        }
        GuiInfoReq gir = new GuiInfoReq();
        gir.objectType = 20;
        gir.objectID = lunID;
        gir.computerID = diskArrayID;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr", gir);
        GuiRequest.guiRequest(request);
        Request traceResult = request;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(GuiRequest.class.getName(), "makeLogicalUnitRequest", traceResult);
        }
        return traceResult;
    }

    public static Request makeVolumeGroupInfoRequest(int volgroupID, int cmpID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(GuiRequest.class.getName(), "makeVolumeGroupInfoRequest", "volgroupID");
        }
        GuiInfoReq gir = new GuiInfoReq();
        gir.objectType = 21;
        gir.objectID = volgroupID;
        gir.computerID = cmpID;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr", gir);
        GuiRequest.guiRequest(request);
        Request traceResult = request;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(GuiRequest.class.getName(), "makeVolumeGroupInfoRequest", traceResult);
        }
        return traceResult;
    }
}

