/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import java.io.File;
import java.io.FilenameFilter;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.aperi.agent.req.RunReq;
import org.eclipse.aperi.backend.WindowsScript;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.logging.TraceLogger;

public class JobUtil
implements FilenameFilter,
Comparator {
    public static final int RESTART = -4096;
    public static String scriptsDir = "scripts";
    private static NumberFormat schedRunFormat;
    private static NumberFormat jobRunFormat;
    private SortedMap sorter;
    private RunReq run;
    private long purgeBefore;
    private boolean purgeNecessary;

    public static void setUpScriptsDir(String rootDir) {
        StringBuffer buf = new StringBuffer(200);
        buf.append(rootDir);
        buf.append(File.separatorChar);
        buf.append("scripts");
        scriptsDir = buf.toString();
    }

    private int componentMatches(String template, String suspect, int pos) {
        int newPos = suspect.indexOf(46, pos);
        if (newPos < 0) {
            return newPos;
        }
        if (!template.regionMatches(0, suspect, pos, newPos - pos)) {
            return -1;
        }
        return newPos + 1;
    }

    public boolean accept(File dir, String name) {
        int length = name.length();
        if (length < 20) {
            return false;
        }
        if (!name.endsWith(".log")) {
            return false;
        }
        String noExt = name.substring(0, length - 4);
        int pos = noExt.indexOf(46);
        if (pos < 0) {
            return false;
        }
        File file = new File(dir, name);
        long ts = file.lastModified();
        if (ts < this.purgeBefore) {
            return true;
        }
        if (this.sorter == null) {
            return false;
        }
        if (!name.regionMatches(0, this.run.getSchedCreator(), 0, pos)) {
            return false;
        }
        pos = this.componentMatches(this.run.getSchedName(), name, pos + 1);
        if (pos < 0) {
            return false;
        }
        if ((pos = name.indexOf(95, pos)) < 0) {
            return false;
        }
        if (this.componentMatches(this.run.getJobName(), name, pos + 1) >= 0) {
            Long key = new Long(ts);
            this.sorter.put(key, name);
        }
        return false;
    }

    public int compare(Object pLeft, Object pRight) {
        Long left = (Long)pLeft;
        Long right = (Long)pRight;
        return -left.compareTo(right);
    }

    private JobUtil(RunReq pRun) {
        this.run = pRun;
        if (this.run.getRetainDays() <= 0) {
            this.purgeBefore = Long.MIN_VALUE;
        } else {
            long delta = this.run.getRetainDays();
            delta *= 86400000L;
            if (Variables.whoAmI == 2) {
                this.purgeBefore = System.currentTimeMillis() - delta;
                this.purgeNecessary = true;
            } else {
                try {
                    this.purgeBefore = CurrentTime.getTimestamp().getTime() - delta;
                    this.purgeNecessary = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception(JobUtil.class.getName(), "constructor", e);
                    }
                    return;
                }
            }
        }
        if (this.run.getRetention() > 0) {
            this.sorter = new TreeMap(this);
            this.purgeNecessary = true;
        }
    }

    public static void purgeLogFiles(RunReq pRun, String dirPath) {
        File file;
        JobUtil purger = new JobUtil(pRun);
        if (!purger.purgeNecessary) {
            return;
        }
        File dir = new File(dirPath);
        String[] files = dir.list(purger);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                file = new File(dir, files[i]);
                file.delete();
            }
        }
        if (purger.sorter == null) {
            return;
        }
        int count = 0;
        Iterator iterator = purger.sorter.values().iterator();
        while (iterator.hasNext()) {
            String name = iterator.next().toString();
            if (++count <= pRun.getRetention()) continue;
            file = new File(dir, name);
            file.delete();
        }
    }

    public static WindowsScript resolveWindowsScript(String unresolved, StringBuffer extBuf) {
        WindowsScript result = null;
        String extension = null;
        int dot = unresolved.lastIndexOf(46);
        if (dot >= 0) {
            File file = new File(scriptsDir + File.separatorChar + unresolved);
            if (file.exists()) {
                extension = unresolved.substring(dot + 1);
                int i = WindowsScript.indexForExtension(extension);
                result = new WindowsScript(i, unresolved);
            }
        } else {
            int min = Integer.MAX_VALUE;
            String resolved = null;
            File dir = new File(scriptsDir);
            Matcher matcher = new Matcher(unresolved);
            String[] found = dir.list(matcher);
            if (found != null) {
                for (int j = 0; j < found.length; ++j) {
                    extension = found[j].substring(matcher.length);
                    int i = WindowsScript.indexForExtension(extension);
                    if (i >= min) continue;
                    min = i;
                    resolved = found[j];
                }
                if (resolved != null) {
                    result = new WindowsScript(min, resolved);
                    if (extBuf != null) {
                        extBuf.append(extension);
                    }
                }
            }
        }
        return result;
    }

    public static WindowsScript resolveWindowsScript(String unresolved) {
        return JobUtil.resolveWindowsScript(unresolved, null);
    }

    public static String resolveUnixScript(String unresolved, StringBuffer buf) {
        File file;
        int dot = unresolved.lastIndexOf(46);
        if (dot >= 0) {
            unresolved = unresolved.substring(0, dot);
        }
        if (buf != null) {
            buf.append(unresolved);
        }
        if (!(file = new File(scriptsDir + File.separatorChar + unresolved)).exists()) {
            unresolved = null;
        }
        return unresolved;
    }

    public static String resolveUnixScript(String unresolved) {
        return JobUtil.resolveUnixScript(unresolved, null);
    }

    private static class Matcher
    implements FilenameFilter {
        private String root;
        public int length;

        public Matcher(String pRoot) {
            this.root = pRoot + '.';
            this.length = this.root.length();
        }

        public boolean accept(File dir, String name) {
            return this.root.regionMatches(true, 0, name, 0, this.length);
        }
    }
}

