/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import java.util.HashMap;
import org.eclipse.aperi.common.LockRequestor;
import org.eclipse.aperi.common.LockResource;
import org.eclipse.aperi.logging.TraceLogger;

public class LockManager {
    public static final boolean WAIT = true;
    public static final boolean NOWAIT = false;
    private static HashMap[] productLockMaps;

    public static void initProductLockMaps() {
        productLockMaps = new HashMap[5];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean lock(short productID, String resourceType, String resourceName, byte lockType, boolean waitForLock) {
        HashMap lockMap;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockManager.class.getName(), "lock", "productID, resourceType, resourceName, lockType, waitForLock");
        }
        if ((lockMap = productLockMaps[productID]) == null) {
            HashMap[] hashMapArray = productLockMaps;
            // MONITORENTER : productLockMaps
            if (productLockMaps[productID] == null) {
                LockManager.productLockMaps[productID] = new HashMap();
            }
            lockMap = productLockMaps[productID];
            // MONITOREXIT : hashMapArray
        }
        String hashKey = LockManager.makeHashKey(resourceType, resourceName);
        LockRequestor lrq = LockRequestor.getLockRequestor(lockType);
        HashMap hashMap = lockMap;
        // MONITORENTER : hashMap
        LockResource lrs = LockManager.getLockResource(lockMap, hashKey, productID, true);
        boolean gotLock = LockManager.lock(lrs, lrq, waitForLock);
        // MONITOREXIT : hashMap
        if (!gotLock) {
            if (waitForLock) {
                boolean traceResult = LockManager.waitOnLock(lrq);
                if (!TraceLogger.enableTrace) return traceResult;
                TraceLogger.exit(LockManager.class.getName(), "lock", traceResult);
                return traceResult;
            }
            lrq.returnLockRequestor();
        }
        boolean traceResult = gotLock;
        if (!TraceLogger.enableTrace) return traceResult;
        TraceLogger.exit(LockManager.class.getName(), "lock", traceResult);
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unLock(short productID, String resourceType, String resourceName) {
        HashMap lockMap;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockManager.class.getName(), "unLock", "productID, resourceType, resourceName");
        }
        if ((lockMap = productLockMaps[productID]) == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(LockManager.class.getName(), "unLock");
            }
            return;
        }
        String hashKey = LockManager.makeHashKey(resourceType, resourceName);
        HashMap hashMap = lockMap;
        synchronized (hashMap) {
            LockResource lrs = LockManager.getLockResource(lockMap, hashKey, productID, false);
            if (lrs != null) {
                LockManager.unLock(lrs, lockMap, hashKey);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockManager.class.getName(), "unLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LockResource lockQuery(short productID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockManager.class.getName(), "lockQuery", "productID");
        }
        LockResource lockList = null;
        HashMap lockMap = productLockMaps[productID];
        if (lockMap == null) {
            LockResource traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(LockManager.class.getName(), "lockQuery", traceResult);
            }
            return traceResult;
        }
        HashMap traceResult = lockMap;
        synchronized (traceResult) {
            for (LockResource a : lockMap.values()) {
                LockResource b = LockManager.makeQueryCopy(a);
                b.lrsNext = lockList;
                lockList = b;
            }
        }
        traceResult = lockList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockManager.class.getName(), "lockQuery", traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LockResource lockQuery(short productID, String resourceType, String resourceName) {
        HashMap lockMap;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockManager.class.getName(), "lockQuery", "productID, resourceType, resourceName");
        }
        if ((lockMap = productLockMaps[productID]) != null) {
            String hashKey = LockManager.makeHashKey(resourceType, resourceName);
            HashMap hashMap = lockMap;
            synchronized (hashMap) {
                LockResource a = LockManager.getLockResource(lockMap, hashKey, productID, false);
                if (a != null) {
                    LockResource traceResult = LockManager.makeQueryCopy(a);
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit(LockManager.class.getName(), "lockQuery", traceResult);
                    }
                    return traceResult;
                }
            }
        }
        LockResource traceResult = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockManager.class.getName(), "lockQuery", traceResult);
        }
        return traceResult;
    }

    public static native void lockJavaObject(Object var0);

    public static native void unLockJavaObject(Object var0);

    private static LockResource makeQueryCopy(LockResource a) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockManager.class.getName(), "makeQueryCopy", "a");
        }
        LockResource b = (LockResource)a.clone();
        LockRequestor lrq = b.lrsHolders;
        while (lrq != null) {
            lrq.lrqThread = ((Thread)lrq.lrqThread).toString();
            lrq = lrq.lrqNext;
        }
        lrq = b.lrsWaitersHead;
        while (lrq != null) {
            lrq.lrqThread = ((Thread)lrq.lrqThread).toString();
            lrq = lrq.lrqNext;
        }
        LockResource traceResult = b;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockManager.class.getName(), "makeQueryCopy", traceResult);
        }
        return traceResult;
    }

    private static String makeHashKey(String resourceType, String resourceName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockManager.class.getName(), "makeHashKey", "resourceType, resourceName");
        }
        StringBuffer buffer = new StringBuffer(40);
        buffer.append(resourceType);
        buffer.append('.');
        buffer.append(resourceName);
        String traceResult = buffer.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockManager.class.getName(), "makeHashKey", traceResult);
        }
        return traceResult;
    }

    private static LockResource getLockResource(HashMap lockMap, String hashKey, short productID, boolean create) {
        LockResource lrs;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockManager.class.getName(), "getLockResource", "lockMap, hashKey, productID, create");
        }
        if ((lrs = (LockResource)lockMap.get(hashKey)) == null && create) {
            lrs = LockResource.getLockResource(productID, hashKey);
            lockMap.put(hashKey, lrs);
        }
        LockResource traceResult = lrs;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockManager.class.getName(), "getLockResource", traceResult);
        }
        return traceResult;
    }

    private static boolean lock(LockResource lrs, LockRequestor lrq, boolean waitForLock) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockManager.class.getName(), "lock", "lrs, lrq, waitForLock");
        }
        if (lrs.lrsHolders == null || lrs.lrsWaitersHead == null && lrq.lrqLockType == 2 && lrs.lrsHolders.lrqLockType == 2) {
            LockManager.grantLock(lrs, lrq);
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(LockManager.class.getName(), "lock", traceResult);
            }
            return traceResult;
        }
        if (waitForLock) {
            LockManager.queueWaiter(lrs, lrq);
        }
        boolean traceResult = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockManager.class.getName(), "lock", traceResult);
        }
        return traceResult;
    }

    private static void unLock(LockResource lrs, HashMap lockMap, String hashKey) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockManager.class.getName(), "unLock", "lrs, lockMap, hashKey");
        }
        LockRequestor prevLrq = null;
        Thread thread = Thread.currentThread();
        LockRequestor lrq = lrs.lrsHolders;
        while (lrq != null && thread != (Thread)lrq.lrqThread) {
            prevLrq = lrq;
            lrq = lrq.lrqNext;
        }
        if (lrq == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(LockManager.class.getName(), "unLock");
            }
            return;
        }
        if (prevLrq == null) {
            lrs.lrsHolders = lrq.lrqNext;
        } else {
            prevLrq.lrqNext = lrq.lrqNext;
        }
        lrq.returnLockRequestor();
        if (lrs.lrsHolders == null) {
            while (lrs.lrsWaitersHead != null && (lrs.lrsHolders == null || lrs.lrsWaitersHead.lrqLockType != 1 && lrs.lrsHolders.lrqLockType != 1)) {
                lrq = LockManager.dequeueWaiter(lrs);
                LockManager.grantLock(lrs, lrq);
                ((Thread)lrq.lrqThread).interrupt();
            }
            if (lrs.lrsHolders == null) {
                lockMap.remove(hashKey);
                lrs.returnLockResource();
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockManager.class.getName(), "unLock");
        }
    }

    private static boolean waitOnLock(LockRequestor lrq) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockManager.class.getName(), "waitOnLock", "lrq");
        }
        while (!lrq.lrqHaveLock) {
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException e) {
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.exception(LockManager.class.getName(), "waitOnLock", e);
            }
        }
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockManager.class.getName(), "waitOnLock", traceResult);
        }
        return traceResult;
    }

    private static void grantLock(LockResource lrs, LockRequestor lrq) {
        lrq.lrqNext = lrs.lrsHolders;
        lrs.lrsHolders = lrq;
        lrq.lrqTimestamp = System.currentTimeMillis();
        lrq.lrqHaveLock = true;
    }

    private static void queueWaiter(LockResource lrs, LockRequestor lrq) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockManager.class.getName(), "queueWaiter", "lrs, lrq");
        }
        lrq.lrqNext = null;
        lrq.lrqTimestamp = System.currentTimeMillis();
        if (lrs.lrsWaitersTail != null) {
            lrs.lrsWaitersTail.lrqNext = lrq;
        } else {
            lrs.lrsWaitersHead = lrq;
        }
        lrs.lrsWaitersTail = lrq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockManager.class.getName(), "queueWaiter");
        }
    }

    private static LockRequestor dequeueWaiter(LockResource lrs) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockManager.class.getName(), "dequeueWaiter", "lrs");
        }
        LockRequestor lrq = lrs.lrsWaitersHead;
        lrs.lrsWaitersHead = lrq.lrqNext;
        if (lrs.lrsWaitersHead == null) {
            lrs.lrsWaitersTail = null;
        }
        LockRequestor traceResult = lrq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockManager.class.getName(), "dequeueWaiter", traceResult);
        }
        return traceResult;
    }

    static {
        LockManager.initProductLockMaps();
    }
}

