/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import java.io.PrintWriter;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.ReadLogRequest;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class LogFileReader {
    private static Class requestDataClass;

    protected abstract MutableInteger open(ReadLogRequest var1, Response var2);

    protected abstract int read(MutableInteger var1, LogFilePos var2, ReadLogRequest var3, ReadLogResponse var4, Response var5);

    protected abstract boolean setPosition(MutableInteger var1, ReadLogRequest var2, LogFilePos var3);

    protected native int openFile(String var1, int var2) throws LocalizableException;

    private native int readBackwards(int var1, String[] var2, int var3) throws LocalizableException;

    private native int readForwards(int var1, String[] var2, int var3) throws LocalizableException;

    protected native int getFilePosition(int var1);

    protected native void setFilePosition(int var1, int var2);

    protected native void closeFile(int var1);

    private void close(MutableInteger handle) {
        this.closeFile(handle.value);
    }

    protected int basicRead(int fd, LogFilePos pos, ReadLogRequest requestData, String[] lineArray, int alreadyDone, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LogFileReader.class.getName(), "basicRead", "fd, pos, requestData, lineArray, alreadyDone, response");
        }
        int result = -1;
        byte direction = requestData.direction;
        try {
            result = direction == 1 ? this.readForwards(fd, lineArray, alreadyDone) : this.readBackwards(fd, lineArray, lineArray.length - alreadyDone);
            pos.offset = this.getFilePosition(fd);
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(LogFileReader.class.getName(), "basicRead", e);
            }
            e.getParameters()[0] = requestData.name;
            response.errorMessage = e.getMessage();
        }
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LogFileReader.class.getName(), "basicRead", traceResult);
        }
        return traceResult;
    }

    private void searchForward(ReadLogResponse resp, int upTo, String searchFor) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LogFileReader.class.getName(), "searchForward", "resp, upTo, searchFor");
        }
        String[] lineArray = resp.lineArray;
        int length = searchFor.length();
        int index = 0;
        int pos = 0;
        boolean going = true;
        while (going && index < upTo) {
            String target = lineArray[index];
            int maxPos = target.length() - length;
            pos = 0;
            while (going && pos <= maxPos) {
                if (target.regionMatches(true, pos, searchFor, 0, length)) {
                    going = false;
                    continue;
                }
                ++pos;
            }
            if (!going) continue;
            ++index;
        }
        if (!going) {
            resp.status = 0;
            resp.foundIndex = index;
            resp.foundOffset = pos;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LogFileReader.class.getName(), "searchForward");
        }
    }

    private void searchBackward(ReadLogResponse resp, int backTo, String searchFor) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LogFileReader.class.getName(), "searchBackward", "resp, backTo, searchFor");
        }
        String[] lineArray = resp.lineArray;
        int length = searchFor.length();
        int index = lineArray.length - 1;
        int pos = 0;
        boolean going = true;
        while (going && index >= backTo) {
            String target = lineArray[index];
            pos = target.length() - length;
            while (going && pos >= 0) {
                if (target.regionMatches(true, pos, searchFor, 0, length)) {
                    going = false;
                    continue;
                }
                --pos;
            }
            if (!going) continue;
            --index;
        }
        if (!going) {
            resp.status = 0;
            resp.foundIndex = index;
            resp.foundOffset = pos;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LogFileReader.class.getName(), "searchBackward");
        }
    }

    private int doSearch(MutableInteger handle, ReadLogRequest rq, Response response, ReadLogResponse responseData) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LogFileReader.class.getName(), "doSearch", "handle, rq, response, responseData");
        }
        byte direction = rq.direction;
        responseData.status = 1;
        LogFilePos oldPos = new LogFilePos(rq.position);
        int count = 0;
        int result = 0;
        while (responseData.status != 0 && (result = this.read(handle, rq.position, rq, responseData, response)) > 0) {
            ++count;
            if (direction == 1) {
                this.searchForward(responseData, result, rq.searchFor);
            } else {
                this.searchBackward(responseData, responseData.lineArray.length - result, rq.searchFor);
            }
            if (responseData.status == 0) continue;
            rq.position.copy(oldPos);
        }
        if (result == 0) {
            responseData.lineArray = null;
            response.status = 0;
            response.responseData = responseData;
            result = -1;
        } else if (result > 0) {
            if (direction == 1) {
                responseData.start = oldPos;
                responseData.end = rq.position;
            } else {
                responseData.start = rq.position;
                responseData.end = oldPos;
            }
            if (result < responseData.lineArray.length && count > 1 && this.setPosition(handle, rq, oldPos)) {
                String[] oldArray = responseData.lineArray;
                responseData.lineArray = new String[oldArray.length - result];
                Response temp = new Response(0, null);
                rq.direction = -direction;
                int newRead = this.read(handle, oldPos, rq, responseData, temp);
                if (newRead < 0) {
                    if (temp.errorMessage != null) {
                        PrintWriter out = MessageLog.getThreadLog();
                        out.println(temp.errorMessage);
                    }
                } else if (newRead > 0) {
                    String[] intermediate;
                    if (result + newRead <= oldArray.length) {
                        intermediate = oldArray;
                    } else {
                        intermediate = new String[result + newRead];
                        if (direction == -1) {
                            responseData.foundIndex += result + newRead - oldArray.length;
                        }
                    }
                    if (direction == 1) {
                        System.arraycopy(oldArray, 0, intermediate, newRead, result);
                    } else {
                        System.arraycopy(oldArray, oldArray.length - result, intermediate, intermediate.length - result - newRead, result);
                    }
                    responseData.foundIndex += direction * newRead;
                    oldArray = intermediate;
                    String[] src = responseData.lineArray;
                    if (direction == 1) {
                        System.arraycopy(src, src.length - newRead, oldArray, 0, newRead);
                    } else {
                        System.arraycopy(src, 0, oldArray, oldArray.length - newRead, newRead);
                    }
                    result += newRead;
                }
                responseData.lineArray = oldArray;
            }
        }
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LogFileReader.class.getName(), "doSearch", traceResult);
        }
        return traceResult;
    }

    private void trim(ReadLogResponse resp, int linesRead, byte direction) {
        int startIndex;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LogFileReader.class.getName(), "trim", "resp, linesRead, direction");
        }
        String[] oldArray = resp.lineArray;
        String[] newArray = new String[linesRead];
        if (direction == 1) {
            startIndex = 0;
        } else {
            startIndex = oldArray.length - linesRead;
            resp.foundIndex -= startIndex;
        }
        System.arraycopy(oldArray, startIndex, newArray, 0, linesRead);
        resp.lineArray = newArray;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LogFileReader.class.getName(), "trim");
        }
    }

    public void handle(Request request, Response response) {
        int linesRead;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LogFileReader.class.getName(), "handle", "request, response");
        }
        if (!RequestChecker.isDesiredType(requestDataClass, request, response)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(LogFileReader.class.getName(), "handle");
            }
            return;
        }
        ReadLogRequest requestData = (ReadLogRequest)request.requestData;
        MutableInteger handl = this.open(requestData, response);
        if (handl == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(LogFileReader.class.getName(), "handle");
            }
            return;
        }
        ReadLogResponse responseData = new ReadLogResponse();
        responseData.lineArray = new String[requestData.linesDesired];
        byte direction = requestData.direction;
        if (requestData.searchFor != null) {
            linesRead = this.doSearch(handl, requestData, response, responseData);
        } else {
            LogFilePos current = requestData.position;
            LogFilePos initial = new LogFilePos(current);
            linesRead = this.read(handl, current, requestData, responseData, response);
            if (linesRead >= 0) {
                if (direction == 1) {
                    responseData.start = initial;
                    responseData.end = current;
                } else {
                    responseData.start = current;
                    responseData.end = initial;
                }
            }
        }
        if (linesRead >= 0) {
            if (linesRead < requestData.linesDesired) {
                this.trim(responseData, linesRead, direction);
            }
            response.responseData = responseData;
            response.status = 0;
        }
        this.close(handl);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LogFileReader.class.getName(), "handle");
        }
    }

    static {
        ReadLogRequest object = new ReadLogRequest();
        requestDataClass = object.getClass();
    }
}

