/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class RequestChecker {
    public static void errorResponse(String id, Object[] args, Response response) {
        String message = MessageLog.getMessage(id, args);
        response.status = (short)12;
        response.errorMessage = message;
        response.responseData = null;
    }

    public static boolean objectNotNull(Class desired, Object object, Response response, String id) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(RequestChecker.class.getName(), "objectNotNull", "desired, object, response, id");
        }
        if (object != null) {
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(RequestChecker.class.getName(), "objectNotNull", traceResult);
            }
            return traceResult;
        }
        Object[] args = new Object[]{desired.getName(), "null"};
        RequestChecker.errorResponse(id, args, response);
        boolean traceResult = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(RequestChecker.class.getName(), "objectNotNull", traceResult);
        }
        return traceResult;
    }

    public static boolean objectIsDesiredType(Class desired, Object object, Response response, String id) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(RequestChecker.class.getName(), "objectIsDesiredType", "desired, object, response, id");
        }
        if (desired.isInstance(object)) {
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(RequestChecker.class.getName(), "objectIsDesiredType", traceResult);
            }
            return traceResult;
        }
        if (RequestChecker.objectNotNull(desired, object, response, id)) {
            Object[] args = new Object[]{desired.getName(), object.getClass().getName()};
            RequestChecker.errorResponse(id, args, response);
        }
        boolean traceResult = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(RequestChecker.class.getName(), "objectIsDesiredType", traceResult);
        }
        return traceResult;
    }

    public static boolean hasData(Class desired, Request request, Response response) {
        return RequestChecker.objectNotNull(desired, request.requestData, response, "GEN0022E");
    }

    public static boolean isDesiredType(Class desired, Request request, Response response) {
        return RequestChecker.objectIsDesiredType(desired, request.requestData, response, "GEN0022E");
    }
}

