/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.io.Serializable;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.ReusableObjectPool;

public class LockRequestor
implements Serializable,
Cloneable,
Packable {
    static final long serialVersionUID = -3764866797589334770L;
    public LockRequestor lrqNext;
    public Object lrqThread;
    public long lrqTimestamp;
    public byte lrqLockType;
    public boolean lrqHaveLock;
    public static final byte EXCLUSIVE = 1;
    public static final byte SHARED = 2;
    private static ReusableObjectPool pool = new ReusableObjectPool(40);

    public static LockRequestor getLockRequestor(byte lockType) {
        LockRequestor requestor;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockRequestor.class.getName(), "getLockRequestor", "lockType");
        }
        if ((requestor = (LockRequestor)pool.getObject()) == null) {
            requestor = new LockRequestor();
        }
        requestor.lrqThread = Thread.currentThread();
        requestor.lrqLockType = lockType;
        requestor.lrqHaveLock = false;
        LockRequestor traceResult = requestor;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockRequestor.class.getName(), "getLockRequestor", traceResult);
        }
        return traceResult;
    }

    public void returnLockRequestor() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockRequestor.class.getName(), "returnLockRequestor", "");
        }
        this.lrqNext = null;
        this.lrqThread = null;
        pool.returnObject(this);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockRequestor.class.getName(), "returnLockRequestor");
        }
    }

    public Object clone() {
        LockRequestor copy = LockRequestor.getLockRequestor(this.lrqLockType);
        copy.lrqThread = this.lrqThread;
        copy.lrqHaveLock = this.lrqHaveLock;
        copy.lrqTimestamp = this.lrqTimestamp;
        return copy;
    }

    public Packable getNext() {
        return this.lrqNext;
    }

    public void setNext(Packable next) {
        this.lrqNext = (LockRequestor)next;
    }
}

