/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.api;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.sblim.wbem.cim.CIMProperty;

public class DeviceStatus {
    public static final DeviceStatus INVALID = new DeviceStatus(new int[]{-1});
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private static final int[] OKS = new int[]{2};
    private static final int[] WARNINGS = new int[]{0, 3, 4, 8, 9, 11};
    private static final int[] ERRORS = new int[]{5, 6, 7, 10, 12, 13, 14, 15, 16, 17, 18};
    private int[] cStatus = null;

    public DeviceStatus(int[] pStatus) {
        this.cStatus = pStatus;
    }

    public DeviceStatus(CIMProperty pOperationalStatus) {
        if (!pOperationalStatus.getName().equalsIgnoreCase("OperationalStatus")) {
            throw new IllegalArgumentException();
        }
        Vector mOpStatus = (Vector)pOperationalStatus.getValue().getValue();
        this.cStatus = new int[mOpStatus.size()];
        for (int i = 0; i < mOpStatus.size(); ++i) {
            this.cStatus[i] = ((Number)mOpStatus.get(i)).intValue();
        }
    }

    public DeviceStatus(List pStatus) {
        this.cStatus = new int[pStatus.size()];
        for (int i = 0; i < pStatus.size(); ++i) {
            this.cStatus[i] = Integer.parseInt(pStatus.get(i).toString());
        }
    }

    public int getStatusValue(int pIndex) {
        return this.cStatus[pIndex];
    }

    public String getStatusString() {
        StringBuffer mResult = new StringBuffer();
        mResult.append("[");
        for (int i = 0; i < this.cStatus.length; ++i) {
            if (i > 0) {
                mResult.append(",");
            }
            mResult.append(Integer.toString(this.cStatus[i]));
        }
        mResult.append("]");
        return mResult.toString();
    }

    public int getStatusCount() {
        return this.cStatus.length;
    }

    public boolean isInvalid() {
        return this.equals(INVALID);
    }

    public boolean isOK() {
        return this.contains(OKS) && !this.contains(WARNINGS) && !this.contains(ERRORS);
    }

    public boolean isWarning() {
        return !this.contains(ERRORS) && (this.contains(WARNINGS) || !this.contains(OKS));
    }

    public boolean isError() {
        return this.contains(ERRORS);
    }

    public int getConsolidatedState() {
        return this.isOK() ? 0 : (this.isError() ? 2 : 1);
    }

    public boolean isDisconnected() {
        return this.isInvalid() || Arrays.binarySearch(this.cStatus, 12) >= 0 || Arrays.binarySearch(this.cStatus, 13) >= 0;
    }

    private boolean contains(int[] pKeys) {
        for (int i = 0; i < this.cStatus.length; ++i) {
            if (Arrays.binarySearch(pKeys, this.cStatus[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.isInvalid()) {
            return "INVALID";
        }
        StringBuffer mResult = new StringBuffer();
        mResult.append("{values=[");
        for (int i = 0; i < this.cStatus.length; ++i) {
            if (i > 0) {
                mResult.append(",");
            }
            mResult.append(Integer.toString(this.cStatus[i]));
        }
        mResult.append("]");
        mResult.append(",c=" + String.valueOf(this.getConsolidatedState()));
        mResult.append(this.isOK() ? ", green" : "");
        mResult.append(this.isWarning() ? ", yellow" : "");
        mResult.append(this.isError() ? ", red" : "");
        mResult.append(this.isDisconnected() ? ", disconnected}" : "}");
        return mResult.toString();
    }

    public static void main(String[] args) {
        DeviceStatus mStatus = new DeviceStatus(new int[]{2});
        System.out.println("test 1: " + mStatus.toString());
        mStatus = new DeviceStatus(new int[]{2, 3});
        System.out.println("test 2: " + mStatus.toString());
        mStatus = new DeviceStatus(new int[]{3});
        System.out.println("test 3: " + mStatus.toString());
        mStatus = new DeviceStatus(new int[]{2, 3, 6});
        System.out.println("test 4: " + mStatus.toString());
        mStatus = new DeviceStatus(new int[]{2, 3, 13});
        System.out.println("test 5: " + mStatus.toString());
        mStatus = new DeviceStatus(new int[]{13});
        System.out.println("test 6: " + mStatus.toString());
        mStatus = new DeviceStatus(new int[]{0});
        System.out.println("test 7: " + mStatus.toString());
        mStatus = new DeviceStatus(new int[]{1});
        System.out.println("test 7: " + mStatus.toString());
        mStatus = new DeviceStatus(new int[]{2, 1});
        System.out.println("test 7: " + mStatus.toString());
    }
}

