/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.api;

import java.io.Serializable;
import org.eclipse.aperi.common.api.Distinguishable;

public class SRMVersion
implements Cloneable,
Comparable,
Serializable,
Distinguishable {
    private static final String version = "5.0.0";
    private static final String equiv = "5.0.0";
    private static final String incomp = "4.9.9";
    private static final String[] features = new String[0];
    private String strSerVersion;
    private String strSerEquiv;
    private String strSerIncomp;
    private String[] astrSerFeatures;
    static final long serialVersionUID = -470009297440056011L;

    public SRMVersion() {
        this.strSerVersion = "5.0.0";
        this.strSerEquiv = this.getLocalEquivalenceLevel();
        this.strSerIncomp = this.getLocalIncompatibilityLevel();
        this.astrSerFeatures = this.getLocalFeatureList();
    }

    public SRMVersion(SRMVersion ver) {
        this.strSerVersion = ver.strSerVersion;
        this.strSerEquiv = ver.strSerEquiv;
        this.strSerIncomp = ver.strSerIncomp;
        this.astrSerFeatures = new String[ver.astrSerFeatures.length];
        for (int i = this.astrSerFeatures.length - 1; i >= 0; --i) {
            this.astrSerFeatures[i] = ver.astrSerFeatures[i];
        }
    }

    public final String getVersion() {
        return this.strSerVersion;
    }

    public String getCheckableVersion() {
        return SRMVersion.getCheckableVersion(this.strSerVersion);
    }

    public String getEquivalenceLevel() {
        return this.strSerEquiv;
    }

    public String getIncompatibilityLevel() {
        return this.strSerIncomp;
    }

    public String[] getFeatureList() {
        return this.astrSerFeatures;
    }

    public static final String getLocalVersion() {
        return "5.0.0";
    }

    public String getLocalEquivalenceLevel() {
        return "5.0.0";
    }

    public String getLocalIncompatibilityLevel() {
        return incomp;
    }

    public String[] getLocalFeatureList() {
        return features;
    }

    public boolean isCompatible() {
        SRMVersion localVersion = null;
        try {
            localVersion = (SRMVersion)this.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.isCompatible(localVersion);
    }

    protected boolean isCompatible(SRMVersion obj) {
        String ver1 = SRMVersion.getCheckableVersion(this.strSerVersion);
        String ver2 = SRMVersion.getCheckableVersion(obj.getVersion());
        String equ = SRMVersion.getCheckableVersion(this.strSerEquiv);
        String inc = SRMVersion.getCheckableVersion(obj.getIncompatibilityLevel());
        return SRMVersion.compareVersionStrings(ver1, ver2) == 0 || SRMVersion.compareVersionStrings(ver1, ver2) < 0 && SRMVersion.compareVersionStrings(ver1, inc) > 0 || SRMVersion.compareVersionStrings(ver1, ver2) > 0 && SRMVersion.compareVersionStrings(equ, ver2) <= 0;
    }

    public static int compareVersionStrings(String strVer1, String strVer2) {
        long lVersion2;
        long lVersion1 = SRMVersion.convertVersion(strVer1);
        return lVersion1 == (lVersion2 = SRMVersion.convertVersion(strVer2)) ? 0 : (lVersion1 < lVersion2 ? -1 : 1);
    }

    public boolean isFeatureSupported(String feature) {
        for (int i = this.astrSerFeatures.length - 1; i >= 0; --i) {
            if (!feature.equalsIgnoreCase(this.astrSerFeatures[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isFeatureSupportedLocally(String feature) {
        String[] list = this.getLocalFeatureList();
        for (int i = list.length - 1; i >= 0; --i) {
            if (!feature.equalsIgnoreCase(list[i])) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object tvObj) {
        if (tvObj instanceof SRMVersion) {
            return this.strSerVersion.equals(((SRMVersion)tvObj).strSerVersion);
        }
        return false;
    }

    public int compareTo(Object obj) {
        return SRMVersion.compareVersionStrings(this.strSerVersion, ((SRMVersion)obj).strSerVersion);
    }

    public boolean isIdentical(Object obj) {
        boolean bIdentical = false;
        if (obj instanceof SRMVersion && ((SRMVersion)obj).strSerVersion.equals(this.strSerVersion) && ((SRMVersion)obj).strSerEquiv.equals(this.strSerEquiv) && ((SRMVersion)obj).strSerIncomp.equals(this.strSerIncomp) && ((SRMVersion)obj).astrSerFeatures.length == this.astrSerFeatures.length) {
            bIdentical = true;
            for (int i = this.astrSerFeatures.length - 1; i >= 0; --i) {
                if (((SRMVersion)obj).astrSerFeatures[i].equals(this.astrSerFeatures[i])) continue;
                bIdentical = false;
                break;
            }
        }
        return bIdentical;
    }

    public String toString() {
        return "SRMVersion@" + Integer.toHexString(this.hashCode()) + " (ver=" + this.strSerVersion + ", equ=" + this.strSerEquiv + ", inc=" + this.strSerIncomp + ")";
    }

    public Object clone() {
        SRMVersion tvNew = null;
        try {
            tvNew = (SRMVersion)super.clone();
            tvNew.astrSerFeatures = new String[this.astrSerFeatures.length];
            for (int i = this.astrSerFeatures.length - 1; i >= 0; --i) {
                tvNew.astrSerFeatures[i] = this.astrSerFeatures[i];
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return tvNew;
    }

    private static String getCheckableVersion(String ver) {
        int lastIndex = -1;
        for (int i = 0; i < 3 && (lastIndex = ver.indexOf(46, lastIndex + 1)) != -1; ++i) {
        }
        if (lastIndex > 0) {
            return ver.substring(0, lastIndex);
        }
        return ver;
    }

    private static long convertVersion(String strVersion) {
        long lVer = 0L;
        for (int i = 0; i < 4; ++i) {
            String strCur;
            int iIdx = strVersion.indexOf(46);
            if (iIdx == -1) {
                strCur = strVersion;
                strVersion = "";
            } else {
                strCur = strVersion.substring(0, iIdx);
                strVersion = strVersion.substring(iIdx + 1);
            }
            lVer *= 65536L;
            if (strCur.length() <= 0) continue;
            try {
                lVer += (long)Short.parseShort(strCur);
                continue;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return lVer;
    }
}

