/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.control.TokenHeartbeat;
import org.eclipse.aperi.control.data.ControlConstants;
import org.eclipse.aperi.control.data.JobInfo;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.IControlEngine;
import org.eclipse.aperi.control.interfaces.InvalidTokenException;
import org.eclipse.aperi.control.interfaces.JobInProgressException;
import org.eclipse.aperi.disk.resources.DMJobMessages;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.interfaces.IController;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class ControlEngine
implements IControlEngine {
    private static ControlEngine instance = null;
    private Integer tokenTimeout = null;
    private ArrayList<Token> validTokens = new ArrayList();
    private Token internalToken = null;
    public Hashtable tokenTable = new Hashtable();
    private Hashtable subJobStatus = new Hashtable();
    private Hashtable jobsBelongingToTokens = new Hashtable();
    ILogger msgLogger = ControlConstants.msgLogger;
    ILogger traceLogger = ControlConstants.traceLogger;
    static final String className = ControlEngine.class.getName();

    public static synchronized ControlEngine getInstance() {
        if (instance == null) {
            instance = new ControlEngine();
        }
        return instance;
    }

    private ControlEngine() {
        String methodName = "ControlEngine";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        this.internalToken = new Token("internalToken", "XX", -1, "ControlEngine", 2);
        this.validTokens.add(this.internalToken);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    public synchronized String startJob(Token token, String jobName, boolean asyncJob, boolean persistedJob) throws Exception {
        ILogger jobLogger;
        String jobId;
        String dsrId;
        TokenHeartbeat heartbeat;
        String methodName;
        block9: {
            methodName = "startJob";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
            }
            this.checkToken(token);
            heartbeat = this.startTokenHeartbeat(token);
            dsrId = new Integer(ServiceUtils.getJobIdentifier(persistedJob, 7)).toString();
            jobId = new Integer(ServiceUtils.getJobIdentifier(persistedJob, 2)).toString();
            jobLogger = null;
            if (persistedJob) {
                try {
                    jobLogger = LogManagerFactory.getJobLogger("control", dsrId, jobId);
                    jobLogger.setMessageFile(DMJobMessages.class.getName());
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block9;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                }
            }
        }
        JobInfo jobInfo = new JobInfo(dsrId, jobId, asyncJob);
        jobInfo.setJobStatus(2);
        jobInfo.setToken(token);
        jobInfo.setHeartBeat(heartbeat);
        jobInfo.setJobLogger(jobLogger);
        ServiceUtils.activeJobs.put(dsrId, jobInfo);
        if (persistedJob) {
            String jobLoggerFileName = "";
            if (jobLogger != null) {
                jobLoggerFileName = LogManagerFactory.getLogFileName(jobLogger);
            }
            ServiceUtils.createJobRecord(Integer.parseInt(dsrId), Integer.parseInt(jobId), jobName, jobLoggerFileName);
        }
        this.subJobStatus.put(dsrId, new ArrayList());
        token.setJobId(dsrId);
        ArrayList<JobInfo> jobs = (ArrayList<JobInfo>)this.jobsBelongingToTokens.get(token);
        if (jobs == null) {
            jobs = new ArrayList<JobInfo>();
        }
        jobs.add(jobInfo);
        this.jobsBelongingToTokens.put(token, jobs);
        if (jobLogger != null) {
            jobLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, methodName, "ControlService_jobStarted", new String[]{dsrId, jobId, jobName});
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return dsrId;
    }

    public synchronized int startSubJob(Token token, String jobName, boolean persistedJob) throws Exception {
        String methodName = "startSubJob";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        int subJobNum = -1;
        String dsrId = token.getJobId();
        ArrayList subJobs = (ArrayList)this.subJobStatus.get(dsrId);
        if (subJobs != null) {
            int dsrIdNum = Integer.parseInt(dsrId);
            String jobId = null;
            ILogger jobLogger = null;
            if (dsrIdNum >= 0) {
                jobId = new Integer(ServiceUtils.getJobIdentifier(persistedJob, 2)).toString();
                if (persistedJob) {
                    String jobLoggerFileName = "";
                    JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
                    if (jobInfo != null && jobInfo.getJobLogger() != null) {
                        jobLogger = jobInfo.getJobLogger();
                        jobLoggerFileName = LogManagerFactory.getLogFileName(jobLogger);
                    }
                    ServiceUtils.createJobRecord(Integer.parseInt(dsrId), Integer.parseInt(jobId), jobName, jobLoggerFileName);
                }
            } else {
                jobId = new Integer(ServiceUtils.getJobIdentifier(false, 2)).toString();
            }
            AsyncResult subJobResult = new AsyncResult(0, 2);
            subJobResult.setJobId(jobId);
            subJobNum = subJobs.size();
            subJobs.add(subJobNum, subJobResult);
            if (jobLogger != null) {
                jobLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, methodName, "ControlService_childJobStarted", new String[]{jobId, jobName});
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return subJobNum;
    }

    public synchronized boolean endJob(Token token, int rc, int status, SRMMessage msg, Exception returnException, Object[] returnObjs) throws Exception {
        String methodName = "endJob";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        boolean bResult = false;
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        if (jobInfo != null) {
            String jobId = jobInfo.getJobId();
            jobInfo.setJobStatus(status);
            int dsrNum = Integer.parseInt(dsrId);
            if (dsrNum >= 0) {
                ServiceUtils.updateJobRecord(dsrNum, Integer.parseInt(jobId), status, rc);
            }
            if (status == 2) {
                ServiceUtils.activeJobs.put(dsrId, jobInfo);
            } else {
                TokenHeartbeat heartbeat = jobInfo.getHeartBeat();
                this.stopTokenHeartbeat(heartbeat);
                if (jobInfo.isAsyncJob()) {
                    AsyncResult result = new AsyncResult(rc, status, msg);
                    result.setJobId(dsrId);
                    result.setReturnException(returnException);
                    result.setResults(returnObjs);
                    AsyncResult tempResult = this.getActiveJobResults(dsrId);
                    if (tempResult != null) {
                        result.setSubJobResults(tempResult.getSubJobResults());
                    }
                    ServiceUtils.completedJobResults.put(dsrId, result);
                }
                ServiceUtils.activeJobs.remove(dsrId);
                this.subJobStatus.remove(dsrId);
                ILogger jobLogger = jobInfo.getJobLogger();
                if (jobLogger != null) {
                    jobLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, methodName, "ControlService_jobFinished", new String[]{jobInfo.getDeviceServerRunNumber(), jobInfo.getJobId(), new Integer(jobInfo.getJobStatus()).toString(), new Integer(rc).toString()});
                    LogManagerFactory.returnJobLogger(jobInfo.getJobLogger());
                }
                bResult = true;
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return bResult;
    }

    public synchronized boolean endSubJob(Token token, int subJobNum, int rc, int status, SRMMessage msg, Exception returnException, Object[] returnObjs) throws Exception {
        String methodName = "endSubJob";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        boolean bResult = false;
        String dsrId = token.getJobId();
        ArrayList subJobs = (ArrayList)this.subJobStatus.get(dsrId);
        if (subJobs != null && subJobNum >= 0) {
            AsyncResult tempResult;
            ILogger jobLogger;
            block11: {
                jobLogger = null;
                tempResult = null;
                try {
                    tempResult = (AsyncResult)subJobs.get(subJobNum);
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block11;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                }
            }
            if (tempResult != null) {
                String jobId;
                block12: {
                    jobId = tempResult.getJobId();
                    int jobIdNum = Integer.parseInt(jobId);
                    if (jobIdNum >= 0) {
                        ServiceUtils.updateJobRecord(Integer.parseInt(dsrId), jobIdNum, status, rc);
                        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
                        if (jobInfo != null) {
                            jobLogger = jobInfo.getJobLogger();
                        }
                    }
                    AsyncResult subJobResult = new AsyncResult(rc, status, msg);
                    subJobResult.setJobId(jobId);
                    subJobResult.setReturnException(returnException);
                    subJobResult.setResults(returnObjs);
                    try {
                        subJobs.set(subJobNum, subJobResult);
                        bResult = true;
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block12;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                    }
                }
                if (jobLogger != null) {
                    jobLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, methodName, "ControlService_childJobFinished", new String[]{jobId, new Integer(status).toString(), new Integer(rc).toString()});
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return bResult;
    }

    public AsyncResult processReturnObj(Token token, Object returnObj) {
        String methodName = "processReturnObj";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        AsyncResult result = new AsyncResult(0, 1);
        result.setJobId(token.getJobId());
        if (returnObj != null) {
            if (returnObj instanceof AsyncResult) {
                result = new AsyncResult(((AsyncResult)returnObj).getRc(), ((AsyncResult)returnObj).getStatus(), ((AsyncResult)returnObj).getSRMMessage());
                result.setJobId(token.getJobId());
                result.setReturnException(((AsyncResult)returnObj).getReturnException());
                result.setResults(((AsyncResult)returnObj).getResults());
            } else if (returnObj instanceof Result) {
                int rc = ((Result)returnObj).getRc();
                int status = 1;
                if (rc != 0) {
                    status = 0;
                }
                result = new AsyncResult(rc, status, ((Result)returnObj).getSRMMessage());
                result.setJobId(token.getJobId());
                result.setResults(((Result)returnObj).getResults());
            } else if (returnObj instanceof Integer) {
                int rc = (Integer)returnObj;
                result.setRc(rc);
                if (rc != 0) {
                    result.setStatus(0);
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return result;
    }

    public ILogger getJobLogger(Token token) {
        String methodName = "getJobLogger";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        ILogger jobLogger = null;
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        if (jobInfo != null) {
            jobLogger = jobInfo.getJobLogger();
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return jobLogger;
    }

    public synchronized void addAsyncThreadToJob(Token token, IController controller) {
        String job;
        JobInfo jobInfo;
        String methodName = "addAsyncThreadToJob";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        if ((jobInfo = (JobInfo)ServiceUtils.activeJobs.get(job = token.getJobId())) != null) {
            jobInfo.setController(controller);
            ServiceUtils.activeJobs.put(job, jobInfo);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    public boolean isJobActive(String jobId) {
        String methodName = "isJobActive";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(jobId);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return jobInfo != null;
    }

    public void cancelJob(String jobId) {
        String methodName;
        block6: {
            JobInfo jobInfo;
            methodName = "cancelJob";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
            }
            if ((jobInfo = (JobInfo)ServiceUtils.activeJobs.get(jobId)) != null) {
                IController controller = jobInfo.getController();
                if (controller != null) {
                    controller.shutdown();
                }
                try {
                    this.endJob(jobInfo.getToken(), -47, 5, null, null, null);
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    public AsyncResult getJobResults(String jobId) {
        String methodName = "getJobResults";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        AsyncResult result = (AsyncResult)ServiceUtils.completedJobResults.get(jobId);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return result;
    }

    public AsyncResult getActiveJobResults(String jobId) {
        String methodName = "getActiveJobResults";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        AsyncResult result = null;
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(jobId);
        if (jobInfo != null) {
            result = new AsyncResult(0, 2);
            result.setJobId(jobId);
            ArrayList subJobs = (ArrayList)this.subJobStatus.get(jobId);
            if (subJobs != null && subJobs.size() > 0) {
                AsyncResult[] results = subJobs.toArray(new AsyncResult[0]);
                result.setSubJobResults(results);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return result;
    }

    public int getJobStatus(String jobId) {
        String methodName = "getJobStatus";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return ServiceUtils.getJobStatus(jobId).getStatus();
    }

    public AsyncResult waitForJobToComplete(String jobId) {
        String methodName = "waitForJobToComplete";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        while (this.isJobActive(jobId)) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return this.getJobResults(jobId);
    }

    public String[] getJobIds(Token token) {
        String methodName = "getJobIds";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        String[] jobIds = null;
        ArrayList jobsForToken = (ArrayList)this.jobsBelongingToTokens.get(token);
        if (jobsForToken != null) {
            JobInfo[] jobs = jobsForToken.toArray(new JobInfo[0]);
            jobIds = new String[jobs.length];
            for (int i = 0; i < jobs.length; ++i) {
                jobIds[i] = new String(jobs[i].getDeviceServerRunNumber());
            }
        } else {
            jobIds = new String[]{};
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return jobIds;
    }

    public void setTokenForProxyThread(Thread thread, Token token) {
        String methodName = "setTokenForProxyThread";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        this.tokenTable.put(thread, token);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    public Token getTokenForProxyThread(Thread thread) {
        String methodName = "getTokenForProxyThread";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return (Token)this.tokenTable.get(thread);
    }

    public void removeTokenForProxyThread(Thread thread) {
        String methodName = "getTokenForProxyThread";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        this.tokenTable.remove(thread);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private long getTokenUpdateInterval() {
        int timeout;
        long updateInterval;
        String methodName = "getTokenUpdateInterval";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, className, methodName);
        }
        if ((updateInterval = (long)((timeout = this.getTokenTimeout()) - 60)) <= (long)(timeout / 2)) {
            updateInterval = timeout / 2;
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return updateInterval * 1000L;
    }

    private int getTokenTimeout() {
        String methodName = "getTokenTimeout";
        if (this.tokenTimeout == null) {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            try {
                IConfigService dbParms = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
                String timeout = dbParms.getProperty("ZoneTokenTimeout", "user");
                if (timeout != null) {
                    this.tokenTimeout = Integer.parseInt(timeout);
                } else {
                    dbParms.setProperty("ZoneTokenTimeout", "user", String.valueOf(300));
                    this.tokenTimeout = 300;
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                }
                this.tokenTimeout = 300;
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        return this.tokenTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getDBToken(String resource, String resourceType, String client, int accessType) {
        String methodName = "getDBToken";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        Token dbToken = null;
        if (accessType == 1) {
            DBConnection connection = null;
            try {
                connection = ServiceUtils.getConnection();
                Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_ID"), resource);
                whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_TYPE"), resourceType);
                org.eclipse.aperi.infrastructure.database.objects.Token persistedToken = org.eclipse.aperi.infrastructure.database.objects.Token.retrieve(connection, whereclause);
                if (persistedToken != null) {
                    dbToken = new Token(persistedToken.getResId(), persistedToken.getResType(), persistedToken.getTokenId(), client, accessType);
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                }
            }
            finally {
                block18: {
                    if (connection != null) {
                        try {
                            connection.commit();
                            connection.close();
                        }
                        catch (Exception e) {
                            this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) break block18;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                        }
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return dbToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Token createToken(String resource, String resourceType, String clientId, int accessType) {
        Token dbToken;
        String methodName;
        block21: {
            block23: {
                boolean tokenCreated;
                DBConnection connection;
                block19: {
                    methodName = "createToken";
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
                    }
                    dbToken = null;
                    if (accessType != 1) break block23;
                    connection = null;
                    tokenCreated = false;
                    int tokenId = -1;
                    tokenId = AutoIdentifier.getIdentifier(8, 1);
                    connection = ServiceUtils.getConnection();
                    Timestamp timestamp = CurrentTime.getTimestamp(connection);
                    org.eclipse.aperi.infrastructure.database.objects.Token persistedToken = new org.eclipse.aperi.infrastructure.database.objects.Token();
                    persistedToken.setTstamp(timestamp);
                    persistedToken.setResId(resource);
                    persistedToken.setResType(resourceType);
                    persistedToken.setTokenId(tokenId);
                    persistedToken.insert(connection);
                    tokenCreated = true;
                    Object var13_15 = null;
                    if (connection == null) break block19;
                    try {
                        connection.commit();
                        connection.close();
                    }
                    catch (Exception e2) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e2);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block19;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e2);
                    }
                }
                if (tokenCreated) {
                    dbToken = this.getDBToken(resource, resourceType, clientId, accessType);
                }
                break block21;
                {
                    catch (Exception e) {
                        block20: {
                            this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
                            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                            }
                            Object var13_16 = null;
                            if (connection != null) {
                                try {
                                    connection.commit();
                                    connection.close();
                                }
                                catch (Exception e2) {
                                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e2);
                                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block20;
                                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e2);
                                }
                            }
                        }
                        if (tokenCreated) {
                            dbToken = this.getDBToken(resource, resourceType, clientId, accessType);
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    block22: {
                        Object var13_17 = null;
                        if (connection != null) {
                            try {
                                connection.commit();
                                connection.close();
                            }
                            catch (Exception e2) {
                                this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e2);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block22;
                                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e2);
                            }
                        }
                    }
                    if (tokenCreated) {
                        dbToken = this.getDBToken(resource, resourceType, clientId, accessType);
                    }
                    throw throwable;
                }
            }
            try {
                int tokenId = AutoIdentifier.getIdentifier(8, 1);
                dbToken = new Token(resource, resourceType, tokenId, clientId, accessType);
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block21;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        if (dbToken != null) {
            this.validTokens.add(dbToken);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return dbToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToken(String resource, String resourceType) {
        String methodName = "removeToken";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        DBConnection connection = null;
        try {
            connection = ServiceUtils.getConnection();
            Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
            whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_ID"), resource);
            whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_TYPE"), resourceType);
            org.eclipse.aperi.infrastructure.database.objects.Token.deletes(connection, whereclause);
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        finally {
            block16: {
                if (connection != null) {
                    try {
                        connection.commit();
                        connection.close();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block16;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTokenValid(Token token) {
        String methodName = "isTokenValid";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        boolean valid = false;
        Timestamp currentTime = null;
        Timestamp tokenTime = null;
        DBConnection connection = null;
        try {
            connection = ServiceUtils.getConnection();
            currentTime = CurrentTime.getTimestamp(connection);
            Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
            whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("TOKEN_ID"), String.valueOf(token.getTokenId()));
            whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_ID"), token.getResource());
            whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_TYPE"), token.getResourceType());
            org.eclipse.aperi.infrastructure.database.objects.Token persistedToken = org.eclipse.aperi.infrastructure.database.objects.Token.retrieve(connection, whereclause);
            if (persistedToken != null) {
                long tokenTimeMillis;
                tokenTime = persistedToken.getTstamp();
                long currentTimeMillis = currentTime.getTime() + (long)(currentTime.getNanos() / 1000000);
                if (currentTimeMillis - (tokenTimeMillis = tokenTime.getTime() + (long)(tokenTime.getNanos() / 1000000)) <= (long)(this.getTokenTimeout() * 1000)) {
                    valid = true;
                }
            }
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        finally {
            block18: {
                if (connection != null) {
                    try {
                        connection.commit();
                        connection.close();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block18;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return valid;
    }

    public void checkToken(Token token) throws InvalidTokenException, JobInProgressException {
        String methodName = "checkToken";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        if (token == null) {
            throw new InvalidTokenException();
        }
        if (!this.validTokens.contains(token)) {
            token.setValid(false);
            throw new InvalidTokenException();
        }
        if (token.getAccessType() == 1) {
            Token storedToken = this.getDBToken(token.getResource(), token.getResourceType(), token.getClient(), token.getAccessType());
            if (storedToken != null) {
                if (token == null || !token.equals(storedToken) || !this.isTokenValid(storedToken)) {
                    token.setValid(false);
                    throw new InvalidTokenException();
                }
            } else {
                token.setValid(false);
                throw new InvalidTokenException();
            }
            String[] dsrIds = this.getJobIds(token);
            for (int i = 0; i < dsrIds.length; ++i) {
                if (!this.isJobActive(dsrIds[i])) continue;
                throw new JobInProgressException();
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private TokenHeartbeat startTokenHeartbeat(Token token) {
        String methodName = "startTokenHeartbeat";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, className, methodName);
        }
        TokenHeartbeat heartBeat = null;
        if (token.getAccessType() == 1) {
            if (this.updateTokenTimestamp(token) != 1 && this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Unable to update Token for SAN " + token.getResource() + " client " + token.getClient());
            }
            long timestampUpdateInterval = this.getTokenUpdateInterval();
            heartBeat = new TokenHeartbeat(this, token, timestampUpdateInterval);
            heartBeat.start();
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return heartBeat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTokenHeartbeat(TokenHeartbeat heartBeat) {
        String methodName = "stopTokenHeartbeat";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, className, methodName);
        }
        if (heartBeat != null) {
            try {
                if (heartBeat != null && !heartBeat.isDone()) {
                    heartBeat.shutdown();
                    heartBeat.join(30000L);
                }
            }
            catch (Exception e) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                }
            }
            finally {
                heartBeat = null;
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTokenTimestamp(Token token) {
        String methodName = "updateTokenTimestamp";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, className, methodName);
        }
        if (token.getAccessType() != 1) {
            return 1;
        }
        Timestamp currentTime = null;
        DBConnection connection = null;
        int result = 0;
        try {
            connection = ServiceUtils.getConnection();
            currentTime = CurrentTime.getTimestamp(connection);
            Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
            whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("TOKEN_ID"), String.valueOf(token.getTokenId()));
            whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_ID"), token.getResource());
            whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_TYPE"), token.getResourceType());
            Hashtable<ColumnInfo, Timestamp> parameters = new Hashtable<ColumnInfo, Timestamp>();
            parameters.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("TSTAMP"), currentTime);
            result = org.eclipse.aperi.infrastructure.database.objects.Token.update(connection, parameters, whereclause);
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        finally {
            block17: {
                if (connection != null) {
                    try {
                        connection.commit();
                        connection.close();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block17;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return result;
    }

    public synchronized void shutdown() {
        String methodName = "shutdown";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    public void removeTokenFromJobs(Token token) {
        this.jobsBelongingToTokens.remove(token);
    }

    public void removeTokenFromValidTokens(Token token) {
        this.validTokens.remove(token);
    }

    public Token getInternalToken() {
        return this.internalToken;
    }
}

