/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control;

import org.eclipse.aperi.control.data.ControlConstants;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.IControlEngine;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class TokenHeartbeat
extends Thread {
    private static ILogger msgLogger = ControlConstants.msgLogger;
    private static ILogger traceLogger = ControlConstants.traceLogger;
    private final String className = TokenHeartbeat.class.getName();
    IControlEngine ce = null;
    Token token = null;
    long timestampUpdateInterval = 0L;
    boolean bAllDone = false;

    public TokenHeartbeat(IControlEngine aCe, Token aToken, long aTimestampUpdateInterval) {
        String methodName = "TokenHearbeat";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, this.className, methodName);
        }
        this.ce = aCe;
        this.token = aToken;
        this.timestampUpdateInterval = aTimestampUpdateInterval;
        this.setName("tokenHeartbeat Token=" + this.token.getTokenId() + " Client=" + this.token.getClient());
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, this.className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String methodName = "run";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, this.className, methodName);
        }
        while (!this.bAllDone) {
            TokenHeartbeat tokenHeartbeat = this;
            synchronized (tokenHeartbeat) {
                try {
                    this.wait(this.timestampUpdateInterval);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, this.className, methodName, "Updating token heartbeat for SAN " + this.token.getResource() + " client " + this.token.getClient());
                }
                if (this.ce.updateTokenTimestamp(this.token) != 1 && traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, this.className, methodName, "Unable to update Token for SAN " + this.token.getResource() + " client " + this.token.getClient());
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, this.className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        String methodName = "shutdown";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, this.className, methodName);
        }
        this.bAllDone = true;
        TokenHeartbeat tokenHeartbeat = this;
        synchronized (tokenHeartbeat) {
            this.notifyAll();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, this.className, methodName);
        }
    }

    public boolean isDone() {
        String methodName = "isDone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, this.className, methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, this.className, methodName);
        }
        return this.bAllDone;
    }
}

