/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import com.ibm.log.Level;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.StreamResponse;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.queue.QueueController;

public class JobEngine
implements Observer {
    private static JobEngine engine = null;
    public static String className = JobEngine.class.getName();
    public static final String MESSAGE_NAME = "aperi.logger.message.JobEngine";
    public static final String TRACE_NAME = "aperi.logger.trace.JobEngine";
    public static String MSG_FILE = "org.eclipse.aperi.resources.JobEngineTMS";
    private Map<String, ArrayList> jobList = Collections.synchronizedMap(new Hashtable());
    private Map<String, ArrayList<String>> cFinishedRequests = Collections.synchronizedMap(new HashMap());
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    public Observer observer = null;

    public static JobEngine getInstance() {
        String methodName = "getInstance()";
        if (engine == null) {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
            }
            engine = new JobEngine();
        }
        return engine;
    }

    public void addObserver(Observer observer) {
        this.observer = observer;
    }

    public ArrayList getJobs() {
        String methodName = "getJobs()";
        ArrayList allJobs = new ArrayList();
        Iterator<String> i = this.jobList.keySet().iterator();
        while (i.hasNext()) {
            allJobs.addAll(this.jobList.get(i.next()));
        }
        return allJobs;
    }

    public ArrayList getJobs(String discoverRequest) {
        String methodName = "getJobs(discoverRequest)";
        ArrayList jobs = this.jobList.get(discoverRequest);
        if (jobs != null) {
            return jobs;
        }
        return new ArrayList();
    }

    public void waitTilComplete(String job) {
        long start = System.currentTimeMillis();
        while (this.getJobStatus(job) != 2) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getJobStatus(String discoverRequest) {
        ArrayList jobs = this.getJobs(discoverRequest);
        int numNotRunning = 0;
        int numFinished = 0;
        Iterator i = jobs.iterator();
        while (i.hasNext()) {
            int childStatus = ((JobInfo)i.next()).getStatus();
            if (childStatus == 1) {
                return childStatus;
            }
            if (childStatus == 0) {
                ++numNotRunning;
                continue;
            }
            if (childStatus != 2 && childStatus != 4) continue;
            ++numFinished;
        }
        if (jobs.size() == numFinished) {
            return 2;
        }
        if (jobs.size() == 0) {
            return 0;
        }
        return 1;
    }

    private JobEngine() {
    }

    public void addJob(JobInfo job) {
        job.addObserver(this);
        ArrayList<JobInfo> jobs = this.jobList.get(job.getDiscoverRequest());
        if (jobs == null) {
            jobs = new ArrayList<JobInfo>();
            this.jobList.put(job.getDiscoverRequest(), jobs);
        }
        jobs.add(job);
        QueueController.getInstance().addJob(job);
    }

    public void removeJobs(String discoverRequest) {
        ArrayList jobs = this.getJobs(discoverRequest);
        if (jobs != null) {
            for (int i = 0; i < jobs.size(); ++i) {
                JobInfo job = (JobInfo)jobs.get(i);
                job.deleteObserver(this);
            }
        }
        this.jobList.remove(discoverRequest);
    }

    public void update(Observable arg, Object o) {
        String methodName;
        block16: {
            methodName = "update()";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
            }
            if (arg instanceof JobInfo) {
                JobInfo job = (JobInfo)arg;
                try {
                    block15: {
                        if (traceLogger.isLogging()) {
                            traceLogger.text(Level.DEBUG_MAX, this, methodName, job.toString());
                        }
                        if (job.isSuccessful()) {
                            JobInfo next;
                            if (traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "Successful Completion of Job");
                            }
                            if ((next = job.getNextJob()) != null) {
                                this.addJob(next);
                            }
                        } else if (job.getResponse() instanceof StreamResponse) {
                            InputStream in = (InputStream)job.getResponse().getData();
                            BufferedReader br = new BufferedReader(new InputStreamReader(in));
                            try {
                                String line;
                                StringBuffer strBuf = new StringBuffer();
                                while ((line = br.readLine()) != null) {
                                    strBuf.append(line + " ");
                                }
                                if (traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, strBuf.toString());
                                }
                                job.getResponse().close();
                            }
                            catch (Exception e) {
                                if (!traceLogger.isLogging()) break block15;
                                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                            }
                        }
                    }
                    this.jobStatusChange(job);
                }
                catch (Exception e) {
                    if (!traceLogger.isLogging()) break block16;
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    public void replaceJob(JobInfo oldJob, JobInfo newJob) {
        String methodName = "replaceJob()";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        oldJob.getRequest().close();
        oldJob.replaceWith(newJob);
        this.jobStatusChange(oldJob);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    public void jobStatusChange(JobInfo job) {
        block4: {
            String methodName = "jobStatusChange";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "Notifying listener that " + job + " has changed status");
            }
            try {
                if (this.observer != null) {
                    this.observer.update(null, job);
                }
            }
            catch (Throwable t) {
                if (!traceLogger.isLogging()) break block4;
                traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, "Error notifying observer of job change for " + job);
                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, t);
            }
        }
    }

    public void addFinishedRequests(String pDeviceServerRunNumber, String pFinishedRequestId) {
        ArrayList<String> finished = this.cFinishedRequests.get(pDeviceServerRunNumber);
        if (finished == null) {
            finished = new ArrayList();
            this.cFinishedRequests.put(pDeviceServerRunNumber, finished);
        }
        finished.add(pFinishedRequestId);
    }

    public void cleanupRequestInformation(String deviceServerRunId) {
        ArrayList<String> finished = this.cFinishedRequests.remove(deviceServerRunId);
        if (finished != null) {
            for (String id : finished) {
                JobEngine.getInstance().removeJobs(id);
            }
            finished.remove(deviceServerRunId);
        }
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }
}

