/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.MapPool;
import org.sblim.wbem.cim.CIMException;

public final class CIMClientPool
extends MapPool {
    private static CIMClientPool stSingletonInstance = null;
    private List cReturnQueue = new LinkedList();
    private ClientVerifier cVerifier = new ClientVerifier();

    private CIMClientPool() {
        super(DiskManagerConfigSvc.getIntConfigValue("CIMClientWrapper.PoolSize", 50));
        this.cVerifier.start();
    }

    private static CIMClientPool get() {
        return stSingletonInstance;
    }

    public static CIMClientWrapper getClient(String pUserID, String pPassword, String pServiceURL, String pNameSpace) throws CIMException {
        CIMClientWrapper mClient = (CIMClientWrapper)CIMClientPool.get().getClearInstance(CIMClientWrapper.generateKey(pUserID, pPassword, pServiceURL, pNameSpace));
        if (mClient != null) {
            mClient.initializeInstance(pUserID, pPassword, pServiceURL, pNameSpace);
            return mClient;
        }
        return new CIMClientWrapper(pUserID, pPassword, pServiceURL, pNameSpace, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnClient(CIMClientWrapper pClient) {
        LogTraceHelper mLTH = LogTraceHelper.entry("CIMClientPool", "returnClient", new Object[]{pClient});
        try {
            mLTH.traceHigh("CIMClient Wrapper ObjectID: " + pClient.getAddress() + " ThreadName: " + Thread.currentThread().getName());
            pClient.releaseInstance();
        }
        finally {
            mLTH.exit(null);
        }
    }

    private static void retClientInt(CIMClientWrapper pClient) {
        if (pClient.testConnection()) {
            System.out.println("Test connection successful");
            if (CIMClientPool.get().cVerifier.cContinue) {
                if (!CIMClientPool.get().returnInst(pClient)) {
                    System.out.println("not added to pool");
                    pClient.releaseInstance();
                }
            } else {
                System.out.println("verifier shutting down");
                pClient.releaseInstance();
            }
        } else {
            System.out.println("Test connection not successful");
            pClient.releaseInstance();
        }
    }

    public static void shutdown() {
        CIMClientPool.get().cVerifier.cContinue = false;
        CIMClientPool.get().cVerifier.interrupt();
        CIMClientPool.get().clear();
    }

    static {
        stSingletonInstance = new CIMClientPool();
    }

    private class ClientVerifier
    extends Thread {
        private boolean cContinue;

        private ClientVerifier() {
            super("DiskManager CIMClientPool ClientVerifier");
            this.cContinue = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CIMClientWrapper mClnt = null;
            while (this.cContinue) {
                List list = CIMClientPool.this.cReturnQueue;
                synchronized (list) {
                    while (CIMClientPool.this.cReturnQueue.isEmpty()) {
                        try {
                            CIMClientPool.this.cReturnQueue.wait(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.cContinue) continue;
                        return;
                    }
                    mClnt = (CIMClientWrapper)CIMClientPool.this.cReturnQueue.remove(0);
                }
                CIMClientPool.retClientInt(mClnt);
            }
        }
    }
}

