/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.disk.common.IConvertableSubJobResult;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;

public class ResultHelper {
    public static AsyncResult addAsyncSubResultsSuccess(AsyncResult pAsyncResult, ArrayList pResults, String pAPIMethodName) {
        AsyncResult[] mAsyncResults = new AsyncResult[pResults.size()];
        for (int i = 0; i < pResults.size(); ++i) {
            SRMMessage bMessage = new SRMMessage("HWN020001I", new String[]{pAPIMethodName});
            AsyncResult bNewResult = new AsyncResult(0, 1, bMessage);
            if (!(pResults.get(i) instanceof IConvertableSubJobResult)) {
                throw new RuntimeException("Type of pResults.get(i) not supported. Extend method addAsyncSubResultsSuccess for proper support.");
            }
            bNewResult.setResults(((IConvertableSubJobResult)pResults.get(i)).toArray());
            mAsyncResults[i] = bNewResult;
        }
        ResultHelper.addAsyncSubResults(pAsyncResult, mAsyncResults);
        return pAsyncResult;
    }

    public static AsyncResult addAsyncSubResultsException(AsyncResult pAsyncResult, ArrayList pResults, int pReturnCode, SRMMessage pSRMMessage, Exception pException) {
        AsyncResult[] mAsyncResults = new AsyncResult[pResults.size()];
        for (int i = 0; i < pResults.size(); ++i) {
            AsyncResult bNewResult = new AsyncResult(pReturnCode, 0, pSRMMessage);
            bNewResult.setResults(new Object[]{pResults.get(i)});
            bNewResult.setReturnException(pException);
            mAsyncResults[i] = bNewResult;
        }
        ResultHelper.addAsyncSubResults(pAsyncResult, mAsyncResults);
        return pAsyncResult;
    }

    public static AsyncResult addAsyncSubResults(AsyncResult pAsyncResult, AsyncResult[] pTPCAsyncSubJobResults) {
        if (pTPCAsyncSubJobResults.length == 0) {
            return pAsyncResult;
        }
        AsyncResult[] bSubJobResults = pAsyncResult.getSubJobResults();
        int bNumSubResults = 0;
        if (bSubJobResults != null) {
            bNumSubResults = bSubJobResults.length;
        }
        AsyncResult[] bNewSubJobResults = new AsyncResult[bNumSubResults + pTPCAsyncSubJobResults.length];
        if (bNumSubResults > 0) {
            System.arraycopy(bSubJobResults, 0, bNewSubJobResults, 0, bNumSubResults);
        }
        for (int i = 0; i < pTPCAsyncSubJobResults.length; ++i) {
            bNewSubJobResults[bNumSubResults + i] = pTPCAsyncSubJobResults[i];
        }
        pAsyncResult.setSubJobResults(bNewSubJobResults);
        return pAsyncResult;
    }

    public static AsyncResult computeAndSetFinalStatus(AsyncResult pAsyncResult, String pMethodName) throws RuntimeException {
        return ResultHelper.computeAndSetFinalStatus(pAsyncResult.getSubJobResults(), pMethodName);
    }

    public static AsyncResult computeAndSetFinalStatus(AsyncResult[] pAsyncResult, String pMethodName) throws RuntimeException {
        AsyncResult mResult = new AsyncResult(-1, -1);
        int bStatus = mResult.getStatus();
        block10: for (int i = 0; i < pAsyncResult.length && bStatus != 4; ++i) {
            switch (pAsyncResult[i].getStatus()) {
                case 3: 
                case 4: {
                    bStatus = 4;
                    continue block10;
                }
                case 1: {
                    if (bStatus == 0) {
                        bStatus = 4;
                        continue block10;
                    }
                    bStatus = 1;
                    continue block10;
                }
                case 0: {
                    if (bStatus == 1) {
                        bStatus = 4;
                        continue block10;
                    }
                    bStatus = 0;
                    continue block10;
                }
                default: {
                    throw new RuntimeException("Invalid status of subjob. Status is: " + pAsyncResult[i].getStatus());
                }
            }
        }
        if (mResult.getReturnException() != null && bStatus == 1) {
            bStatus = 4;
        }
        switch (bStatus) {
            case 1: {
                mResult.setSRMMessage(new SRMMessage("HWN020001I", new String[]{pMethodName}));
                mResult.setRc(0);
                break;
            }
            case 4: {
                mResult.setSRMMessage(new SRMMessage("HWN021600W", new String[]{pMethodName}));
                mResult.setRc(10008);
                break;
            }
            case 0: {
                mResult.setSRMMessage(new SRMMessage("HWN021601E", new String[]{pMethodName}));
                mResult.setRc(10007);
                break;
            }
            default: {
                throw new RuntimeException("Invalid status. Status is: " + bStatus);
            }
        }
        mResult.setStatus(bStatus);
        mResult.setSubJobResults(pAsyncResult);
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getSubResults(AsyncResult pAsyncResult) {
        LogTraceHelper mLTH = LogTraceHelper.entry("ResultHelper", "getSuccessfulSubResults", new Object[]{pAsyncResult});
        ArrayList<Object> mSuccessResults = new ArrayList<Object>();
        try {
            ArrayList<AsyncResult> mSuccessfulSubjobs = new ArrayList<AsyncResult>();
            AsyncResult[] mSubResults = pAsyncResult.getSubJobResults();
            for (int i = 0; i < mSubResults.length; ++i) {
                mSuccessfulSubjobs.add(mSubResults[i]);
            }
            for (int i = 0; i < mSuccessfulSubjobs.size(); ++i) {
                AsyncResult bSubResult = (AsyncResult)mSuccessfulSubjobs.get(i);
                mSuccessResults.add(bSubResult.getResults()[0]);
            }
        }
        finally {
            mLTH.exit(mSuccessResults);
        }
        return mSuccessResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getSuccessfulSubResults(AsyncResult pAsyncResult) {
        LogTraceHelper mLTH = LogTraceHelper.entry("ResultHelper", "getSuccessfulSubResults", new Object[]{pAsyncResult});
        ArrayList<Object> mSuccessResults = new ArrayList<Object>();
        try {
            ArrayList<AsyncResult> mSuccessfulSubjobs = new ArrayList<AsyncResult>();
            AsyncResult[] mSubResults = pAsyncResult.getSubJobResults();
            for (int i = 0; i < mSubResults.length; ++i) {
                if (mSubResults[i].getStatus() != 1) continue;
                mSuccessfulSubjobs.add(mSubResults[i]);
            }
            for (int i = 0; i < mSuccessfulSubjobs.size(); ++i) {
                AsyncResult bSubResult = (AsyncResult)mSuccessfulSubjobs.get(i);
                mSuccessResults.add(bSubResult.getResults()[0]);
            }
        }
        finally {
            mLTH.exit(mSuccessResults);
        }
        return mSuccessResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList checkForFailureResults(AsyncResult[] pAsyncResults) {
        LogTraceHelper mLTH = LogTraceHelper.entry("ResultHelper", "checkForFailureResults", new Object[]{pAsyncResults});
        ArrayList<AsyncResult> mFailureJobs = new ArrayList<AsyncResult>();
        try {
            for (int i = 0; i < pAsyncResults.length; ++i) {
                if (pAsyncResults[i].getStatus() == 1) continue;
                mFailureJobs.add(pAsyncResults[i]);
            }
        }
        finally {
            mLTH.exit(mFailureJobs);
        }
        return mFailureJobs;
    }
}

