/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;

public class DiskReportingHelper {
    public static Hashtable createWhereClauseMap(Class pTableClass, Map pInputParams, LogTraceHelper pLTH) throws ServerException {
        Hashtable mReturn = null;
        if (pInputParams != null) {
            mReturn = new Hashtable(pInputParams.size() + 1, 1.0f);
            for (String mKey : pInputParams.keySet()) {
                mReturn.put(DiskReportingHelper.getColumnInfo(pTableClass, mKey, pLTH), pInputParams.get(mKey));
            }
        } else {
            mReturn = new Hashtable();
        }
        return mReturn;
    }

    public static ColumnInfo getColumnInfo(Class pTableClass, String pKey, LogTraceHelper pLTH) throws ServerException {
        try {
            Method mGCIMehtod = pTableClass.getMethod("getColumnInfo", String.class);
            return (ColumnInfo)mGCIMehtod.invoke(null, pKey);
        }
        catch (SecurityException pEx) {
            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), pLTH);
        }
        catch (IllegalArgumentException pEx) {
            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), pLTH);
        }
        catch (NoSuchMethodException pEx) {
            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), pLTH);
        }
        catch (IllegalAccessException pEx) {
            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), pLTH);
        }
        catch (InvocationTargetException pEx) {
            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), pLTH);
        }
    }

    public static HashMap getAttributes(Object pInstance, String[] pAttribList, LogTraceHelper pLTH) throws ServerException {
        HashMap<String, Object> mReturn = new HashMap<String, Object>(pAttribList.length + 2);
        try {
            Method[] mMethodArray = pInstance.getClass().getMethods();
            for (int mLoop = 0; mLoop < pAttribList.length; ++mLoop) {
                Method mMethod = DiskReportingHelper.findMethod(mMethodArray, pAttribList[mLoop]);
                if (mMethod == null) {
                    throw DiskMessageHelper.getInvalidParameterException(2, "HWN021520E", pAttribList[mLoop], pLTH);
                }
                Object mTest = mMethod.invoke(pInstance, new Object[0]);
                mReturn.put(pAttribList[mLoop], mMethod.invoke(pInstance, new Object[0]));
            }
            return mReturn;
        }
        catch (SecurityException pEx) {
            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), pLTH);
        }
        catch (IllegalArgumentException pEx) {
            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), pLTH);
        }
        catch (IllegalAccessException pEx) {
            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), pLTH);
        }
        catch (InvocationTargetException pEx) {
            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), pLTH);
        }
    }

    private static Method findMethod(Method[] pMehtodArray, String pMethodName) {
        String pName = pMethodName.replaceAll("_", "");
        for (int mLoop = 0; mLoop < pMehtodArray.length; ++mLoop) {
            if (!pMehtodArray[mLoop].getName().equalsIgnoreCase("get" + pName)) continue;
            return pMehtodArray[mLoop];
        }
        return null;
    }
}

