/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyPort;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitch;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyTapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.ClientSettingData;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;

public class ExternalKeyManager {
    private static String cClassName = "ExternalKeyManager";

    public static StoragePool getStoragePool(String storagePoolKey, int subsystemID, DBConnection con) throws IDParseException, EntityNotFoundException {
        LogTraceHelper mLTH = LogTraceHelper.entry(cClassName, "getStoragePool", new Object[]{storagePoolKey, String.valueOf(subsystemID), con});
        TResStoragePoolTable sp = null;
        StoragePool.StoragePoolCursor mResCur = null;
        try {
            String[] keys = ExternalKeyConverter.obtainStoragePoolKeyParts(storagePoolKey, mLTH);
            if (keys != null) {
                Hashtable<ColumnInfo, String> mQueryParams = new Hashtable<ColumnInfo, String>();
                mQueryParams.put(StoragePool.getColumnInfo("INSTANCE_ID"), keys[0]);
                mQueryParams.put(StoragePool.getColumnInfo("SUBSYSTEM_ID"), "" + subsystemID);
                mQueryParams.put(StoragePool.getColumnInfo("PRIMORDIAL"), "0");
                mResCur = StoragePool.getCursor(con, mQueryParams, null);
                if (!mResCur.next()) {
                    mResCur.close();
                    throw new EntityNotFoundException(null, storagePoolKey);
                }
                sp = mResCur.getObject();
                mResCur.close();
            }
            mLTH.exit(sp == null ? null : new Integer(sp.getPoolId()));
        }
        catch (SQLException ex) {
            try {
                mLTH.traceError(ex.getMessage(), ex);
                throw DiskMessageHelper.getServerException("HWN021503E", null, ex, mLTH);
            }
            catch (Throwable throwable) {
                mLTH.exit(sp == null ? null : new Integer(sp.getPoolId()));
                ExternalKeyManager.commit(con);
                throw throwable;
            }
        }
        ExternalKeyManager.commit(con);
        return sp;
    }

    public static StorageExtent getStorageExtent(String storageExtentKey, int subsystemID, DBConnection con) throws IDParseException, EntityNotFoundException {
        LogTraceHelper mLTH = LogTraceHelper.entry(cClassName, "getStorageExtent", new Object[]{storageExtentKey, String.valueOf(subsystemID), con});
        TResStorageExtentTable mSe = null;
        try {
            String[] keys = ExternalKeyConverter.obtainStorageExtentKeyParts(storageExtentKey, mLTH);
            if (keys != null) {
                mSe = new StorageExtent();
                mSe.setDeviceId(keys[0]);
                mSe.setSubsystemId(subsystemID);
                boolean bRes = ((StorageExtent)mSe).retrieve(con);
                if (!bRes) {
                    throw new EntityNotFoundException(null, storageExtentKey);
                }
            }
            mLTH.exit(mSe == null ? null : new Integer(mSe.getStorageExtentId()));
        }
        catch (SQLException ex) {
            try {
                mLTH.traceError(ex.getMessage(), ex);
                throw DiskMessageHelper.getServerException("HWN021503E", null, ex, mLTH);
            }
            catch (Throwable throwable) {
                mLTH.exit(mSe == null ? null : new Integer(mSe.getStorageExtentId()));
                ExternalKeyManager.commit(con);
                throw throwable;
            }
        }
        ExternalKeyManager.commit(con);
        return mSe;
    }

    public static StorageVolume getStorageVolume(String storageVolumeKey, int subsystemID, DBConnection con) throws IDParseException, EntityNotFoundException {
        LogTraceHelper mLTH = LogTraceHelper.entry(cClassName, "getStorageVolume", new Object[]{storageVolumeKey, String.valueOf(subsystemID), con});
        TResStorageVolumeTable sv = null;
        try {
            String[] keys = ExternalKeyConverter.obtainStorageVolumeKeyParts(storageVolumeKey, mLTH);
            if (keys != null) {
                sv = new StorageVolume();
                sv.setName(keys[0]);
                sv.setNameFormat(Short.parseShort(keys[1]));
                sv.setSubsystemId(subsystemID);
                boolean bRes = ((StorageVolume)sv).retrieve(con);
                if (!bRes) {
                    throw new EntityNotFoundException(null, storageVolumeKey);
                }
            }
            mLTH.exit(sv == null ? null : new Integer(sv.getSvid()));
        }
        catch (SQLException ex) {
            try {
                mLTH.traceError(ex.getMessage(), ex);
                throw DiskMessageHelper.getServerException("HWN021503E", null, ex, mLTH);
            }
            catch (Throwable throwable) {
                mLTH.exit(sv == null ? null : new Integer(sv.getSvid()));
                ExternalKeyManager.commit(con);
                throw throwable;
            }
        }
        ExternalKeyManager.commit(con);
        return sv;
    }

    public static StorageSubsystem getStorageSubsystem(String storageSubsystemKey, DBConnection con) throws IDParseException, EntityNotFoundException {
        LogTraceHelper mLTH = LogTraceHelper.entry(cClassName, "getStorageSubsystem", new Object[]{storageSubsystemKey, con});
        TResStorageSubsystemTable ss = null;
        try {
            String[] keys = ExternalKeyConverter.obtainStorageSubsystemKeyParts(storageSubsystemKey, mLTH);
            if (keys != null) {
                ss = new StorageSubsystem();
                ss.setName(keys[0]);
                ss.setNameFormat(Short.parseShort(keys[1]));
                boolean bRes = ((StorageSubsystem)ss).retrieve(con);
                if (!bRes) {
                    throw new EntityNotFoundException(null, storageSubsystemKey);
                }
            }
            mLTH.exit(ss == null ? null : new Integer(ss.getSubsystemId()));
        }
        catch (SQLException ex) {
            try {
                mLTH.traceError(ex.getMessage(), ex);
                throw DiskMessageHelper.getServerException("HWN021503E", null, ex, mLTH);
            }
            catch (Throwable throwable) {
                mLTH.exit(ss == null ? null : new Integer(ss.getSubsystemId()));
                ExternalKeyManager.commit(con);
                throw throwable;
            }
        }
        ExternalKeyManager.commit(con);
        return ss;
    }

    public static Port getPort(String pPortKey, int subsystemID, DBConnection pDBConnection) throws EntityNotFoundException {
        LogTraceHelper mLTH = LogTraceHelper.entry(cClassName, "getPort", new Object[]{pPortKey, pDBConnection});
        TResPortTable mPort = null;
        try {
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(Port.class, "NAME", mLTH);
            mWhereClause.put(mInfo, pPortKey);
            Port.PortCursor mCursor = Port.getCursor(pDBConnection, mWhereClause, null);
            if (!mCursor.next()) {
                mCursor.close();
                throw new EntityNotFoundException(null, pPortKey);
            }
            mPort = mCursor.getObject();
            mCursor.close();
        }
        catch (SQLException e) {
            try {
                mLTH.traceError("Internal error: SQLException", e);
                throw DiskMessageHelper.getServerException("HWN021503E", null, e, mLTH);
            }
            catch (Throwable throwable) {
                ExternalKeyManager.commit(pDBConnection);
                mLTH.exit(mPort == null ? null : new Integer(mPort.getPortId()));
                throw throwable;
            }
        }
        ExternalKeyManager.commit(pDBConnection);
        mLTH.exit(mPort == null ? null : new Integer(mPort.getPortId()));
        return mPort;
    }

    public static Port getPort(String pPort_ID, DBConnection pDBConnection) throws EntityNotFoundException {
        LogTraceHelper mLTH = LogTraceHelper.entry(cClassName, "getPort", new Object[]{pPort_ID, pDBConnection});
        TResPortTable mPort = null;
        try {
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(Port.class, "PORT_ID", mLTH);
            mWhereClause.put(mInfo, pPort_ID);
            Port.PortCursor mCursor = Port.getCursor(pDBConnection, mWhereClause, null);
            if (!mCursor.next()) {
                mCursor.close();
                throw new EntityNotFoundException(null, pPort_ID);
            }
            mPort = mCursor.getObject();
            mCursor.close();
        }
        catch (SQLException e) {
            try {
                mLTH.traceError("Internal error: SQLException", e);
                throw DiskMessageHelper.getServerException("HWN021503E", null, e, mLTH);
            }
            catch (Throwable throwable) {
                ExternalKeyManager.commit(pDBConnection);
                mLTH.exit(mPort == null ? null : new Integer(mPort.getPortId()));
                throw throwable;
            }
        }
        ExternalKeyManager.commit(pDBConnection);
        mLTH.exit(mPort == null ? null : new Integer(mPort.getPortId()));
        return mPort;
    }

    public static CapabilityData getCapabilityData(int capabilityDataID, DBConnection con) throws ServerException, EntityNotFoundException {
        LogTraceHelper mLTH = LogTraceHelper.entry(cClassName, "getCapabilityData", new Object[]{new Integer(capabilityDataID), con});
        CapabilityData cap = null;
        try {
            cap = new CapabilityData();
            cap.setCapabilityDataId(capabilityDataID);
            boolean bRes = cap.retrieve(con);
            if (!bRes) {
                throw new EntityNotFoundException(null, Integer.toString(capabilityDataID));
            }
            mLTH.exit(cap == null ? null : new Integer(cap.getCapabilityDataId()));
        }
        catch (SQLException e) {
            try {
                mLTH.traceError("Internal error: SQLException", e);
                throw DiskMessageHelper.getServerException("HWN021503E", null, e, mLTH);
            }
            catch (Throwable throwable) {
                mLTH.exit(cap == null ? null : new Integer(cap.getCapabilityDataId()));
                ExternalKeyManager.commit(con);
                throw throwable;
            }
        }
        ExternalKeyManager.commit(con);
        return cap;
    }

    public static Cimom2namespace getNamespace(int namespaceID, DBConnection con) throws ServerException, EntityNotFoundException {
        Cimom2namespace cm2ns = null;
        LogTraceHelper mLTH = LogTraceHelper.entry(cClassName, "getStorageSubsystemCIM", new Object[]{new Integer(namespaceID), con});
        try {
            cm2ns = new Cimom2namespace();
            cm2ns.setCimNamespaceId(namespaceID);
            if (!cm2ns.retrieve(con)) {
                throw new EntityNotFoundException(null, Integer.toString(namespaceID));
            }
            mLTH.exit(cm2ns == null ? null : new Integer(cm2ns.getCimNamespaceId()));
        }
        catch (SQLException e) {
            try {
                throw DiskMessageHelper.getServerException("HWN021503E", null, e, mLTH);
            }
            catch (Throwable throwable) {
                mLTH.exit(cm2ns == null ? null : new Integer(cm2ns.getCimNamespaceId()));
                throw throwable;
            }
        }
        return cm2ns;
    }

    public static CimkeySubsystem getStorageSubsystemCIM(int subsystemID, int namespaceID, DBConnection con) throws ServerException, EntityNotFoundException {
        LogTraceHelper mLTH = LogTraceHelper.entry(cClassName, "getStorageSubsystemCIM", new Object[]{String.valueOf(subsystemID), String.valueOf(namespaceID), con});
        CimkeySubsystem storageSubsystemCIM = null;
        try {
            storageSubsystemCIM = new CimkeySubsystem();
            storageSubsystemCIM.setSubsystemId(subsystemID);
            storageSubsystemCIM.setCimNamespaceId(namespaceID);
            boolean bRes = storageSubsystemCIM.retrieve(con);
            if (!bRes) {
                throw new EntityNotFoundException(null, Integer.toString(namespaceID));
            }
            mLTH.exit(storageSubsystemCIM == null ? null : new Integer(storageSubsystemCIM.getCimkeySubsystemId()));
        }
        catch (SQLException ex) {
            try {
                throw DiskMessageHelper.getServerException("HWN021503E", ex.getMessage(), mLTH);
            }
            catch (Throwable throwable) {
                mLTH.exit(storageSubsystemCIM == null ? null : new Integer(storageSubsystemCIM.getCimkeySubsystemId()));
                ExternalKeyManager.commit(con);
                throw throwable;
            }
        }
        ExternalKeyManager.commit(con);
        return storageSubsystemCIM;
    }

    public static CimkeyVolume getStorageVolumeCIM(int volumeID, int namespaceID, DBConnection con) throws ServerException, EntityNotFoundException {
        LogTraceHelper mLTH = LogTraceHelper.entry(cClassName, "getStorageVolumeCIM", new Object[]{String.valueOf(volumeID), String.valueOf(namespaceID), con});
        TResCimkeyVolumeTable storageVolumeCIM = null;
        try {
            CimkeyVolume.CimkeyVolumeCursor mResCur = null;
            Hashtable<ColumnInfo, String> mQueryParams = new Hashtable<ColumnInfo, String>();
            mQueryParams.put(CimkeyVolume.getColumnInfo("VOLUME_ID"), String.valueOf(volumeID));
            mResCur = CimkeyVolume.getCursor(con, mQueryParams, null);
            if (!mResCur.next()) {
                mResCur.close();
                throw new EntityNotFoundException(null, String.valueOf(volumeID));
            }
            storageVolumeCIM = mResCur.getObject();
            mResCur.close();
            mLTH.exit(storageVolumeCIM == null ? null : new Integer(storageVolumeCIM.getVolumeId()));
        }
        catch (SQLException ex) {
            try {
                throw DiskMessageHelper.getServerException("HWN021503E", ex.getMessage(), mLTH);
            }
            catch (Throwable throwable) {
                mLTH.exit(storageVolumeCIM == null ? null : new Integer(storageVolumeCIM.getVolumeId()));
                ExternalKeyManager.commit(con);
                throw throwable;
            }
        }
        ExternalKeyManager.commit(con);
        return storageVolumeCIM;
    }

    public static CimkeyPort getPortCIM(int pPortID, int pNamespaceID, DBConnection pDBConnection) throws ServerException, EntityNotFoundException {
        LogTraceHelper mLTH = LogTraceHelper.entry(cClassName, "getPortCIM", new Object[]{new Integer(pPortID), new Integer(pNamespaceID), pDBConnection});
        TResCimkeyPortTable mPortCIM = null;
        try {
            CimkeyPort.CimkeyPortCursor mResCur = null;
            Hashtable<ColumnInfo, String> mQueryParams = new Hashtable<ColumnInfo, String>();
            mQueryParams.put(CimkeyPort.getColumnInfo("PORT_ID"), String.valueOf(pPortID));
            mResCur = CimkeyPort.getCursor(pDBConnection, mQueryParams, null);
            if (!mResCur.next()) {
                mResCur.close();
                throw new EntityNotFoundException(null, String.valueOf(pPortID));
            }
            mPortCIM = mResCur.getObject();
            mResCur.close();
            mLTH.exit(mPortCIM == null ? null : new Integer(mPortCIM.getCimkeyPortId()));
        }
        catch (SQLException e) {
            try {
                mLTH.traceError("Internal error: SQLException", e);
                throw DiskMessageHelper.getServerException("HWN021503E", null, e, mLTH);
            }
            catch (Throwable throwable) {
                mLTH.exit(mPortCIM == null ? null : new Integer(mPortCIM.getCimkeyPortId()));
                ExternalKeyManager.commit(pDBConnection);
                throw throwable;
            }
        }
        ExternalKeyManager.commit(pDBConnection);
        return mPortCIM;
    }

    public static CIMObjectPath getCIMObjectPath(CimkeySubsystem system, String namespace) {
        CIMObjectPath ssCIMOP = new CIMObjectPath(system.getCreationClassName(), namespace);
        CIMProperty name = new CIMProperty("Name", new CIMValue((Object)system.getName(), CIMDataType.getPredefinedType((int)8)));
        ssCIMOP.addKey(name);
        CIMProperty ccName = new CIMProperty("CreationClassName", new CIMValue((Object)system.getCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        ssCIMOP.addKey(ccName);
        return ssCIMOP;
    }

    public static CIMObjectPath getCIMObjectPath(CimkeyTapeLibrary system, String namespace) {
        String mName = system.getName();
        CIMObjectPath ssCIMOP = null;
        ssCIMOP = new CIMObjectPath(system.getCreationClassName(), namespace);
        Vector<CIMProperty> keys = new Vector<CIMProperty>();
        CIMProperty name = new CIMProperty("Name", new CIMValue((Object)system.getName(), CIMDataType.getPredefinedType((int)8)));
        keys.add(name);
        CIMProperty ccName = new CIMProperty("CreationClassName", new CIMValue((Object)system.getCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        keys.add(ccName);
        ssCIMOP.setKeys(keys);
        return ssCIMOP;
    }

    public static CIMObjectPath getCIMObjectPath(CimkeySwitch pSwitch, String pNamespace) {
        CIMObjectPath mSwitchCop = new CIMObjectPath(pSwitch.getCreationClassName(), pNamespace);
        Vector<CIMProperty> mKeys = new Vector<CIMProperty>();
        CIMProperty mName = new CIMProperty("Name", new CIMValue((Object)pSwitch.getName(), CIMDataType.getPredefinedType((int)8)));
        mKeys.add(mName);
        CIMProperty mCreationClassName = new CIMProperty("CreationClassName", new CIMValue((Object)pSwitch.getCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        mKeys.add(mCreationClassName);
        mSwitchCop.setKeys(mKeys);
        return mSwitchCop;
    }

    public static CIMObjectPath getCIMObjectPath(StoragePool pool, String namespace) {
        CIMObjectPath mPoolCIMOP = new CIMObjectPath(pool.getClassName(), namespace);
        Vector<CIMProperty> keys = new Vector<CIMProperty>();
        CIMProperty instanceID = new CIMProperty("InstanceID", new CIMValue((Object)pool.getInstanceId(), CIMDataType.getPredefinedType((int)8)));
        keys.add(instanceID);
        mPoolCIMOP.setKeys(keys);
        return mPoolCIMOP;
    }

    public static CIMObjectPath getCIMObjectPath(ClientSettingData pClientSettingData, String namespace) {
        CIMObjectPath mClientSettingDataCOP = new CIMObjectPath(pClientSettingData.getCreationClassName(), namespace);
        Vector<CIMProperty> keys = new Vector<CIMProperty>();
        CIMProperty instanceID = new CIMProperty("InstanceID", new CIMValue((Object)pClientSettingData.getInstanceId(), CIMDataType.getPredefinedType((int)8)));
        keys.add(instanceID);
        mClientSettingDataCOP.setKeys(keys);
        mClientSettingDataCOP.setNameSpace(namespace);
        return mClientSettingDataCOP;
    }

    public static CIMObjectPath getCIMObjectPath(StorageExtent extent, String namespace) {
        CIMObjectPath extentCIMOP = new CIMObjectPath(extent.getCreationClassName(), namespace);
        Vector<CIMProperty> keys = new Vector<CIMProperty>();
        CIMProperty deviceID = new CIMProperty("DeviceID", new CIMValue((Object)extent.getDeviceId(), CIMDataType.getPredefinedType((int)8)));
        keys.add(deviceID);
        CIMProperty creationClassName = new CIMProperty("CreationClassName", new CIMValue((Object)extent.getCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        keys.add(creationClassName);
        CIMProperty systemCreationClassName = new CIMProperty("SystemCreationClassName", new CIMValue((Object)extent.getSystemCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        keys.add(systemCreationClassName);
        CIMProperty systemName = new CIMProperty("SystemName", new CIMValue((Object)extent.getSystemNames(), CIMDataType.getPredefinedType((int)8)));
        keys.add(systemName);
        extentCIMOP.setKeys(keys);
        return extentCIMOP;
    }

    public static CIMObjectPath getCIMObjectPath(CimkeyVolume vol, String namespace) {
        CIMObjectPath volCIMOP = new CIMObjectPath(vol.getCreationClassName(), namespace);
        Vector<CIMProperty> keys = new Vector<CIMProperty>();
        CIMProperty deviceID = new CIMProperty("DeviceID", new CIMValue((Object)vol.getDeviceId(), CIMDataType.getPredefinedType((int)8)));
        keys.add(deviceID);
        CIMProperty systemName = new CIMProperty("SystemName", new CIMValue((Object)vol.getSystemNames(), CIMDataType.getPredefinedType((int)8)));
        keys.add(systemName);
        CIMProperty ccName = new CIMProperty("CreationClassName", new CIMValue((Object)vol.getCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        keys.add(ccName);
        CIMProperty sccName = new CIMProperty("SystemCreationClassName", new CIMValue((Object)vol.getSystemCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        keys.add(sccName);
        volCIMOP.setKeys(keys);
        return volCIMOP;
    }

    public static CIMObjectPath getCIMObjectPath(CimkeyPort pPort, String namespace) {
        CIMObjectPath mPortCOP = new CIMObjectPath(pPort.getCreationClassName(), namespace);
        Vector<CIMProperty> keys = new Vector<CIMProperty>();
        CIMProperty deviceID = new CIMProperty("DeviceID", new CIMValue((Object)pPort.getDeviceId(), CIMDataType.getPredefinedType((int)8)));
        keys.add(deviceID);
        CIMProperty systemName = new CIMProperty("SystemName", new CIMValue((Object)pPort.getSystemNames(), CIMDataType.getPredefinedType((int)8)));
        keys.add(systemName);
        CIMProperty ccName = new CIMProperty("CreationClassName", new CIMValue((Object)pPort.getCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        keys.add(ccName);
        CIMProperty sccName = new CIMProperty("SystemCreationClassName", new CIMValue((Object)pPort.getSystemCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        keys.add(sccName);
        mPortCOP.setKeys(keys);
        return mPortCOP;
    }

    public static CIMObjectPath getIOGroupCIMObjectPath(String pIpAddress, String pGroupID, String pCreationClassName, String pNamespace) {
        CIMObjectPath mIoGroupCIMOP = new CIMObjectPath(pCreationClassName, pNamespace);
        Vector<CIMProperty> mKeys = new Vector<CIMProperty>();
        String name = pIpAddress + ":" + pGroupID;
        CIMProperty mName = new CIMProperty("Name", new CIMValue((Object)name, CIMDataType.getPredefinedType((int)8)));
        mKeys.add(mName);
        CIMProperty mCreationClassName = new CIMProperty("CreationClassName", new CIMValue((Object)pCreationClassName, CIMDataType.getPredefinedType((int)8)));
        mKeys.add(mCreationClassName);
        mIoGroupCIMOP.setKeys(mKeys);
        return mIoGroupCIMOP;
    }

    protected static void commit(DBConnection pDBConnection) {
        if (pDBConnection != null) {
            LogTraceHelper mLTH = null;
            try {
                pDBConnection.commit();
            }
            catch (SQLException e) {
                mLTH = LogTraceHelper.entry("ExternalKeyManager", "commit", new Object[]{pDBConnection});
                mLTH.traceError("Internal error: SQLException", e);
                throw DiskMessageHelper.getServerException("HWN021503E", null, e, mLTH);
            }
            finally {
                if (mLTH != null) {
                    mLTH.exit(null);
                }
            }
        }
    }
}

