/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.aperi.disk.common.util.Reusable;

public abstract class InstancePool {
    private int cUnusedThreshold = 500;
    private Stack cInstanceStack = new Stack();
    private static int cReturnCount = 0;
    private List cOutOfPoolInstances = new LinkedList();

    protected InstancePool() {
    }

    protected InstancePool(int pUnusedThreshold) {
        this();
        this.cUnusedThreshold = pUnusedThreshold;
    }

    protected final synchronized Reusable getClearInstance() {
        if (!this.cInstanceStack.isEmpty()) {
            Reusable mReturn = (Reusable)this.cInstanceStack.pop();
            if (mReturn == null) {
                return null;
            }
            mReturn.clearInstance();
            mReturn.setIsInPool(false);
            this.cOutOfPoolInstances.add(mReturn);
            return mReturn;
        }
        return null;
    }

    protected final synchronized boolean returnInst(Reusable pInstance) {
        this.cOutOfPoolInstances.remove(pInstance);
        if (this.cInstanceStack.size() < this.cUnusedThreshold) {
            pInstance.clearInstance();
            pInstance.setIsInPool(true);
            this.cInstanceStack.push(pInstance);
            return true;
        }
        return false;
    }

    protected final synchronized boolean removeInst(Reusable pInstance) {
        return this.cOutOfPoolInstances.remove(pInstance);
    }

    public final synchronized void clear() {
        Reusable mStackInst;
        Iterator mInstIt = this.cInstanceStack.iterator();
        while (mInstIt.hasNext()) {
            mStackInst = (Reusable)mInstIt.next();
            mStackInst.releaseInstance();
            mInstIt.remove();
        }
        mInstIt = this.cOutOfPoolInstances.iterator();
        while (mInstIt.hasNext()) {
            mStackInst = (Reusable)mInstIt.next();
            mStackInst.releaseInstance();
            mInstIt.remove();
        }
    }
}

