/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.disk.common.util.MapableReusable;

public abstract class MapPool {
    private Map cPoolMap = new HashMap();
    private int cUnusedThreshold = 5;
    private List cOutOfPoolInstances = new LinkedList();

    protected MapPool(int pUnusedThreshold) {
        this.cUnusedThreshold = pUnusedThreshold;
    }

    protected final synchronized MapableReusable getClearInstance(Object pKey) {
        List mInstPool = (List)this.cPoolMap.get(pKey);
        if (mInstPool == null) {
            return null;
        }
        if (!mInstPool.isEmpty()) {
            MapableReusable mReturn = (MapableReusable)mInstPool.get(mInstPool.size() - 1);
            if (mReturn == null) {
                return null;
            }
            mReturn.clearInstance();
            mReturn.setIsInPool(false);
            this.cOutOfPoolInstances.add(mReturn);
            return mReturn;
        }
        return null;
    }

    protected final synchronized boolean returnInst(MapableReusable pInstance) {
        if (pInstance == null) {
            throw new IllegalArgumentException("instance must not be null");
        }
        Object mKey = pInstance.getMappingKey();
        this.cOutOfPoolInstances.remove(pInstance);
        ArrayList<MapableReusable> mInstPool = (ArrayList<MapableReusable>)this.cPoolMap.get(mKey);
        if (mInstPool == null) {
            mInstPool = new ArrayList<MapableReusable>(this.cUnusedThreshold + 1);
            this.cPoolMap.put(mKey, mInstPool);
        }
        if (mInstPool.size() < this.cUnusedThreshold) {
            pInstance.clearInstance();
            pInstance.setIsInPool(true);
            mInstPool.add(pInstance);
            return true;
        }
        return false;
    }

    public final synchronized void clear() {
        Iterator mPoolIt = this.cPoolMap.entrySet().iterator();
        List mCurrPool = null;
        MapableReusable mInst = null;
        Iterator mInstIt = null;
        while (mPoolIt.hasNext()) {
            mCurrPool = (List)mPoolIt.next().getValue();
            mInstIt = mCurrPool.iterator();
            while (mInstIt.hasNext()) {
                mInst = (MapableReusable)mInstIt.next();
                mInst.releaseInstance();
                mInstIt.remove();
            }
            mPoolIt.remove();
        }
        mInstIt = this.cOutOfPoolInstances.iterator();
        while (mInstIt.hasNext()) {
            mInst = (MapableReusable)mInstIt.next();
            mInst.releaseInstance();
            mInstIt.remove();
        }
    }
}

