/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.discovery.RetryDeleteParameters;
import org.eclipse.aperi.disk.discovery.SubsystemDBHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.tables.TAlertLogTable;
import org.eclipse.aperi.infrastructure.database.tables.TResAttributeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResBackendControllerTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCapabilityDataTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResClientSettingDataTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDiskGroupTable;
import org.eclipse.aperi.infrastructure.database.tables.TResIoGroupTable;
import org.eclipse.aperi.infrastructure.database.tables.TResMaskingInfoTable;
import org.eclipse.aperi.infrastructure.database.tables.TResNamesSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalvolume2extentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRedundancyTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVolume2extentTable;

public class SubSystemDeletion {
    static final String SELECT_CIMKEY_SUBSYSTEM = "Select CAPABILITY_DATA_ID from T_RES_CIMKEY_SUBSYSTEM where SUBSYSTEM_ID = ?";
    private RetryDeleteParameters cRetryParms = new RetryDeleteParameters();
    static final String SELECT_SS_DISKS = "(select PHYSICAL_VOLUME_ID from T_RES_PHYSICAL_VOLUME  where SUBSYSTEM_ID = ?)";
    static final String SELECT_SVC_DISKS = "(select STORAGE_EXTENT_ID from T_RES_STORAGE_EXTENT  where SUBSYSTEM_ID = ?)";
    static final String DELETE_T_STAT_DISK_SS = "delete from T_STAT_DISK where DISK_ID in (select PHYSICAL_VOLUME_ID from T_RES_PHYSICAL_VOLUME  where SUBSYSTEM_ID = ?)";
    static final String DELETE_T_STAT_DISK_HIST_SS = "delete from T_STAT_DISK_HIST where DISK_ID in (select PHYSICAL_VOLUME_ID from T_RES_PHYSICAL_VOLUME  where SUBSYSTEM_ID = ?)";
    static final String DELETE_T_STAT_DISK_SVC = "delete from T_STAT_DISK where DISK_ID in (select STORAGE_EXTENT_ID from T_RES_STORAGE_EXTENT  where SUBSYSTEM_ID = ?)";
    static final String DELETE_T_STAT_DISK_HIST_SVC = "delete from T_STAT_DISK_HIST where DISK_ID in (select STORAGE_EXTENT_ID from T_RES_STORAGE_EXTENT  where SUBSYSTEM_ID = ?)";
    static final String SELECT_SS_AND_SVC_LUNS = "(select SVID from T_RES_STORAGE_VOLUME  where SUBSYSTEM_ID = ?)";
    static final String DELETE_T_RES_CHUNK_SS = "delete from T_RES_CHUNK where LOGICAL_DISK_ID in (select SVID from T_RES_STORAGE_VOLUME  where SUBSYSTEM_ID = ?)";
    static final String DELETE_T_RES_CHUNK_COLLECTION_SS = "delete from T_RES_CHUNK_CLLCTN where LOGICAL_DISK_ID in (select SVID from T_RES_STORAGE_VOLUME  where SUBSYSTEM_ID = ?)";
    static final String RES_STORAGE_SUBSYSTEM = "117";
    static final String RES_DISK_ARRAY = "78";
    private DBPreparedStatement cStmt = null;
    private DBResultSet cRS = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubSystemDeletion() {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "SubSystemDeletion", new Object[0]);
        mLTH.objectCreation(SubSystemDeletion.class.getName());
        try {
            this.cRetryParms.init(mLTH);
        }
        finally {
            mLTH.exit(null);
        }
    }

    private int deleteSSChunkInfo(DBConnection conn, String sqlText, String subsystemID) throws SQLException {
        Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
        mParameters.put(TResStorageVolumeTable.getColumnInfo("SUBSYSTEM_ID"), subsystemID);
        return ComplexQuery.sqlUpdate(conn, sqlText, mParameters);
    }

    private int deleteSSDiskStats(DBConnection conn, String sqlText, String subsystemID) throws SQLException {
        Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
        mParameters.put(TResPhysicalVolumeTable.getColumnInfo("SUBSYSTEM_ID"), subsystemID);
        return ComplexQuery.sqlUpdate(conn, sqlText, mParameters);
    }

    private int deleteSVCDiskStats(DBConnection conn, String sqlText, String subsystemID) throws SQLException {
        Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
        mParameters.put(TResStorageExtentTable.getColumnInfo("SUBSYSTEM_ID"), subsystemID);
        return ComplexQuery.sqlUpdate(conn, sqlText, mParameters);
    }

    public Result cleanupMigratedStorageSubsystem(String pExtSubsystemID) {
        return this.deleteStorageSubsystem(pExtSubsystemID, true);
    }

    public Result deleteStorageSubsystem(String pExtSubsystemID) {
        return this.deleteStorageSubsystem(pExtSubsystemID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Result deleteStorageSubsystem(String pExtSubsystemID, boolean pMigration) {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "deleteStorageSubsystem", new Object[]{pExtSubsystemID, new Boolean(pMigration)});
        DBConnection mConn = null;
        Result mResult = new Result();
        try {
            while (this.cRetryParms.isToRetry()) {
                try {
                    mConn = ServiceUtils.getConnection();
                    mConn.setAutoCommit(false);
                    StorageSubsystem mSS = ExternalKeyManager.getStorageSubsystem(pExtSubsystemID, mConn);
                    String pSubsystemID = Integer.toString(mSS.getSubsystemId());
                    Vector mCapDataIDVec = this.getCimkeySubsystem(pSubsystemID, mConn, mLTH);
                    int mCapabilityDataDeleted = 0;
                    if (!pMigration) {
                        Hashtable<ColumnInfo, String> mWhereCapabilityData = new Hashtable<ColumnInfo, String>();
                        if (mCapDataIDVec != null) {
                            Enumeration e = mCapDataIDVec.elements();
                            while (e.hasMoreElements()) {
                                Integer mCapDataID = (Integer)e.nextElement();
                                mWhereCapabilityData.put(TResCapabilityDataTable.getColumnInfo("CAPABILITY_DATA_ID"), mCapDataID.toString());
                                mLTH.traceInfo("Delete CAPABILITY_DATA with id: " + mCapDataID.toString());
                                mCapabilityDataDeleted += DBQueryAssistant.performDelete(TResCapabilityDataTable.getTablename(), mConn, mWhereCapabilityData);
                            }
                        }
                    }
                    mLTH.traceInfo("Delete DATAPATH");
                    int mDatapathDeleted = this.deleteDataPath(mConn, pSubsystemID);
                    mLTH.traceInfo("Delete CIMKEY_PORTS");
                    int mCIMKeyPortsDeleted = this.deleteCimKeyPorts(mConn, pSubsystemID);
                    mLTH.traceInfo("Delete CIMKEYVOLUME");
                    int mCIMKeyVolumesDeleted = this.deleteCIMKeyVolumes(mConn, pSubsystemID);
                    mLTH.traceInfo("Delete VOLUME2EXTENT");
                    int mVolume2ExtentsDeleted = this.deleteVolume2Extents(mConn, pSubsystemID);
                    Hashtable<ColumnInfo, String> mWhereCIMKEYSubsystem = new Hashtable<ColumnInfo, String>();
                    mWhereCIMKEYSubsystem.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), pSubsystemID);
                    Hashtable<ColumnInfo, String> mWhereClientSettingData = new Hashtable<ColumnInfo, String>();
                    mWhereClientSettingData.put(TResClientSettingDataTable.getColumnInfo("SUBSYSTEM_ID"), pSubsystemID);
                    Hashtable<ColumnInfo, String> mWhereIOGroup = new Hashtable<ColumnInfo, String>();
                    mWhereIOGroup.put(TResIoGroupTable.getColumnInfo("SUBSYSTEM_ID"), pSubsystemID);
                    Hashtable<ColumnInfo, String> mWhereMaskingInfo = new Hashtable<ColumnInfo, String>();
                    mWhereMaskingInfo.put(TResMaskingInfoTable.getColumnInfo("SUBSYSTEM_ID"), pSubsystemID);
                    Hashtable<ColumnInfo, String> mWhereNamesSubsystem = new Hashtable<ColumnInfo, String>();
                    mWhereNamesSubsystem.put(TResNamesSubsystemTable.getColumnInfo("SUBSYSTEM_ID"), pSubsystemID);
                    Hashtable<ColumnInfo, String> mWherePhysicalVolume = new Hashtable<ColumnInfo, String>();
                    mWherePhysicalVolume.put(TResPhysicalVolumeTable.getColumnInfo("SUBSYSTEM_ID"), pSubsystemID);
                    Hashtable<ColumnInfo, String> mWherePort = new Hashtable<ColumnInfo, String>();
                    mWherePort.put(TResPortTable.getColumnInfo("SUBSYSTEM_ID"), pSubsystemID);
                    Hashtable<ColumnInfo, String> mWhereRedundancy = new Hashtable<ColumnInfo, String>();
                    mWhereRedundancy.put(TResRedundancyTable.getColumnInfo("SUBSYSTEM_ID"), pSubsystemID);
                    Hashtable<ColumnInfo, String> mWhereStorageExtend = new Hashtable<ColumnInfo, String>();
                    mWhereStorageExtend.put(TResStorageExtentTable.getColumnInfo("SUBSYSTEM_ID"), pSubsystemID);
                    Hashtable<ColumnInfo, String> mWhereStoragePool = new Hashtable<ColumnInfo, String>();
                    mWhereStoragePool.put(TResStoragePoolTable.getColumnInfo("SUBSYSTEM_ID"), pSubsystemID);
                    Hashtable<ColumnInfo, String> mWhereStorageVolume = new Hashtable<ColumnInfo, String>();
                    mWhereStorageVolume.put(TResStorageVolumeTable.getColumnInfo("SUBSYSTEM_ID"), pSubsystemID);
                    Hashtable<ColumnInfo, String> mWhereDiskGroup = new Hashtable<ColumnInfo, String>();
                    mWhereDiskGroup.put(TResDiskGroupTable.getColumnInfo("SUBSYSTEM_ID"), pSubsystemID);
                    Hashtable<ColumnInfo, String> mWhereBackendController = new Hashtable<ColumnInfo, String>();
                    mWhereBackendController.put(TResBackendControllerTable.getColumnInfo("OWNING_SUBSYSTEM_ID"), pSubsystemID);
                    Hashtable<ColumnInfo, String> mWhereAttributeSS = new Hashtable<ColumnInfo, String>();
                    mWhereAttributeSS.put(TResAttributeTable.getColumnInfo("RESOURCE_ID"), pSubsystemID);
                    mWhereAttributeSS.put(TResAttributeTable.getColumnInfo("RESOURCE_TYPE"), RES_STORAGE_SUBSYSTEM);
                    Hashtable<ColumnInfo, String> mWhereAttributeArray = new Hashtable<ColumnInfo, String>();
                    mWhereAttributeArray.put(TResAttributeTable.getColumnInfo("RESOURCE_ID"), pSubsystemID);
                    mWhereAttributeArray.put(TResAttributeTable.getColumnInfo("RESOURCE_TYPE"), RES_DISK_ARRAY);
                    Hashtable<ColumnInfo, String> mWhereStorageSubsystem = new Hashtable<ColumnInfo, String>();
                    mWhereStorageSubsystem.put(TResStorageSubsystemTable.getColumnInfo("SUBSYSTEM_ID"), pSubsystemID);
                    int mTStatDiskDeleted = 0;
                    int mTStatDiskHistDeleted = 0;
                    if (!pMigration) {
                        mLTH.traceInfo("Delete T_STAT_DISK");
                        mTStatDiskDeleted = this.deleteSSDiskStats(mConn, DELETE_T_STAT_DISK_SS, pSubsystemID);
                        mTStatDiskDeleted += this.deleteSVCDiskStats(mConn, DELETE_T_STAT_DISK_SVC, pSubsystemID);
                        mLTH.traceInfo("Delete T_STAT_DISK_HIST");
                        mTStatDiskHistDeleted = this.deleteSSDiskStats(mConn, DELETE_T_STAT_DISK_HIST_SS, pSubsystemID);
                        mTStatDiskHistDeleted += this.deleteSVCDiskStats(mConn, DELETE_T_STAT_DISK_HIST_SVC, pSubsystemID);
                    }
                    mLTH.traceInfo("Delete T_RES_CHUNK");
                    int mTResChunkDeleted = this.deleteSSChunkInfo(mConn, DELETE_T_RES_CHUNK_SS, pSubsystemID);
                    mLTH.traceInfo("Delete T_RES_CHUNK_CLLCTN");
                    int mTResChunkCllctnDeleted = this.deleteSSChunkInfo(mConn, DELETE_T_RES_CHUNK_COLLECTION_SS, pSubsystemID);
                    int mCIMKEYSubsystemDeleted = 0;
                    if (!pMigration) {
                        mLTH.traceInfo("Delete CIMKEY_SUBSYSTEM");
                        mCIMKEYSubsystemDeleted = DBQueryAssistant.performDelete(TResCimkeySubsystemTable.getTablename(), mConn, mWhereCIMKEYSubsystem);
                    }
                    mLTH.traceInfo("Delete CLIENT_SETTING_DATA");
                    int mClientSettingDataDeleted = DBQueryAssistant.performDelete(TResClientSettingDataTable.getTablename(), mConn, mWhereClientSettingData);
                    mLTH.traceInfo("Delete IO_GROUP");
                    int mIOGroupDeleted = DBQueryAssistant.performDelete(TResIoGroupTable.getTablename(), mConn, mWhereIOGroup);
                    mLTH.traceInfo("Delete MASKING_INFO");
                    int mMaskingInfoDeleted = DBQueryAssistant.performDelete(TResMaskingInfoTable.getTablename(), mConn, mWhereMaskingInfo);
                    int mNamesSubsystemDeleted = 0;
                    int mPhysicalVolumeDeleted = 0;
                    if (!pMigration) {
                        mLTH.traceInfo("Delete NAMES_SUBSYSTEM");
                        mNamesSubsystemDeleted = DBQueryAssistant.performDelete(TResNamesSubsystemTable.getTablename(), mConn, mWhereNamesSubsystem);
                        mLTH.traceInfo("Delete PHYSICAL_VOLUME");
                        mPhysicalVolumeDeleted = DBQueryAssistant.performDelete(TResPhysicalVolumeTable.getTablename(), mConn, mWherePhysicalVolume);
                    }
                    mLTH.traceInfo("Delete PORT");
                    int mPortDeleted = DBQueryAssistant.performDelete(TResPortTable.getTablename(), mConn, mWherePort);
                    mLTH.traceInfo("Delete REDUNDANCY");
                    int mRedundancyDeleted = DBQueryAssistant.performDelete(TResRedundancyTable.getTablename(), mConn, mWhereRedundancy);
                    mLTH.traceInfo("Delete STORAGE_EXTENT");
                    int mStorageExtendDeleted = DBQueryAssistant.performDelete(TResStorageExtentTable.getTablename(), mConn, mWhereStorageExtend);
                    mLTH.traceInfo("Delete STORAGE_POOL");
                    int mStoragPoolDeleted = DBQueryAssistant.performDelete(TResStoragePoolTable.getTablename(), mConn, mWhereStoragePool);
                    mLTH.traceInfo("Delete STORAGE_VOLUME");
                    int mStorageVolumeDeleted = DBQueryAssistant.performDelete(TResStorageVolumeTable.getTablename(), mConn, mWhereStorageVolume);
                    mLTH.traceInfo("Delete DISK_GROUP");
                    int mDiskGroupDeleted = DBQueryAssistant.performDelete(TResDiskGroupTable.getTablename(), mConn, mWhereDiskGroup);
                    mLTH.traceInfo("Delete BACKEND_CONTROLLER");
                    int mBackendControllerDeleted = DBQueryAssistant.performDelete(TResBackendControllerTable.getTablename(), mConn, mWhereBackendController);
                    int mAttribute_SS_Deleted = 0;
                    int mAttribute_ARRAY_Deleted = 0;
                    int mStoragSubsystemAlertLogsDeleted = 0;
                    int mStorageSubsystemDeleted = 0;
                    if (!pMigration) {
                        mLTH.traceInfo("Delete ATTRIBUTE with STORAGE_SUBSYSTEM");
                        mAttribute_SS_Deleted = DBQueryAssistant.performDelete(TResAttributeTable.getTablename(), mConn, mWhereAttributeSS);
                        mLTH.traceInfo("Delete ATTRIBUTE with DISK_ARRAY");
                        mAttribute_ARRAY_Deleted = DBQueryAssistant.performDelete(TResAttributeTable.getTablename(), mConn, mWhereAttributeArray);
                        mLTH.traceInfo("Delete STORAGE_SUBSYSTEM ALERTS");
                        mStoragSubsystemAlertLogsDeleted = this.deleteAlertLogs(mConn, mWhereStorageSubsystem, TResStorageSubsystemTable.getTablename(), new String("SUBSYSTEM_ID"));
                        mStorageSubsystemDeleted = 0;
                        mLTH.traceInfo("Delete STORAGE_SUBSYSTEM");
                        mStorageSubsystemDeleted = DBQueryAssistant.performDelete(TResStorageSubsystemTable.getTablename(), mConn, mWhereStorageSubsystem);
                    }
                    mLTH.traceInfo("Commit!");
                    mConn.commit();
                    this.cRetryParms.setToRetry(false);
                    StringBuffer mItemsDeleted = new StringBuffer();
                    mItemsDeleted.append("Deleted STORAGE_SUBSYSTEM with ID: " + pSubsystemID + "\n");
                    mItemsDeleted.append("  - CAPABILITY_DATA: " + mCapabilityDataDeleted + "\n");
                    mItemsDeleted.append("  - DATAPATH: " + mDatapathDeleted + "\n");
                    mItemsDeleted.append("  - CIMKEY_PORTS: " + mCIMKeyPortsDeleted + "\n");
                    mItemsDeleted.append("  - CIMKEYVOLUME: " + mCIMKeyVolumesDeleted + "\n");
                    mItemsDeleted.append("  - VOLUME2EXTENT: " + mVolume2ExtentsDeleted + "\n");
                    mItemsDeleted.append("  - T_STAT_DISK: " + mTStatDiskDeleted + "\n");
                    mItemsDeleted.append("  - T_STAT_DISK_HIST: " + mTStatDiskHistDeleted + "\n");
                    mItemsDeleted.append("  - T_RES_CHUNK: " + mTResChunkDeleted + "\n");
                    mItemsDeleted.append("  - T_RES_CHUNK_CLLCTN: " + mTResChunkCllctnDeleted + "\n");
                    mItemsDeleted.append("  - CIMKEY_SUBSYSTEM: " + mCIMKEYSubsystemDeleted + "\n");
                    mItemsDeleted.append("  - CLIENT_SETTING_DATA: " + mClientSettingDataDeleted + "\n");
                    mItemsDeleted.append("  - IO_GROUP: " + mIOGroupDeleted + "\n");
                    mItemsDeleted.append("  - MASKING_INFO: " + mMaskingInfoDeleted + "\n");
                    mItemsDeleted.append("  - NAMES_SUBSYSTEM: " + mNamesSubsystemDeleted + "\n");
                    mItemsDeleted.append("  - PHYSICAL_VOLUME: " + mPhysicalVolumeDeleted + "\n");
                    mItemsDeleted.append("  - PORT: " + mPortDeleted + "\n");
                    mItemsDeleted.append("  - REDUNDANCY: " + mRedundancyDeleted + "\n");
                    mItemsDeleted.append("  - STORAGE_EXTENT: " + mStorageExtendDeleted + "\n");
                    mItemsDeleted.append("  - STORAGE_POOL: " + mStoragPoolDeleted + "\n");
                    mItemsDeleted.append("  - STORAGE_VOLUME: " + mStorageVolumeDeleted + "\n");
                    mItemsDeleted.append("  - DISK_GROUP: " + mDiskGroupDeleted + "\n");
                    mItemsDeleted.append("  - BACKEND_CONTROLLER: " + mBackendControllerDeleted + "\n");
                    mItemsDeleted.append("  - ATTRIBUTES StorrageSubsystems: " + mAttribute_SS_Deleted + "\n");
                    mItemsDeleted.append("  - ATTRIBUTES ARRAYS: " + mAttribute_ARRAY_Deleted + "\n");
                    mItemsDeleted.append("  - STORAGE_SUBSYSTEML_ALERT_LOGS: " + mStoragSubsystemAlertLogsDeleted + "\n");
                    mItemsDeleted.append("---------------------------------------------\n");
                    mResult.setSRMMessage("HWN021671I", new String[]{pExtSubsystemID});
                    mLTH.traceInfo(mItemsDeleted.toString());
                }
                catch (SQLException pEx) {
                    try {
                        if (SQLExceptionHelper.isDeadlock(mConn, pEx)) {
                            if (!SubsystemDBHelper.handleDeadlock(mConn, mLTH, this.cRetryParms, pEx, mResult, pExtSubsystemID)) continue;
                            continue;
                        }
                    }
                    catch (SQLException ignored) {
                        // empty catch block
                        continue;
                    }
                    {
                        pEx.printStackTrace();
                        try {
                            mConn.rollback();
                            mLTH.traceInfo("rollback!");
                            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), mLTH);
                        }
                        catch (SQLException pEx1) {
                            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), mLTH);
                        }
                    }
                }
                catch (IDParseException mEX) {
                    this.cRetryParms.setToRetry(false);
                    throw DiskMessageHelper.getInvalidParameterException(1, "HWN020003E", pExtSubsystemID, mLTH);
                }
                catch (EntityNotFoundException mEX) {
                    this.cRetryParms.setToRetry(false);
                    throw DiskMessageHelper.getInvalidParameterException(1, "HWN021657E", pExtSubsystemID, mLTH);
                }
                finally {
                    try {
                        if (this.cStmt != null) {
                            this.cStmt.close();
                        }
                        if (this.cRS != null) {
                            this.cRS.close();
                        }
                        mConn.close();
                    }
                    catch (SQLException pEx) {
                        throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), mLTH);
                    }
                }
            }
        }
        finally {
            mLTH.exit(mResult);
            return mResult;
        }
    }

    private int deleteAlertLogs(DBConnection pConn, Hashtable pWhereResource, String pTable, String pColumn) throws SQLException {
        int mResult = 0;
        Vector<String> mColumns = new Vector<String>();
        mColumns.add(pColumn);
        DBResultSet mIds = DBQueryAssistant.performRetrieve(pTable, pConn, pWhereResource, mColumns);
        while (mIds.next()) {
            int bResourceID = mIds.getInt(pColumn);
            Hashtable<ColumnInfo, String> bWhereAlertResource = new Hashtable<ColumnInfo, String>();
            bWhereAlertResource.put(TAlertLogTable.getColumnInfo("RESOURCE_ID"), Integer.toString(bResourceID));
            mResult += DBQueryAssistant.performDelete(TAlertLogTable.getTablename(), pConn, bWhereAlertResource);
        }
        mIds.closeAll();
        return mResult;
    }

    private DBResultSet runStatement(DBConnection pConn, String pSQLStatment, String[] pParam, LogTraceHelper pLTH, int pType) throws SQLException {
        pLTH.traceInfo(pSQLStatment + " with :" + ParameterHelper.stringArrayToString(pParam));
        this.cStmt = pConn.prepareStatement(pSQLStatment);
        for (int bLoop = 0; bLoop < pParam.length; ++bLoop) {
            this.cStmt.setString(bLoop + 1, pParam[bLoop]);
        }
        if (pType == 1) {
            return this.cStmt.executeQuery();
        }
        this.cStmt.executeUpdate();
        return null;
    }

    private Vector getCimkeySubsystem(String pSubsystemID, DBConnection pConn, LogTraceHelper pLTH) throws SQLException {
        Vector<Integer> mRetVec = null;
        this.cRS = this.runStatement(pConn, SELECT_CIMKEY_SUBSYSTEM, new String[]{pSubsystemID}, pLTH, 1);
        if (this.cRS != null) {
            mRetVec = new Vector<Integer>();
            while (this.cRS.next()) {
                mRetVec.add(new Integer(this.cRS.getInt(1)));
            }
        }
        if (mRetVec == null) {
            pLTH.traceInfo("No CIMKEY_SUBSYSTEM found for deletion ... Capabilities will not be deleted!");
        }
        return mRetVec;
    }

    private int[] getVolumes(DBConnection pConnection, String pStorageSubsystemId) throws SQLException {
        Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
        mParameters.put(TResStorageVolumeTable.getColumnInfo("SUBSYSTEM_ID"), pStorageSubsystemId);
        String mQueryString = "SELECT SVID FROM " + TResStorageVolumeTable.getTablename() + " WHERE " + "SUBSYSTEM_ID" + " = (?)";
        DBResultSet mDbResult = ComplexQuery.sqlQuery(pConnection, mQueryString, mParameters);
        ArrayList<Integer> mResult = new ArrayList<Integer>();
        while (mDbResult.next()) {
            mResult.add(new Integer(mDbResult.getInt(1)));
        }
        mDbResult.close();
        int[] mReturn = new int[mResult.size()];
        for (int i = 0; i < mReturn.length; ++i) {
            mReturn[i] = (Integer)mResult.get(i);
        }
        return mReturn;
    }

    private int[] getPorts(DBConnection pConnection, String pStorageSubsystemId) throws SQLException {
        Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
        mParameters.put(TResPortTable.getColumnInfo("SUBSYSTEM_ID"), pStorageSubsystemId);
        String mQueryString = "SELECT PORT_ID FROM " + TResPortTable.getTablename() + " WHERE " + "SUBSYSTEM_ID" + " = (?)";
        DBResultSet mDbResult = ComplexQuery.sqlQuery(pConnection, mQueryString, mParameters);
        ArrayList<Integer> mResult = new ArrayList<Integer>();
        while (mDbResult.next()) {
            mResult.add(new Integer(mDbResult.getInt(1)));
        }
        mDbResult.close();
        int[] mReturn = new int[mResult.size()];
        for (int i = 0; i < mReturn.length; ++i) {
            mReturn[i] = (Integer)mResult.get(i);
        }
        return mReturn;
    }

    private int[] getExtents(DBConnection pConnection, String pStorageSubsystemId) throws SQLException {
        Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
        mParameters.put(TResStorageExtentTable.getColumnInfo("SUBSYSTEM_ID"), pStorageSubsystemId);
        String mQueryString = "SELECT STORAGE_EXTENT_ID FROM " + TResStorageExtentTable.getTablename() + " WHERE " + "SUBSYSTEM_ID" + " = (?)";
        DBResultSet mDbResult = ComplexQuery.sqlQuery(pConnection, mQueryString, mParameters);
        ArrayList<Integer> mResult = new ArrayList<Integer>();
        while (mDbResult.next()) {
            mResult.add(new Integer(mDbResult.getInt(1)));
        }
        mDbResult.close();
        int[] mReturn = new int[mResult.size()];
        for (int i = 0; i < mReturn.length; ++i) {
            mReturn[i] = (Integer)mResult.get(i);
        }
        return mReturn;
    }

    private int deleteCIMKeyVolumes(DBConnection pConnection, String pSubsystemID) throws SQLException {
        int[] mVolumes = this.getVolumes(pConnection, pSubsystemID);
        int mDeleted = 0;
        for (int i = 0; i < mVolumes.length; ++i) {
            Hashtable<ColumnInfo, String> mWhereCIMKeyVolume = new Hashtable<ColumnInfo, String>();
            mWhereCIMKeyVolume.put(TResCimkeyVolumeTable.getColumnInfo("VOLUME_ID"), Integer.toString(mVolumes[i]));
            mDeleted += DBQueryAssistant.performDelete(TResCimkeyVolumeTable.getTablename(), pConnection, mWhereCIMKeyVolume);
        }
        return mDeleted;
    }

    private int deleteCimKeyPorts(DBConnection pConnection, String pSubsystemID) throws SQLException {
        int[] mPorts = this.getPorts(pConnection, pSubsystemID);
        int mDeleted = 0;
        for (int i = 0; i < mPorts.length; ++i) {
            Hashtable<ColumnInfo, String> mWhereCIMKeyPort = new Hashtable<ColumnInfo, String>();
            mWhereCIMKeyPort.put(TResCimkeyPortTable.getColumnInfo("PORT_ID"), Integer.toString(mPorts[i]));
            mDeleted += DBQueryAssistant.performDelete(TResCimkeyPortTable.getTablename(), pConnection, mWhereCIMKeyPort);
        }
        return mDeleted;
    }

    private int deleteVolume2Extents(DBConnection pConnection, String pSubsystemID) throws SQLException {
        int[] mStorageExtents = this.getExtents(pConnection, pSubsystemID);
        int mDeleted = 0;
        for (int i = 0; i < mStorageExtents.length; ++i) {
            String bStrExt = Integer.toString(mStorageExtents[i]);
            Hashtable<ColumnInfo, String> mWhereStorageExtent = new Hashtable<ColumnInfo, String>();
            mWhereStorageExtent.put(TResStorageExtentTable.getColumnInfo("STORAGE_EXTENT_ID"), bStrExt);
            mDeleted += DBQueryAssistant.performDelete(TResStorageExtentTable.getTablename(), pConnection, mWhereStorageExtent);
            mWhereStorageExtent.clear();
            mWhereStorageExtent.put(TResVolume2extentTable.getColumnInfo("STORAGE_EXTENT_ID"), bStrExt);
            mDeleted += DBQueryAssistant.performDelete(TResVolume2extentTable.getTablename(), pConnection, mWhereStorageExtent);
            mWhereStorageExtent.clear();
            mWhereStorageExtent.put(TResPhysicalvolume2extentTable.getColumnInfo("STORAGE_EXTENT_ID"), bStrExt);
            mDeleted += DBQueryAssistant.performDelete(TResPhysicalvolume2extentTable.getTablename(), pConnection, mWhereStorageExtent);
        }
        return mDeleted;
    }

    private int deleteDataPath(DBConnection pConnection, String pSubsystemID) throws SQLException {
        int mDeleted = 0;
        Hashtable<ColumnInfo, String> mWhereStorageSubsystem = new Hashtable<ColumnInfo, String>();
        mWhereStorageSubsystem.put(TResStorageSubsystemTable.getColumnInfo("SUBSYSTEM_ID"), pSubsystemID);
        mDeleted = DBQueryAssistant.performDelete(TResDataPathTable.getTablename(), pConnection, mWhereStorageSubsystem);
        return mDeleted;
    }

    private int deleteDataPathAlerts(DBConnection pConnection, String pSubsystemID) throws SQLException {
        int[] mTargetPorts = this.getPorts(pConnection, pSubsystemID);
        int mDeleted = 0;
        for (int i = 0; i < mTargetPorts.length; ++i) {
            Hashtable<ColumnInfo, String> mWhereDataPath = new Hashtable<ColumnInfo, String>();
            mWhereDataPath.put(TResDataPathTable.getColumnInfo("TARGET_PORT_ID"), Integer.toString(mTargetPorts[i]));
            mDeleted += this.deleteAlertLogs(pConnection, mWhereDataPath, TResDataPathTable.getTablename(), new String("DATA_PATH_ID"));
        }
        return mDeleted;
    }
}

