/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import javax.swing.event.TreeSelectionEvent;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.AlertManager;
import org.eclipse.aperi.gui.Alertable;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertHistoryNode
extends Alertable {
    protected short productCode;
    protected short objectType;
    protected byte subProduct;
    protected boolean[] productMask;

    public AlertHistoryNode(short pProductCode, short pObjectType, byte pSubProduct, boolean isRoot) {
        this.setAllowsChildren(isRoot);
        this.productCode = pProductCode;
        this.subProduct = pSubProduct;
        this.objectType = pObjectType;
        String label = this.allowsChildren ? MessageLog.getMessageNoID("STG1303L") : (this.objectType < 0 ? MessageLog.getMessageNoID("STG0005T") : CreateOrEditDDI.getObjectTypeName(this.objectType));
        this.setUserObject(label);
        AlertManager.register(this.productCode, this.objectType, this.subProduct, this);
    }

    public AlertHistoryNode(short pProductCode, String msgID, byte pSubProduct, boolean isRoot) {
        this.setAllowsChildren(isRoot);
        this.productCode = pProductCode;
        this.subProduct = pSubProduct;
        this.objectType = (short)-1;
        this.setUserObject(MessageLog.getMessageNoID(msgID));
        AlertManager.register(this.productCode, this.objectType, this.subProduct, this);
    }

    public AlertHistoryNode(short pProductCode, short pObjectType, boolean isRoot) {
        this(pProductCode, pObjectType, -1, isRoot);
    }

    public AlertHistoryNode(short pProductCode, String msgID, boolean isRoot) {
        this(pProductCode, msgID, -1, isRoot);
    }

    public AlertHistoryNode(short pProductCode) {
        this(pProductCode, -1, -1, false);
    }

    public AlertHistoryNode(short pProductCode, byte pSubProduct) {
        this(pProductCode, -1, pSubProduct, false);
    }

    public AlertHistoryNode(short pProductCode, short pObjectType) {
        this(pProductCode, pObjectType, -1, false);
    }

    public AlertHistoryNode(short pProductCode, short pObjectType, byte pSubProduct) {
        this(pProductCode, pObjectType, pSubProduct, false);
    }

    public AlertHistoryNode(short pProductCode, boolean isRoot) {
        this(pProductCode, -1, -1, isRoot);
    }

    public void select(TreeSelectionEvent event) {
        if (this.allowsChildren) {
            this.selectable = true;
        } else {
            AlertLogDDI DDI;
            if (this.objectType < 0) {
                DDI = new AlertLogDDI(this.productCode, this.subProduct, this.productMask);
            } else {
                NameList obj = new NameList();
                obj.nlID = -1;
                obj.nlInfo = this.objectType;
                DDI = new AlertLogDDI(obj, this.productCode, this.subProduct, this.productMask);
            }
            ((DataDisplayInfo)DDI).reDisplay();
        }
    }
}

