/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.NodeMap;
import org.eclipse.aperi.gui.PrintPreviewable;
import org.eclipse.aperi.gui.TSRMTreeLabel;

public class BaseTree
extends JTree
implements PrintPreviewable {
    public static DefaultTreeModel MyTree;
    public static BaseTreeNode root;
    public static BaseTree pBaseTree;
    public static BaseTreeNode selectedNode;
    public static BaseTreeNode popupNode;
    public static TreePath selectedPath;
    public static Font plainFont;
    public static Font boldFont;
    private static Font monospaceFont;
    private boolean collapsingBranch = false;
    private boolean reSelectNode = false;
    private boolean vetoSelection = false;
    private static BaseTreeNode printingSubNode;
    private int maxPageNumber = 0;
    private int maxCharWidth = 0;
    private PageFormat pageFormat = null;
    private ArrayList visibleNodes;
    private int startPoint = 0;

    public BaseTree() {
        pBaseTree = this;
        plainFont = this.getFont().deriveFont(0);
        boldFont = this.getFont().deriveFont(1);
        printingSubNode = root = new TSRMTreeLabel();
        MyTree = new DefaultTreeModel(root, true);
        this.setModel(MyTree);
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new BaseTreeCellRenderer());
        BaseTreeWillExpand lBaseTreeWillExpand = new BaseTreeWillExpand();
        this.addTreeWillExpandListener(lBaseTreeWillExpand);
        BaseTreeExpanded listener = new BaseTreeExpanded();
        this.addTreeExpansionListener(listener);
        BaseTreeSelection lBaseTreeSelection = new BaseTreeSelection();
        this.addTreeSelectionListener(lBaseTreeSelection);
        BaseTreeMouse aBaseTreeMouse = new BaseTreeMouse();
        this.addMouseListener(aBaseTreeMouse);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    public static void setPrintableSubTree(BaseTreeNode subNode) {
        printingSubNode = subNode;
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex > this.maxPageNumber) {
            return 1;
        }
        this.pageFormat = pf;
        g.translate((int)pf.getImageableX(), (int)pf.getImageableY());
        g.setColor(BaseTree.printingSubNode.nodeColor);
        int pageWidth = (int)pf.getImageableWidth();
        int pageHeight = (int)pf.getImageableHeight();
        FontMetrics fm = g.getFontMetrics(this.getFont());
        this.maxCharWidth = fm.getMaxAdvance();
        this.visibleNodes = new ArrayList();
        this.maxPageNumber = 0;
        monospaceFont = new Font("Monospaced", this.getFont().getStyle(), this.getFont().getSize());
        this.startPoint = this.getPathBounds((TreePath)new TreePath((Object[])BaseTree.printingSubNode.getPath())).y;
        this.calculatePagesRequired(printingSubNode, pageWidth, pageHeight -= fm.getHeight() * 6);
        int y = 0;
        boolean index = false;
        boolean pageFound = false;
        for (int i = 0; i < this.visibleNodes.size(); ++i) {
            NodeMap node = (NodeMap)this.visibleNodes.get(i);
            if (node.getPageIndex() != pageIndex) continue;
            pageFound = true;
            this.printTreeNode(node.getNode(), g, y, pageIndex, this.pageFormat);
            y += this.getPathBounds((TreePath)new TreePath((Object[])node.getNode().getPath())).height;
        }
        if (pageFound) {
            return 0;
        }
        return 1;
    }

    private void printTreeNode(BaseTreeNode node, Graphics g, int y, int pageIndex, PageFormat pf) {
        g.setFont(boldFont);
        g.setColor(Color.black);
        FontMetrics fm = g.getFontMetrics();
        if (pageIndex == 0) {
            g.drawString(PrintPreviewable.CREATED_BY + " " + GuiUtil.getUserName() + "     " + PrintPreviewable.PRINTED_ON + " " + Util.formatDateTime(new Date()), 0, fm.getAscent());
        }
        g.drawString(printingSubNode.toString(), 0, fm.getHeight() * 2);
        y += fm.getHeight() * 4;
        g.setColor(node.nodeColor);
        g.setFont(monospaceFont);
        String handle = "  ";
        if (node.getAllowsChildren()) {
            handle = this.isExpanded(new TreePath(node.getPath())) ? "- " : "+ ";
        }
        g.drawString(handle, this.maxCharWidth * node.getLevel(), y);
        fm = g.getFontMetrics();
        int indent = (int)fm.getStringBounds(handle, g).getWidth() + this.maxCharWidth * node.getLevel();
        g.setFont(this.getFont());
        fm = g.getFontMetrics();
        g.drawString(node.toString(), indent, y);
        g.drawString(Util.getString("LABEL_PAGE_X_OF_Y", Integer.toString(pageIndex + 1), Integer.toString(this.getNumberOfPages())), 0, (int)(pf.getImageableHeight() - (double)fm.getHeight()));
    }

    private void calculatePagesRequired(BaseTreeNode node, int pageWidth, int pageHeight) {
        this.visibleNodes.add(new NodeMap(node, this.maxPageNumber));
        if (node.getAllowsChildren() && pBaseTree.isExpanded(new TreePath(node.getPath()))) {
            int count = node.getChildCount();
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                BaseTreeNode child = (BaseTreeNode)e.nextElement();
                int endTop = this.getPathBounds((TreePath)new TreePath((Object[])child.getPath())).y;
                int endHeight = this.getPathBounds((TreePath)new TreePath((Object[])child.getPath())).height;
                int endPoint = endTop + endHeight;
                if (endPoint - this.startPoint > pageHeight) {
                    ++this.maxPageNumber;
                    this.startPoint = this.getPathBounds((TreePath)new TreePath((Object[])child.getPath())).y;
                }
                if (child.getChildCount() > 0) {
                    this.calculatePagesRequired(child, pageWidth, pageHeight);
                    continue;
                }
                this.visibleNodes.add(new NodeMap(child, this.maxPageNumber));
            }
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
    }

    public void collapseBranch(BaseTreeNode node) {
        BaseTreeNode treenode;
        this.collapsingBranch = true;
        Enumeration<TreeNode> nodes = node.depthFirstEnumeration();
        while ((treenode = (BaseTreeNode)nodes.nextElement()) != null) {
            this.collapsePath(new TreePath(treenode.getPath()));
        }
        this.collapsingBranch = false;
        if (node == root) {
            root.expand(null);
            MyTree.nodeStructureChanged(root);
        }
    }

    private void reselect(TreePath path, boolean checkVisible, BaseTreeNode node) {
        if (checkVisible && !this.isVisible(path)) {
            path = null;
        }
        this.reSelectNode = true;
        this.setSelectionPath(path);
        if (!checkVisible) {
            this.scrollPathToVisible(path);
        }
        this.reSelectNode = false;
        selectedNode = node;
        selectedPath = path;
    }

    private void reselect(TreePath path, BaseTreeNode node) {
        this.reselect(path, true, node);
    }

    public void reselect(BaseTreeNode node, boolean checkVisible) {
        if (node == null) {
            this.setSelectionRow(0);
        } else {
            this.reselect(new TreePath(node.getPath()), checkVisible, node);
        }
    }

    public void reselect(BaseTreeNode node) {
        this.reselect(node, true);
    }

    public void newTree() {
        root.removeAllChildren();
        root.expandBranch(1);
        this.setVisible(true);
    }

    public void setScale(int scale) {
    }

    public int fitToPage(PageFormat pf) {
        return 100;
    }

    public void setBufferedImage(BufferedImage bi) {
    }

    public int getNumberOfPages() {
        return this.maxPageNumber + 1;
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.pageFormat;
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    static {
        selectedNode = null;
        popupNode = null;
        selectedPath = null;
    }

    private class BaseTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            this.setFont(plainFont);
            ((BaseTreeNode)value).render(this, (BaseTree)tree, sel, expanded, leaf, row, hasFocus);
            return this;
        }
    }

    private class BaseTreeMouse
    extends MouseAdapter {
        private BaseTreeMouse() {
        }

        public void mousePressed(MouseEvent event) {
            this.checkPopup(event);
        }

        public void mouseReleased(MouseEvent event) {
            this.checkPopup(event);
        }

        private void checkPopup(MouseEvent event) {
            if (event.isPopupTrigger() && BaseTree.this.getRowForLocation(event.getX(), event.getY()) > -1) {
                BaseTreeNode node;
                TreePath path = BaseTree.this.getPathForLocation(event.getX(), event.getY());
                popupNode = node = (BaseTreeNode)path.getLastPathComponent();
                node.showPopupMenu(event);
            }
        }
    }

    private class BaseTreeSelection
    implements TreeSelectionListener {
        private BaseTreeSelection() {
        }

        public void valueChanged(TreeSelectionEvent event) {
            BaseTreeNode node = (BaseTreeNode)BaseTree.this.getLastSelectedPathComponent();
            if (node != null && !BaseTree.this.reSelectNode) {
                boolean selectable;
                boolean expandUponSelect = false;
                if (BaseTree.this.vetoSelection || BaseTree.this.collapsingBranch) {
                    selectable = false;
                    BaseTree.this.vetoSelection = false;
                } else {
                    node.select(event);
                    selectable = node.selectable;
                    if (!selectable) {
                        expandUponSelect = node.getAllowsChildren();
                    }
                }
                if (!selectable) {
                    TreePath oldPath = event.getOldLeadSelectionPath();
                    BaseTree.this.reselect(oldPath, node);
                } else {
                    selectedNode = node;
                    selectedPath = event.getNewLeadSelectionPath();
                }
                if (expandUponSelect) {
                    TreePath path = event.getNewLeadSelectionPath();
                    if (BaseTree.this.isExpanded(path)) {
                        BaseTree.this.collapsePath(path);
                    } else {
                        BaseTree.this.expandPath(path);
                    }
                }
            }
        }
    }

    private class BaseTreeExpanded
    implements TreeExpansionListener {
        private BaseTreeExpanded() {
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            BaseTreeNode node = null;
            DataDisplayInfo ddi = DataDisplayInfo.getCurrent();
            if (ddi != null) {
                node = ddi.treeNode;
            }
            if (node != null) {
                TreePath pathToNode = new TreePath(node.getPath());
                if (event.getPath().isDescendant(pathToNode)) {
                    BaseTree.this.reselect(pathToNode, node);
                }
            }
        }
    }

    private class BaseTreeWillExpand
    implements TreeWillExpandListener {
        private BaseTreeWillExpand() {
        }

        public void treeWillExpand(TreeExpansionEvent event) {
            ((BaseTreeNode)event.getPath().getLastPathComponent()).expand(event);
        }

        public void treeWillCollapse(TreeExpansionEvent event) {
            ((BaseTreeNode)event.getPath().getLastPathComponent()).collapse(event);
            if (event.getPath().isDescendant(BaseTree.this.getSelectionPath())) {
                BaseTree.this.vetoSelection = true;
            }
        }
    }
}

