/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.common.ProbePing;
import org.eclipse.aperi.TStorm.gui.ReportCreateOrEdit;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MagicNameList;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.TimestampedNameList;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditExtended;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class CreateOrEditDDI
extends DataDisplayInfo
implements GuiRequestor,
ObjectChangeListener {
    public static final int MAX_NAME_LENGTH = 32;
    private GeneralException exception;
    public CreateHeader oldCreateHeader;
    public CreateHeader newCreateHeader;
    public CreateOrEdit createOrEdit;
    public int ID;
    private boolean isNew;
    private Class editorClass;
    private String saveAsTitle;
    private boolean closing;
    public String objectType;
    public short nlInfo;
    public int nlID2;
    public int nlID3;
    public Object[] msgParm = new String[2];
    public int tabIndex;
    public int exceptionTabIndex;
    public boolean showEnabled;
    public String typeCode;
    public String subType;
    public short responseStatus;
    private boolean modified;
    private List objectChangeListeners;
    public NameList saveList;
    private JPanel mainPanel = null;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public static String getObjectTypeName(short objectType) {
        return ResourceTypeManager.getName(objectType);
    }

    public CreateOrEditDDI() {
        this(0, 0);
    }

    public CreateOrEditDDI(short resourceType, short qualifier) {
        this.nlID2 = resourceType;
        this.nlID3 = qualifier;
    }

    public void buildDescription(String creatorAndName) {
        this.msgParm[1] = creatorAndName;
        if (this.ID == 0) {
            super.setDescription(MessageLog.getMessageNoID("GUI5015L", this.msgParm));
        } else {
            super.setDescription(MessageLog.getMessageNoID("GUI5016L", this.msgParm));
        }
    }

    public static CreateOrEdit showEditor(Class editorClass, String creatorAndName, int ID2, short objectType) {
        return CreateOrEditDDI.showEditor(editorClass, creatorAndName, ID2, objectType, (short)0, (short)0, null);
    }

    public static CreateOrEdit showEditor(Class editorClass, String creatorAndName, int ID2, short objectType, BaseTreeNode treeNode) {
        return CreateOrEditDDI.showEditor(editorClass, creatorAndName, ID2, objectType, (short)0, (short)0, treeNode);
    }

    public static CreateOrEdit showEditor(Class editorClass, String creatorAndName, int ID2, short objectType, short resourceType, short qualifier, BaseTreeNode treeNode) {
        for (DataDisplayInfo ddi = DataDisplayInfo.getRoot(); ddi != null; ddi = ddi.getNext()) {
            if (!(ddi instanceof CreateOrEditDDI) || ((CreateOrEditDDI)ddi).ID != ID2) continue;
            CreateOrEditDDI editDDI = (CreateOrEditDDI)ddi;
            if (treeNode != null) {
                editDDI.treeNode = treeNode;
                treeNode.ddi = editDDI;
            }
            editDDI.reDisplay();
            return editDDI.createOrEdit;
        }
        CreateOrEditDDI editDDI = new CreateOrEditDDI(resourceType, qualifier);
        if (treeNode != null) {
            editDDI.treeNode = treeNode;
            treeNode.ddi = editDDI;
        }
        editDDI.buildEditor(editorClass, creatorAndName, ID2, objectType);
        return editDDI.createOrEdit;
    }

    public void buildEditor(Class editorClass, short pObjectType) {
        this.buildEditor(editorClass, null, 0, pObjectType);
    }

    public void buildEditor(Class editorCLass, short pObjectType, CreateHeader ch) {
        this.newCreateHeader = ch;
        this.buildEditor(editorCLass, null, 0, pObjectType);
    }

    public void buildEditor(Class editorClass, String creatorAndName, int ID2, short pObjectType) {
        this.editorClass = editorClass;
        this.ID = ID2;
        this.nlInfo = pObjectType;
        this.objectType = ResourceTypeManager.getName(pObjectType);
        this.msgParm[0] = this.objectType;
        this.buildDescription(creatorAndName);
        this.saveAsTitle = MessageLog.getMessageNoID("GUI5011L", this.msgParm);
        ChangeManager.addListener(this, pObjectType);
        this.reDisplay();
    }

    public void getDataAndValidate() {
        if (this.panel != null) {
            this.exception = null;
            this.newCreateHeader = this.createOrEdit.getData();
            if (this.oldCreateHeader == null) {
                this.modified = true;
            } else {
                boolean bl = this.modified = !this.newCreateHeader.equals(this.oldCreateHeader);
            }
            if (this.modified) {
                try {
                    this.createOrEdit.validate(this.newCreateHeader);
                }
                catch (GeneralException e) {
                    this.exception = e;
                }
            } else {
                if (this.newCreateHeader instanceof GroupDefinition) {
                    try {
                        this.createOrEdit.validate(this.newCreateHeader);
                    }
                    catch (GeneralException e) {
                        this.exception = e;
                    }
                }
                if (this.createOrEdit instanceof ReportCreateOrEdit) {
                    this.modified = ((ReportCreateOrEdit)this.createOrEdit).isChartCustPending();
                }
            }
        }
    }

    public void save(boolean saveAs) {
        this.getDataAndValidate();
        this.saveIt(saveAs);
    }

    public void saveAndClose() {
        this.closing = true;
        this.saveIt(false);
    }

    public static String promptForName(String title, String prompt) {
        String result;
        boolean going;
        IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
        do {
            boolean bl = going = (result = GuiUtil.displayOkCancelPane(title, prompt, 32, false, null, guiMain.getFrame())) != null && (result.indexOf(92) != -1 || result.indexOf(47) != -1 || result.indexOf(58) != -1 || result.indexOf(42) != -1 || result.indexOf(63) != -1 || result.indexOf(34) != -1 || result.indexOf(60) != -1 || result.indexOf(62) != -1 || result.indexOf(124) != -1);
            if (going) {
                String text = MessageLog.getMessageNoID("GUI5200E");
                JOptionPane.showMessageDialog(guiMain.getFrame(), text, "GUI5200E", 0);
                continue;
            }
            boolean bl2 = going = result != null && result.indexOf(46) >= 0;
            if (!going) continue;
            String s = MessageLog.getMessageNoTS("GUI0056E", null);
            GuiUtil.displayErrorMessage(s);
        } while (going);
        return result;
    }

    private void saveIt(boolean saveAs) {
        String saveAsName;
        CreateOrEditExtended cex;
        if (this.exception != null) {
            this.closing = false;
            GuiUtil.displayException(this.exception);
            this.exception = null;
            this.tabIndex = this.exceptionTabIndex;
            if (DataDisplayInfo.getCurrent() == this) {
                this.createOrEdit.showTab(this.tabIndex);
            } else {
                this.show();
            }
            return;
        }
        if (this.createOrEdit instanceof CreateOrEditExtended && !(cex = (CreateOrEditExtended)this.createOrEdit).saveConfirmed(this.newCreateHeader)) {
            if (DataDisplayInfo.getCurrent() == this) {
                this.createOrEdit.showTab(this.tabIndex);
            } else {
                this.show();
            }
            return;
        }
        if (this.createOrEdit instanceof ReportCreateOrEdit && ((ReportCreateOrEdit)this.createOrEdit).isChartCustPending()) {
            ((ReportCreateOrEdit)this.createOrEdit).saveChartCust(this.newCreateHeader.ID);
        }
        String nchName = this.newCreateHeader.getName();
        if (saveAs || nchName == null || nchName == "") {
            this.newCreateHeader.setName(CreateOrEditDDI.promptForName(MessageLog.getMessageNoID("GUI5007L"), this.saveAsTitle));
        }
        if ((saveAsName = this.newCreateHeader.getName()) != null && !saveAsName.equals("") && !saveAsName.equals(" ")) {
            this.newCreateHeader.lastModUser = GuiUtil.getUserName();
            if (saveAs) {
                this.newCreateHeader.ID = 0;
                this.newCreateHeader.creator = GuiUtil.getUserName();
            }
            this.isNew = this.newCreateHeader.ID == 0;
            Request request = new Request();
            request.typeCode = this.typeCode;
            request.subType = this.subType;
            request.requestData = this.newCreateHeader;
            GuiClient.doRequest(this, request);
        }
    }

    private Component listBadEggs(NameList bad) {
        JPanel result = new JPanel(new GridBagLayout());
        String s = MessageLog.getMessageNoID("GUI2014L");
        JLabel label = new JLabel(s);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 17;
        c.insets.bottom = 6;
        result.add((Component)label, c);
        c.insets.left = 20;
        c.insets.bottom = 0;
        while (bad != null) {
            ChangeManager.signalChange(-1, bad);
            if (bad.nlNext == null) {
                c.gridheight = 0;
            }
            if ((s = CreateOrEditDDI.getObjectTypeName(bad.nlInfo)) == null) {
                s = "?";
            }
            Object[] args = new Object[]{s, bad.nlName};
            s = MessageLog.getMessageNoID("GUI0049L", args);
            label = new JLabel(s);
            result.add((Component)label, c);
            bad = bad.nlNext;
        }
        return result;
    }

    public void handleResponse(short status, Response response) {
        boolean wasClosing = this.closing;
        this.closing = false;
        if (this.subType.equals("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr") && response.responseData instanceof ProbePing && status != 0) {
            int choice;
            ProbePing data = (ProbePing)response.responseData;
            if (data.validateIPs && (choice = JOptionPane.showConfirmDialog(this.guiMain.getFrame(), status == 4 ? MessageLog.getMessage("GUI8216W") : MessageLog.getMessage("GUI8217E"), MessageLog.getMessage("GUI0158T"), 0, 2)) == 0) {
                data.validateIPs = false;
                data.pbManualSlpDAs = ((MagicNameList)data.pbManualSlpDAs).unpack();
                Request request = new Request();
                request.typeCode = this.typeCode;
                request.subType = this.subType;
                request.requestData = data;
                GuiClient.doRequest(this, request);
                return;
            }
        }
        if (status > 4 && status != 76) {
            if (response.errorMessage.indexOf("SRV0096E") != -1) {
                this.newCreateHeader.setName(null);
            }
            return;
        }
        String qualifiedName = null;
        if (status <= 4) {
            Serializable data = response.responseData;
            this.newCreateHeader = (CreateHeader)data;
            this.oldCreateHeader = (CreateHeader)this.newCreateHeader.clone();
            this.ID = this.newCreateHeader.ID;
            qualifiedName = this.newCreateHeader.creator + "." + this.newCreateHeader.getName();
            this.buildDescription(qualifiedName);
        } else {
            Serializable[] responseData = (Serializable[])response.responseData;
            this.newCreateHeader = (CreateHeader)responseData[0];
            NameList bad = (NameList)responseData[1];
            Component comp = this.listBadEggs(bad);
            String s = MessageLog.getMessageNoID("GUI0228L");
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), comp, s, 1);
        }
        if (this.panel != null) {
            this.createOrEdit.replace(this.newCreateHeader);
        }
        if (status > 4) {
            return;
        }
        if (this.isNew) {
            this.isNew = false;
            NameList element = new NameList();
            element.nlInfo = this.nlInfo;
            element.nlName = qualifiedName;
            element.nlID = this.ID;
            element.nlID2 = this.nlID2;
            element.nlID3 = this.nlID3;
            ChangeManager.signalChange(1, element);
        }
        if (wasClosing) {
            this.remove();
        }
    }

    public void losingFocus() {
        this.createOrEdit.losingFocus();
    }

    private void removeListeners() {
        for (ObjectChangeListener listener : this.objectChangeListeners) {
            ChangeManager.removeListener(listener);
        }
    }

    public void panelToBeNulled() {
        this.getDataAndValidate();
        this.createOrEdit = null;
        if (this.objectChangeListeners != null) {
            this.removeListeners();
        }
        this.objectChangeListeners = null;
    }

    public void goingAway() {
        if (this.objectChangeListeners != null) {
            this.removeListeners();
        }
        ChangeManager.removeListener(this);
    }

    public boolean isEditable() {
        return true;
    }

    public boolean changesPending() {
        this.getDataAndValidate();
        return this.modified;
    }

    public void reDisplay() {
        if (this.panel != null) {
            this.show();
            this.createOrEdit.gettingFocus();
            this.createOrEdit.showTab(this.tabIndex);
        } else {
            try {
                Class[] argClasses = new Class[]{this.getClass()};
                Object[] args = new Object[]{this};
                Constructor constructor = this.editorClass.getConstructor(argClasses);
                this.createOrEdit = (CreateOrEdit)constructor.newInstance(args);
                if (this.newCreateHeader == null) {
                    this.createOrEdit.build(this.ID);
                } else {
                    this.createOrEdit.build(this.newCreateHeader);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addObjectChangeListener(ObjectChangeListener listener, short type) {
        if (this.objectChangeListeners == null) {
            this.objectChangeListeners = new LinkedList();
        }
        this.objectChangeListeners.add(listener);
        ChangeManager.addListener(listener, type);
    }

    public void changeOccurred(int changeType, NameList name) {
        if (changeType != 0) {
            return;
        }
        if (this.oldCreateHeader == null || this.oldCreateHeader.ID != name.nlID) {
            return;
        }
        String namePiece = name.nlName.substring(name.nlName.indexOf(46) + 1);
        TimestampedNameList timestamped = (TimestampedNameList)name;
        if (this.panel != null) {
            CreateHeaderPanel headerPanel = this.createOrEdit.getHeaderPanel();
            CreateHeader header = headerPanel.getData();
            header.lastModified = timestamped.tnlTimestamp;
            header.setName(namePiece);
            this.buildDescription(name.nlName);
            headerPanel.setFields();
            if (CreateOrEditDDI.getCurrent() == this) {
                this.show();
            }
        } else {
            this.newCreateHeader.lastModified = timestamped.tnlTimestamp;
            this.newCreateHeader.setName(namePiece);
            this.buildDescription(name.nlName);
        }
    }

    public String getHelpID() {
        String id = this.createOrEdit.getHelpID(this.tabIndex);
        if (id != null) {
            return id;
        }
        return "welcome_gettingstarted";
    }

    public void show() {
        if (this.treeNode != null && this.panel != this.mainPanel) {
            JPopupMenu popup = this.treeNode.getPopupMenuForButtons();
            this.mainPanel = new JPanel(new BorderLayout());
            JPanel buttonPanel = this.getButtonPanel(popup);
            if (this.getActionButtonCount() > 0) {
                this.mainPanel.add((Component)buttonPanel, "North");
            }
            this.mainPanel.add((Component)this.panel, "Center");
            this.panel = this.mainPanel;
        }
        super.show();
    }
}

