/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.aperi.xmsg.MessageLog;

public class DragEnabledTree
extends JTree
implements MouseListener,
MouseMotionListener,
KeyListener {
    private DropListener dropListener;
    private boolean inDrag;
    private Point offsetToMouse;
    private Rectangle dragSourceBounds;
    private static TreeSelectionModel dragSelectionModel = new DefaultTreeSelectionModel();
    private TreeSelectionModel savedSelectionModel;
    private Cursor savedCursor;
    private TreePath sourceParentPath;
    private TreePath dragSourcePath;
    private TreePath dragTargetPath;
    private int row;
    private JLayeredPane layeredPane;
    private JLabel dragSourceComponent;
    private Object dragSource;
    private Object dragTarget;
    private int cursorState;
    public static final int NORMAL_CURSOR = -1;
    public static final int DRAG_CURSOR = 0;
    public static final int MOVE = 1;
    public static final int COPY = 2;
    public static final int N_DRAG_CURSORS = 3;
    private static Cursor[] cursorArray;
    private static final String[] cursorPaths;
    private static final String[] cursorNames;

    private void ctorHelper(DropListener listener) {
        this.dropListener = listener;
        this.inDrag = false;
        this.dragSource = null;
        this.dragTarget = null;
        this.offsetToMouse = new Point(0, 0);
        this.dragSourceComponent = new JLabel();
        this.cursorState = -1;
        this.addMouseListener(this);
    }

    public DragEnabledTree(DropListener listener, TreeNode root) {
        super(root);
        this.ctorHelper(listener);
    }

    public DragEnabledTree(DropListener listener) {
        this.ctorHelper(listener);
    }

    public DragEnabledTree(DropListener listener, TreeModel model) {
        super(model);
        this.ctorHelper(listener);
    }

    private TreePath getPathForEvent(MouseEvent event, Point offset) {
        int x = event.getX();
        int y = event.getY();
        this.row = this.getRowForLocation(x, y);
        TreePath path = this.getPathForRow(this.row);
        if (path == null) {
            return null;
        }
        Rectangle rectangle = this.getPathBounds(path);
        if (rectangle == null) {
            return null;
        }
        if (!rectangle.contains(x, y)) {
            return null;
        }
        if (offset != null) {
            offset.setLocation(x - rectangle.x, y - rectangle.y);
            this.dragSourceBounds = rectangle;
        }
        return path;
    }

    public TreePath getPathForEvent(MouseEvent event) {
        return this.getPathForEvent(event, null);
    }

    private void setCursorState(int inputModifiers) {
        int both = 3;
        int masked = inputModifiers & both;
        int newCursorState = (inputModifiers & 1) != 0 ? ((inputModifiers & 2) != 0 ? 0 : 1) : ((inputModifiers & 2) != 0 ? 2 : 0);
        if (newCursorState != this.cursorState) {
            this.cursorState = newCursorState;
            this.setCursor(cursorArray[newCursorState]);
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if ((event.getModifiers() & 0x10) == 0) {
            return;
        }
        if (event.getClickCount() > 1) {
            return;
        }
        this.dragSourcePath = this.getPathForEvent(event, this.offsetToMouse);
        if (this.dragSourcePath == null) {
            return;
        }
        this.layeredPane = this.getRootPane().getLayeredPane();
        this.sourceParentPath = this.dragSourcePath.getParentPath();
        this.savedSelectionModel = this.getSelectionModel();
        this.setSelectionModel(dragSelectionModel);
        this.dragSource = this.dragSourcePath.getLastPathComponent();
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.dragSource;
        JLabel l = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, this.dragSource, false, false, !treeNode.getAllowsChildren(), this.row, false);
        this.dragSourceComponent.setText(l.getText());
        this.dragSourceComponent.setIcon(l.getIcon());
        this.dragSourceComponent.setHorizontalAlignment(l.getHorizontalAlignment());
        this.dragSourceComponent.setVerticalAlignment(l.getVerticalAlignment());
        this.dragSourceComponent.setFont(l.getFont());
        this.dragTarget = null;
        this.setSelectionPath(this.dragSourcePath);
        this.savedCursor = this.getCursor();
        this.cursorState = -1;
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.inDrag = true;
    }

    public void mouseReleased(MouseEvent event) {
        if ((event.getModifiers() & 0x10) == 0) {
            return;
        }
        boolean wasInDrag = this.inDrag;
        this.inDrag = false;
        if (!wasInDrag) {
            return;
        }
        this.removeMouseMotionListener(this);
        this.removeKeyListener(this);
        this.setCursor(this.savedCursor);
        this.setSelectionModel(this.savedSelectionModel);
        if (this.dragTarget != null) {
            if (this.cursorState != 1 && this.cursorState != 2) {
                String title = MessageLog.getMessageNoID("GUI0101T", null);
                String message = MessageLog.getMessageNoID("GUI0102M", null);
                String move = MessageLog.getMessageNoID("GUI0103L", null);
                String copy = MessageLog.getMessageNoID("GUI0104L", null);
                Object[] options = new Object[]{move, copy};
                int response = JOptionPane.showOptionDialog(this, message, title, 0, 3, null, options, options[0]);
                this.cursorState = response == 0 ? 1 : 2;
            }
            this.dropListener.dropped(this, this.dragSourcePath, this.dragTargetPath, this.cursorState);
        }
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void mouseDragged(MouseEvent event) {
        DefaultMutableTreeNode treeNode;
        this.setCursorState(event.getModifiers());
        int x = event.getX() - this.offsetToMouse.x;
        int y = event.getY() - this.offsetToMouse.y;
        Rectangle rectangle = new Rectangle(this.dragSourceBounds);
        this.dragSourceBounds.x = x;
        this.dragSourceBounds.y = y;
        this.dragSourceComponent.setBounds(this.dragSourceBounds);
        rectangle = rectangle.union(this.dragSourceBounds);
        this.repaint(rectangle);
        TreePath path = this.getPathForEvent(event);
        Object node = path != null ? path.getLastPathComponent() : null;
        if (this.dragTarget != null && node != this.dragTarget) {
            this.removeSelectionPath(this.dragTargetPath);
        }
        if (this.dragSourcePath.isDescendant(path)) {
            node = null;
        }
        if (node != null && !(treeNode = (DefaultMutableTreeNode)node).getAllowsChildren()) {
            node = null;
        }
        if (this.sourceParentPath != null && this.sourceParentPath.equals(path)) {
            node = null;
        }
        if (node == null) {
            this.dragTarget = null;
        }
        if (node == this.dragTarget) {
            return;
        }
        this.dragTargetPath = path;
        this.dragTarget = node;
        TreePath[] paths = new TreePath[]{path, this.dragSourcePath};
        this.setSelectionPaths(paths);
    }

    public void keyPressed(KeyEvent event) {
        int modifiers = event.getModifiers();
        int keyCode = event.getKeyCode();
        if (keyCode == 17) {
            modifiers |= 2;
        } else if (keyCode == 16) {
            modifiers |= 1;
        }
        this.setCursorState(modifiers);
    }

    public void keyReleased(KeyEvent event) {
        int modifiers = event.getModifiers();
        int keyCode = event.getKeyCode();
        if (keyCode == 17) {
            modifiers &= 0xFFFFFFFD;
        } else if (keyCode == 16) {
            modifiers &= 0xFFFFFFFE;
        }
        this.setCursorState(modifiers);
    }

    public void keyTyped(KeyEvent event) {
    }

    protected void paintComponent(Graphics gc) {
        super.paintComponent(gc);
        if (this.inDrag) {
            SwingUtilities.paintComponent(gc, this.dragSourceComponent, this.layeredPane, this.dragSourceBounds);
        }
    }

    static {
        cursorPaths = new String[]{"images/drag_crsr.gif", "images/move_crsr.gif", "images/copy_crsr.gif"};
        cursorNames = new String[]{"org.eclipse.aperi.drag", "org.eclipse.aperi.move", "org.eclipse.aperi.copy"};
        cursorArray = new Cursor[3];
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point hotSpot = new Point(7, 5);
        Class<DragEnabledTree> clazz = DragEnabledTree.class;
        for (int i = 0; i < 3; ++i) {
            URL imageURL = clazz.getResource(cursorPaths[i]);
            Image image = toolkit.getImage(imageURL);
            DragEnabledTree.cursorArray[i] = toolkit.createCustomCursor(image, hotSpot, cursorNames[i]);
        }
    }

    public static interface DropListener {
        public void dropped(DragEnabledTree var1, TreePath var2, TreePath var3, int var4);
    }
}

