/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.BadLocationException;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.ReportingFSGroupCreateOrEdit;
import org.eclipse.aperi.TStorm.gui.ReportingGroupCreateOrEdit;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.FilterPanel;
import org.eclipse.aperi.gui.FilterResultsTableModel;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class FilterResultsViewer
extends JDialog
implements GuiRequestor,
ActionListener,
DocumentListener,
TableModelListener {
    private Container cp;
    private JButton viewButton;
    private JButton cancelButton;
    private GridBagPanel tablePanel;
    private GridBagPanel panel;
    private MegaTable resourceTable;
    private boolean exceededMaxLength = false;
    private Object callerPanel;
    private JScrollPane tablePane;
    private Vector resColNames;
    private int selectedFilterIndex;
    private String selectedFilter;
    private short resourceType;
    private int updateEventOffset;
    private short type;
    private FilterResultsTableModel model;
    private NameList[] newRes;
    private JButton selectAllButton;
    private JButton clearAllButton;
    private JTextArea pickTextArea;
    protected JTextField filterField;
    public static short ADD = 1;
    public static short EDIT = (short)2;
    public static short PICK = (short)3;
    public JButton okButton;
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public FilterResultsViewer(Frame myFrame, short inType, Object callingPanel, int index, Object filter, short resType, String title) {
        super(myFrame, title, true);
        this.callerPanel = callingPanel;
        this.type = inType;
        this.resourceType = resType;
        this.selectedFilterIndex = index;
        this.selectedFilter = (String)filter;
        this.cp = this.getContentPane();
        this.configureHelp();
        this.panel = this.getMainPanel();
        this.cp.add(this.panel);
        this.pack();
    }

    public void displayDialog() {
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.viewButton) {
            this.tablePanel.removeAll();
            this.submitRetrieve();
        } else if (source == this.okButton) {
            boolean ok = false;
            if (this.type == ADD) {
                ok = ((FilterPanel)this.callerPanel).addFilter(this.filterField.getText());
            } else if (this.type == EDIT) {
                ok = ((FilterPanel)this.callerPanel).updateFilter(this.filterField.getText());
            } else if (this.type == PICK) {
                this.newRes = this.model.getData();
                if (this.newRes != null) {
                    ok = true;
                    UpdateSelectedResourcesEvent usre = new UpdateSelectedResourcesEvent();
                    EventQueue queue = new EventQueue();
                    queue.postEvent(usre);
                }
            }
            if (!ok) {
                this.okButton.setEnabled(false);
                return;
            }
            this.dispose();
        } else if (source == this.selectAllButton) {
            this.model.selectAll(true);
        } else if (source == this.clearAllButton) {
            this.model.selectAll(false);
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    private GridBagPanel getMainPanel() {
        this.panel = new GridBagPanel();
        this.okButton = new JButton(Util.getString("LABEL_OK"));
        this.okButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_OK"));
        this.getRootPane().setDefaultButton(this.okButton);
        this.viewButton = new JButton(Util.getString("LABEL_VIEW"));
        this.viewButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_VIEW"));
        this.cancelButton = new JButton(Util.getString("LABEL_CANCEL"));
        this.cancelButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_CANCEL"));
        this.filterField = new JTextField(30);
        this.tablePanel = new GridBagPanel();
        JTextArea ta = new JTextArea(Util.getString("DESC_FILTER_INSTRUCTIONS"));
        ta.setBackground(this.getBackground());
        ta.setEditable(false);
        this.panel.add((JComponent)ta, 2, 1, 2);
        this.panel.newRow();
        this.panel.add((JComponent)new JLabel(Util.getString("LABEL_FILTER_PATTERN")), 1, 1, 2);
        this.panel.newRow();
        if (this.selectedFilter != null) {
            this.filterField.setText(this.selectedFilter);
        }
        this.panel.add((JComponent)this.filterField, 21, 2);
        this.panel.add((JComponent)this.viewButton, 22, 0);
        if (this.type == ADD || this.type == PICK) {
            this.viewButton.setEnabled(false);
        }
        this.panel.newRow();
        this.panel.add(this.tablePanel, 2, 1, 1, new Insets(4, 0, 4, 0));
        this.panel.newRow();
        this.panel.add((JComponent)this.okButton, 22, 0, new Insets(4, 0, 4, 4));
        this.okButton.setEnabled(false);
        this.panel.add((JComponent)this.cancelButton, 22, 0, new Insets(4, 0, 4, 4));
        this.viewButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.filterField.getDocument().addDocumentListener(this);
        if (this.type == PICK) {
            this.selectAllButton = new JButton(Util.getString("GUI0137L"));
            this.clearAllButton = new JButton(Util.getString("GUI0061L"));
            this.selectAllButton.addActionListener(this);
            this.clearAllButton.addActionListener(this);
            this.pickTextArea = new JTextArea(Util.getString("DESC_FILTER_PICK_INSTRUCTIONS"));
            this.pickTextArea.setBackground(this.getBackground());
            this.pickTextArea.setEditable(false);
        }
        return this.panel;
    }

    private void submitRetrieve() {
        GuiListReq requestData = new GuiListReq();
        requestData.listRequested = 11;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", requestData);
        request.flags = (byte)4;
        NameList element = new NameList();
        element.nlName = this.filterField.getText();
        if (this.resourceType == 90) {
            element.nlInfo = (short)96;
        } else if (this.resourceType == 89) {
            element.nlInfo = (short)95;
        }
        element.nlNext = null;
        requestData.qualifierObject = element;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        NameList nameList = (NameList)response.responseData;
        if (nameList == null) {
            this.tablePanel.add(ReportingDDI.getNoDataMessage(null));
        } else {
            Dimension dim;
            Vector<NameList> resVec = new Vector<NameList>();
            NameList[] resArray = null;
            NameList nextNl = null;
            NameList[][] resourceArray = null;
            while (nameList != null) {
                nextNl = (NameList)nameList.clone();
                if (nextNl.nlInfo == 96) {
                    String computerName = GuiUtil.getComputer((int)nextNl.nlID2).gcTSName;
                    nextNl.nlName = computerName = nextNl.nlName + "(" + computerName + ")";
                }
                nextNl.nlNext = null;
                resVec.add(nextNl);
                nameList = nameList.nlNext;
            }
            resVec.trimToSize();
            resArray = new NameList[resVec.size()];
            for (int i = 0; i < resVec.size(); ++i) {
                resArray[i] = (NameList)resVec.get(i);
            }
            this.model = new FilterResultsTableModel(resArray, this.type, Util.getString("LABEL_FILTER_RESULTS_TABLE", new String[]{this.filterField.getText()}));
            JTable resTable = new JTable(this.model);
            if (this.type == PICK) {
                resTable.getColumnModel().getColumn(0).setPreferredWidth(1);
                resTable.getColumnModel().getColumn(1).setPreferredWidth(400);
                resTable.getColumnModel().setColumnMargin(1);
                this.model.addTableModelListener(this);
                this.okButton.setEnabled(true);
                resTable.setRowSelectionAllowed(true);
                resTable.getSelectionModel().setSelectionMode(0);
            } else {
                resTable.setRowSelectionAllowed(false);
            }
            resTable.setColumnSelectionAllowed(false);
            JScrollPane jsp = new JScrollPane(resTable);
            int w = this.panel.getWidth();
            if (resTable.getModel().getRowCount() > 15) {
                dim = new Dimension(0, 17 * (w / 30));
            } else {
                int rows = resTable.getRowCount();
                int h = resTable.getRowHeight();
                dim = new Dimension(0, (rows + 1) * h + 2);
            }
            jsp.setPreferredSize(dim);
            int row = 0;
            if (this.type == PICK) {
                this.tablePanel.add(this.pickTextArea, 0, 0, 2, 1, 21, 0, new Insets(4, 11, 4, 4));
                this.tablePanel.add(this.selectAllButton, 1, 0, 1, 1, 21, 0, new Insets(4, 11, 4, 4));
                this.tablePanel.add(this.clearAllButton, 1, 1, 1, 1, 21, 0, new Insets(4, 4, 4, 4));
                row = 2;
            }
            this.tablePanel.add(jsp, row, 0, 2, 1, 21, 1, new Insets(6, 11, 4, 7));
        }
        this.viewButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        int length = this.filterField.getText().length();
        this.setButtons(length > 0);
        if (length > 128) {
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI6019T"), "", 0);
            this.exceededMaxLength = true;
            UpdateTextEvent ute = new UpdateTextEvent();
            this.updateEventOffset = e.getOffset();
            EventQueue queue = new EventQueue();
            queue.postEvent(ute);
        }
    }

    public void removeUpdate(DocumentEvent e) {
        this.setButtons(this.filterField.getText().length() > 0);
    }

    public void setButtons(boolean setting) {
        this.viewButton.setEnabled(setting);
        if (this.type != PICK) {
            this.okButton.setEnabled(setting);
        }
        this.getRootPane().setDefaultButton(this.viewButton);
    }

    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            int selected = 0;
            for (int rows = this.model.getRowCount(); rows > 0; --rows) {
                if (!((Boolean)this.model.getValueAt(rows - 1, 0)).booleanValue()) continue;
                ++selected;
            }
            if (selected == 0) {
                this.okButton.setEnabled(false);
            } else {
                this.okButton.setEnabled(true);
            }
        }
    }

    private void configureHelp() {
        String helpID = "";
        if (this.resourceType == 89 || this.resourceType == 90) {
            if (this.type == ADD || this.type == EDIT) {
                helpID = "repgrp15";
            } else if (this.type == PICK) {
                helpID = "repgrp20";
            }
        }
        Help.setHelpID(this.getRootPane(), helpID);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
    }

    private class UpdateSelectedResourcesEvent
    extends AWTEvent
    implements ActiveEvent {
        public UpdateSelectedResourcesEvent() {
            super(new Object(), 2000);
        }

        public void dispatch() {
            if (FilterResultsViewer.this.callerPanel instanceof ReportingGroupCreateOrEdit) {
                ((ReportingGroupCreateOrEdit)FilterResultsViewer.this.callerPanel).addSelectedResources(FilterResultsViewer.this.newRes);
            } else if (FilterResultsViewer.this.callerPanel instanceof ReportingFSGroupCreateOrEdit) {
                ((ReportingFSGroupCreateOrEdit)FilterResultsViewer.this.callerPanel).addSelectedResources(FilterResultsViewer.this.newRes);
            }
        }
    }

    private class UpdateTextEvent
    extends AWTEvent
    implements ActiveEvent {
        public UpdateTextEvent() {
            super(new Object(), 2000);
        }

        public void dispatch() {
            try {
                FilterResultsViewer.this.filterField.getDocument().remove(FilterResultsViewer.this.updateEventOffset, 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

