/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.net.Socket;
import org.eclipse.aperi.TStorm.server.guireq.DeviceJobStatusRequest;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiDeviceJob {
    public static Response getJobStatus(int jobID, boolean waitForComplete) {
        return GuiDeviceJob.getJobStatus(jobID, waitForComplete, 5);
    }

    public static Response getJobStatus(int jobID, boolean waitForComplete, int waitMinutes) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
        request.subType = "org.eclipse.aperi.server.handler.scheduler.SchDeviceJobStatusHandler";
        request.serviceName = RequestTypeManager.getInternalName("org.eclipse.aperi.server.svp.SchedulerSvp");
        request.userName = GuiUtil.getUserName();
        request.flags = (byte)4;
        DeviceJobStatusRequest djsr = new DeviceJobStatusRequest();
        djsr.deviceRunID = jobID;
        djsr.scheduleID = 113;
        djsr.waitForComplete = waitForComplete;
        request.requestData = djsr;
        return GuiDeviceJob.doRequest(request, waitMinutes);
    }

    private static Response doRequest(Request request, int waitMinutes) {
        String errorMessage;
        int status;
        Response response = null;
        request.userName = GuiUtil.getUserName();
        try {
            Socket socket = new Socket(GuiClient.server, GuiClient.port);
            SocketTransceiver t = new SocketTransceiver(socket, GuiClient.server, waitMinutes * 60);
            response = t.transmitRequest(request, null);
            t.close();
            if (response == null) {
                status = 12;
                errorMessage = MessageLog.getMessage("GUI0022M", null);
            } else {
                status = response.status;
                errorMessage = response.errorMessage;
            }
        }
        catch (Exception e) {
            status = 12;
            errorMessage = MessageLog.getMessage("GUI0023M", null);
        }
        if (status != 0) {
            GuiClient.serverError((short)status, errorMessage);
            response = null;
        }
        return response;
    }
}

