/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Rename;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiRename
implements GuiRequestor {
    private Rename obj;
    private String description;

    public GuiRename(NameList element, String pDescription) {
        this.description = pDescription;
        this.obj = new Rename();
        this.obj.rnID = element.nlID;
        this.obj.rnObjectType = element.nlInfo;
        int pos = element.nlName.indexOf(46);
        this.obj.rnCreator = pos > 0 ? element.nlName.substring(0, pos) : " ";
        this.obj.rnOldName = element.nlName.substring(pos + 1);
        this.obj.rnModifyingUser = GuiUtil.getUserName();
    }

    public void rename() {
        Object[] args = new Object[]{this.description};
        String title = MessageLog.getMessageNoID("GUI0054L", args);
        String prompt = Util.getString("RENAME_PROMPT", this.description);
        this.obj.rnNewName = CreateOrEditDDI.promptForName(title, prompt);
        if (this.obj.rnNewName == null) {
            return;
        }
        Request request = new Request();
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.RenameHndlr";
        request.userName = this.obj.rnModifyingUser;
        request.flags = (byte)5;
        request.requestData = this.obj;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        NameList result = (NameList)response.responseData;
        result.nlInfo = this.obj.rnObjectType;
        ChangeManager.signalChange(0, result);
    }
}

