/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.LogViewer;

public class LogViewerDDI
extends DataDisplayInfo {
    protected String title;
    protected String name;
    protected int computerID;
    protected String serviceID;
    protected int logType;
    protected static int AGENT = 1;
    protected static int AGENT_JOB = 2;
    protected static int SERVICE = 3;
    public static int AGENT_INBAND = 4;
    protected static int DEVICE_JOB = 5;

    public LogViewerDDI() {
        this.displayInScrollPane = false;
    }

    public void reDisplay() {
        if (this.panel == null) {
            this.panel = new LogViewer(this);
        }
        this.show();
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        this.pf = pageFormat;
        int fontHeight = g.getFontMetrics().getHeight();
        int pageHeight = (int)this.pf.getImageableHeight();
        int pageWidth = (int)this.pf.getImageableWidth();
        int lineHeight = fontHeight;
        int fullPageHeight = pageHeight - 6;
        fullPageHeight -= fullPageHeight % lineHeight;
        int fullLogHeight = ((LogViewer)this.panel).scrollPane.getVerticalScrollBar().getMaximum();
        if (pageIndex > fullLogHeight / fullPageHeight) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(this.pf.getImageableX(), this.pf.getImageableY());
        int off = pageIndex * fullPageHeight;
        int diff = fullLogHeight - off;
        int clipHeight = Math.min(fullPageHeight, fullLogHeight - pageIndex * fullPageHeight);
        g2.translate(0, -fullPageHeight * pageIndex);
        g2.setClip(0, fullPageHeight * pageIndex + 6, pageWidth, clipHeight);
        ((LogViewer)this.panel).textPane.paint(g2);
        return 0;
    }
}

