/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.TStorm.common.FsNameList;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.TreeSelectorNode;

public class NameListTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static NameList object = null;
    public static Color darkerGreen = Color.green.darker();

    public static Icon iconForObject(NameList name) {
        object = name;
        return NameListTreeCellRenderer.iconForType(name.nlInfo);
    }

    public static Icon iconForType(short resourceType) {
        ImageIcon result = null;
        switch (resourceType) {
            case 99: {
                result = IconFactory.getClusterIcon();
                break;
            }
            case 1: {
                if (object != null && Constants.isVirtualServer(NameListTreeCellRenderer.object.nlID2)) {
                    result = IconFactory.getVirtualServerIcon();
                    break;
                }
                result = IconFactory.getComputerIcon();
                break;
            }
            case 3: {
                result = IconFactory.getFilesystemIcon();
                break;
            }
            case 17: {
                break;
            }
            case 16: {
                break;
            }
            case 86: {
                result = IconFactory.getStateRunningIcon();
                break;
            }
            case 84: {
                result = IconFactory.getStateSuccessIcon();
                break;
            }
            case 85: {
                result = IconFactory.getStateWarningIcon();
                break;
            }
            case 87: {
                result = IconFactory.getStateFailedIcon();
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        TreeSelectorNode treeNode = (TreeSelectorNode)value;
        NameList name = (NameList)treeNode.getUserObject();
        Icon icon = NameListTreeCellRenderer.iconForObject(name);
        if (name instanceof FsNameList) {
            if (((FsNameList)name).fsWillBeExtended) {
                icon = IconFactory.getExtendableFsIcon();
            }
            if (((FsNameList)name).fsGovernorLimited) {
                icon = IconFactory.getGovernorLimitedFsIcon();
            }
        }
        this.setIcon(icon);
        this.setDisabledIcon(icon);
        Font font = name.nlInfo < 0 ? BaseTree.boldFont : BaseTree.plainFont;
        this.setFont(font);
        return this;
    }
}

