/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Calendar;
import javax.imageio.ImageIO;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.PrintManager;
import org.eclipse.aperi.gui.PrintPreviewable;
import org.eclipse.aperi.gui.PrintTableData;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiChartAdapter;

public class PrintComponent {
    public static void print(PrintOptions options, Component thing, String creator, String title, String fileMask, boolean partialLandscape) {
        if (options != null) {
            options.creator = creator;
            options.title = title;
            options.fileMask = fileMask;
            if (options.fileName == null && (options.outputType == 2 || options.outputType == 3 || options.outputType == 4 || options.outputType == 7 || options.outputType == 8 || options.outputType == 5)) {
                options.fileName = PrintTableData.getFileName(options);
                if (options.fileName == null) {
                    return;
                }
            }
            if (partialLandscape) {
                options.partialLandscape = true;
            }
            if (options.htmlChart != null && options.outputType == 3) {
                PrintComponent.printHTMLChart(options);
                return;
            }
            PrintManager.getPrinter(options);
            if (options.printer != null) {
                if (options.title != null) {
                    // empty if block
                }
                if (options.creator == null || options.outputType != 1 || options.orientation != 2) {
                    // empty if block
                }
                if (options.outputType != 3) {
                    // empty if block
                }
                PrintManager.printDocument(options);
            }
        }
    }

    private static void printHTMLChart(PrintOptions options) {
        options.outFile = null;
        OutputStreamWriter osw = null;
        PrintWriter writer = null;
        AperiChartAdapter chart = null;
        AperiChart container = options.htmlChart;
        Component[] outputStuff = container.getComponents();
        for (int i = 0; i < outputStuff.length; ++i) {
            if (!(outputStuff[i] instanceof AperiChartAdapter)) continue;
            chart = (AperiChartAdapter)outputStuff[i];
        }
        if (chart != null) {
            try {
                options.outFile = new FileOutputStream(options.fileName);
            }
            catch (IOException e) {
                GuiUtil.displayErrorMessage(e.getMessage());
                options.outFile = null;
            }
            int imgHeight = chart.getHeight();
            int imgWidth = chart.getWidth();
            if (imgHeight <= 0 || imgWidth <= 0) {
                imgHeight = options.defaultHeight;
                imgWidth = options.defaultWidth;
                chart.setSize(imgWidth, imgHeight);
            }
            BufferedImage img = new BufferedImage(imgWidth, imgHeight, 1);
            chart.paint(img.createGraphics());
            int stop = options.fileName.lastIndexOf(File.separatorChar);
            String path = options.fileName.substring(0, stop + 1);
            String imgFileName = "img" + System.currentTimeMillis() + ".png";
            try {
                FileOutputStream fos = new FileOutputStream(path + imgFileName);
                if (!ImageIO.write((RenderedImage)img, "png", fos)) {
                    System.out.println("PrintComponent.printHTMLChart: Failed to create PNG image file.");
                }
                fos.flush();
                fos.close();
            }
            catch (IOException e) {
                GuiUtil.displayErrorMessage(e.getMessage());
            }
            if (options.outFile != null) {
                try {
                    osw = new OutputStreamWriter((OutputStream)options.outFile, "UTF-8");
                    writer = new PrintWriter((Writer)osw, true);
                }
                catch (Exception e1) {
                    GuiUtil.displayErrorMessage(e1.getMessage());
                }
            }
            if (writer != null) {
                writer.println("<html>");
                writer.println("<head>");
                writer.print("<title>");
                writer.print(options.title);
                writer.println("</title>");
                writer.println(" ");
                writer.print("<meta http-equiv=\"Content-Type\" ");
                writer.println("content=\"text/html; charset=UTF-8\" />");
                writer.println("<style type=\"text/css\">");
                writer.println("   .title   { color: #000066  }");
                writer.println("   table.report { background-color: #FFFFFF   }");
                writer.println("   tr.header { background-color: #6666FF  }");
                writer.println("   tr.totals { background-color: #FFFF99 }");
                writer.println("   tr.gray   { background-color: #CCCCFF   }");
                writer.println("</style>");
                writer.println(" ");
                writer.println("</head>");
                writer.println("<body>");
                writer.println(" ");
                writer.print("<h2 class=\"title\">");
                writer.print(options.title);
                writer.println("</h2>");
                writer.println(" ");
                writer.print("<h4 class=\"title\">");
                writer.print(PrintPreviewable.CREATED_BY);
                writer.print(" ");
                writer.print(options.creator);
                writer.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                writer.print(PrintPreviewable.PRINTED_ON);
                writer.print(" ");
                writer.print(DateFormat.getDateTimeInstance(2, 2).format(Calendar.getInstance().getTime()));
                writer.println("</h4>");
                writer.println(" ");
                writer.println("<br>");
                writer.println("<br>");
                writer.println("<p align=\"center\">");
                writer.print("<img src=\"");
                writer.print(imgFileName);
                writer.print("\" width=\"" + imgWidth);
                writer.print("\" height=\"" + imgHeight);
                writer.println("\" alt=\"" + options.title + "\">");
                writer.println("</p>");
                writer.println(" ");
                writer.println("</body>");
                writer.println("</html>");
                writer.close();
            }
        }
    }
}

