/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class Selector
extends JPanel
implements ActionListener {
    private boolean groupByCluster = false;
    protected JButton addButton;
    protected JButton delButton;
    protected JPanel leftPane;
    protected JPanel rightPane;
    protected JPanel middlePane;
    protected JLabel leftTitle;
    protected JLabel rightTitle;
    protected JCheckBox groupByClusterButton;
    protected JButton upButton;
    protected JButton downButton;
    protected JPanel upDownPane;
    protected JList sourceJList;
    protected JList selectedJList;

    public Selector(ArrayList sourceList, ArrayList selectedList, boolean groupByCluster, boolean upDownButtons) {
        this.sourceJList = this.list2JList(sourceList);
        this.selectedJList = this.list2JList(selectedList);
        this.layoutUpDownPanel(this.sourceJList, this.selectedJList, groupByCluster, upDownButtons);
    }

    public Selector(JComponent sourceComponent, JComponent selectedComponent, boolean groupByCluster, boolean upDownButtons) {
        this.layoutUpDownPanel(sourceComponent, selectedComponent, groupByCluster, upDownButtons);
    }

    public Selector(JComponent sourceComponent, JComponent selectedComponent, boolean groupByCluster) {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        if (groupByCluster) {
            gbc.insets.left = 3;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.gridwidth = 0;
            this.groupByClusterButton = new JCheckBox(Util.getString("LABEL_GROUP_BY_CLUSTER"));
            this.add((Component)this.groupByClusterButton, gbc);
        }
        this.addButton = new JButton(">>");
        Font boldFont = this.addButton.getFont().deriveFont(1);
        this.addButton.setFont(boldFont);
        this.delButton = new JButton("<<");
        this.delButton.setFont(boldFont);
        this.leftTitle = new JLabel(MessageLog.getMessageNoID("STG4029L"));
        this.leftTitle.setFont(boldFont);
        this.rightTitle = new JLabel(MessageLog.getMessageNoID("STG4030L"));
        this.rightTitle.setFont(boldFont);
        this.leftTitle.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_PROBE_TREE_AVAILABLE"));
        this.leftTitle.setLabelFor(sourceComponent);
        this.rightTitle.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_PROBE_TREE_SELECTED"));
        this.rightTitle.setLabelFor(selectedComponent);
        this.leftPane = this.getLeftPane(sourceComponent, this.leftTitle);
        this.rightPane = this.getRightPane(selectedComponent, this.rightTitle);
        this.middlePane = new JPanel(new GridBagLayout());
        GuiUtil.setAccessible(this.leftTitle, MessageLog.getMessageNoID("STG4029L"), MessageLog.getMessageNoID("STG4029L"));
        GuiUtil.setAccessible(this.rightTitle, MessageLog.getMessageNoID("STG4030L"), MessageLog.getMessageNoID("STG4030L"));
        gbc.gridwidth = 0;
        gbc.anchor = 15;
        gbc.insets.bottom = 10;
        this.middlePane.add((Component)this.addButton, gbc);
        gbc.gridheight = 0;
        gbc.anchor = 11;
        gbc.insets.bottom = 0;
        gbc.insets.top = 10;
        this.middlePane.add((Component)this.delButton, gbc);
        gbc.gridwidth = 1;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 0.5;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.leftPane, gbc);
        gbc.fill = 3;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add((Component)this.middlePane, gbc);
        gbc.fill = 1;
        gbc.weightx = 0.5;
        gbc.gridwidth = 0;
        this.add((Component)this.rightPane, gbc);
        this.addButton.setEnabled(false);
        this.delButton.setEnabled(false);
        this.addButton.addActionListener(this);
        this.delButton.addActionListener(this);
    }

    protected JPanel getLeftPane(JComponent component, JLabel title) {
        return this.getPane(component, title);
    }

    protected JPanel getRightPane(JComponent component, JLabel title) {
        return this.getPane(component, title);
    }

    private JPanel getPane(JComponent component, JLabel title) {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(component);
        scrollPane.setPreferredSize(new Dimension(225, 380));
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        pane.add((Component)title, "North");
        pane.add((Component)scrollPane, "Center");
        return pane;
    }

    private void layoutUpDownPanel(JComponent sourceComponent, JComponent selectedComponent, boolean groupByCluster, boolean upDownButtons) {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        if (groupByCluster) {
            gbc.insets.left = 3;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.gridwidth = 0;
            this.groupByClusterButton = new JCheckBox(Util.getString("LABEL_GROUP_BY_CLUSTER"));
            this.add((Component)this.groupByClusterButton, gbc);
        }
        this.addButton = new JButton(">>");
        Font boldFont = this.addButton.getFont().deriveFont(1);
        this.addButton.setFont(boldFont);
        this.delButton = new JButton("<<");
        this.delButton.setFont(boldFont);
        this.leftTitle = new JLabel(MessageLog.getMessageNoID("STG4029L"));
        this.leftTitle.setFont(boldFont);
        this.rightTitle = new JLabel(MessageLog.getMessageNoID("STG4030L"));
        this.rightTitle.setFont(boldFont);
        this.leftTitle.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_PROBE_TREE_AVAILABLE"));
        this.leftTitle.setLabelFor(sourceComponent);
        this.rightTitle.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_PROBE_TREE_SELECTED"));
        this.rightTitle.setLabelFor(selectedComponent);
        this.leftPane = this.getLeftPane(sourceComponent, this.leftTitle);
        this.rightPane = this.getRightPane(selectedComponent, this.rightTitle);
        this.middlePane = new JPanel(new GridBagLayout());
        GuiUtil.setAccessible(this.leftTitle, MessageLog.getMessageNoID("STG4029L"), MessageLog.getMessageNoID("STG4029L"));
        GuiUtil.setAccessible(this.rightTitle, MessageLog.getMessageNoID("STG4030L"), MessageLog.getMessageNoID("STG4030L"));
        gbc.gridwidth = 0;
        gbc.anchor = 15;
        gbc.insets.bottom = 10;
        this.middlePane.add((Component)this.addButton, gbc);
        gbc.gridheight = 0;
        gbc.anchor = 11;
        gbc.insets.bottom = 0;
        gbc.insets.top = 10;
        this.middlePane.add((Component)this.delButton, gbc);
        gbc.gridwidth = 1;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 0.5;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.leftPane, gbc);
        gbc.fill = 3;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add((Component)this.middlePane, gbc);
        gbc.fill = 1;
        gbc.weightx = 0.5;
        gbc.gridwidth = upDownButtons ? 1 : 0;
        this.add((Component)this.rightPane, gbc);
        this.addButton.setEnabled(false);
        this.delButton.setEnabled(false);
        this.addButton.addActionListener(this);
        this.delButton.addActionListener(this);
        if (upDownButtons) {
            this.upDownPane = new JPanel(new GridBagLayout());
            ImageIcon icon = IconFactory.getUpIcon();
            this.upButton = new JButton(icon);
            this.upButton.setFont(boldFont);
            icon = IconFactory.getDownIcon();
            this.downButton = new JButton(icon);
            this.downButton.setFont(boldFont);
            GridBagConstraints gbc2 = new GridBagConstraints();
            gbc2.fill = 2;
            gbc2.gridwidth = 0;
            gbc2.anchor = 17;
            gbc2.insets = new Insets(0, 0, 20, 0);
            this.upDownPane.add((Component)this.upButton, gbc2);
            gbc2.anchor = 17;
            gbc2.insets = new Insets(0, 0, 0, 0);
            this.upDownPane.add((Component)this.downButton, gbc2);
            gbc2.gridwidth = 0;
            gbc2.anchor = 10;
            gbc2.insets = new Insets(4, 4, 4, 4);
            gbc2.fill = 3;
            gbc2.weighty = 0.0;
            gbc2.weightx = 0.0;
            this.add((Component)this.upDownPane, gbc2);
            this.upButton.addActionListener(this);
            this.downButton.addActionListener(this);
        }
    }

    public abstract void actionPerformed(ActionEvent var1);

    public void setGroupByClusterButtonActionListener(ActionListener al) {
        this.groupByClusterButton.addActionListener(al);
    }

    public JList list2JList(ArrayList inList) {
        DefaultListModel listModel = new DefaultListModel();
        for (int i = 0; i < inList.size(); ++i) {
            listModel.addElement(inList.get(i));
        }
        return new JList(listModel);
    }
}

