/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Selector;

public class TUpDownListSelector
extends Selector
implements ActionListener,
ListSelectionListener {
    protected JList srcList;
    protected JList selList;
    protected String srcTitle;
    protected String selTitle;
    protected boolean upDown;

    public TUpDownListSelector(JList sourceList, JList selectedList, String srcTitle, String selTitle, boolean upDown) {
        super(sourceList, selectedList, false, upDown);
        this.upDown = upDown;
        this.srcList = sourceList;
        this.selList = selectedList;
        this.srcList.addListSelectionListener(this);
        this.selList.addListSelectionListener(this);
        this.srcTitle = srcTitle;
        this.selTitle = selTitle;
        this.leftTitle.setText(this.srcTitle);
        this.rightTitle.setText(this.selTitle);
        GuiUtil.setAccessible(this.leftTitle, this.leftTitle.getText(), this.leftTitle.getText());
        GuiUtil.setAccessible(this.rightTitle, this.rightTitle.getText(), this.rightTitle.getText());
    }

    public TUpDownListSelector(ArrayList sourceList, ArrayList selectedList, String srcTitle, String selTitle, boolean upDown) {
        super(sourceList, selectedList, false, upDown);
        this.upDown = upDown;
        this.srcList = this.sourceJList;
        this.selList = this.selectedJList;
        this.srcList.addListSelectionListener(this);
        this.selList.addListSelectionListener(this);
        this.srcTitle = srcTitle;
        this.selTitle = selTitle;
        this.leftTitle.setText(this.srcTitle);
        this.rightTitle.setText(this.selTitle);
    }

    public void setEnabled(boolean state) {
        if (!state) {
            this.srcList.clearSelection();
            this.selList.clearSelection();
        }
        this.srcList.setEnabled(state);
        this.srcList.setEnabled(state);
        this.setEnabledPane(this.rightPane, state);
        this.setEnabledPane(this.leftPane, state);
        this.setEnabledPane(this.middlePane, state);
        if (this.upDown) {
            this.setEnabledPane(this.upDownPane, state);
        }
    }

    private void setEnabledPane(JPanel pane, boolean state) {
        Component[] compArray = pane.getComponents();
        for (int i = 0; i < compArray.length; ++i) {
            compArray[i].setEnabled(state);
        }
    }

    public ArrayList getSelList() {
        return this.getTheList(this.selList);
    }

    public ArrayList getSrcList() {
        return this.getTheList(this.srcList);
    }

    private ArrayList getTheList(JList list) {
        ArrayList theList = null;
        DefaultListModel model = (DefaultListModel)list.getModel();
        if (model.getSize() != 0) {
            theList = new ArrayList(model.getSize());
            for (int i = 0; i < model.getSize(); ++i) {
                Object item = model.getElementAt(i);
                theList.add(item);
            }
        }
        return theList;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton button = (JButton)e.getSource();
            if (button == this.addButton) {
                this.addPressed();
                this.addButton.setEnabled(false);
                this.srcList.clearSelection();
                this.srcList.requestFocus();
            } else if (button == this.delButton) {
                this.removePressed();
                this.delButton.setEnabled(false);
                this.selList.clearSelection();
                this.selList.requestFocus();
            } else if (button == this.upButton) {
                this.upPressed();
            } else if (button == this.downButton) {
                this.downPressed();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        JList changedList = (JList)event.getSource();
        boolean hasSourceSelections = this.srcList.getSelectedIndices().length != 0;
        boolean hasDestinationSelections = this.selList.getSelectedIndices().length != 0;
        this.addButton.setEnabled(hasSourceSelections);
        this.delButton.setEnabled(hasDestinationSelections);
        if (changedList == this.srcList) {
            if (this.upDown) {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
            if (hasDestinationSelections && hasSourceSelections) {
                this.selList.clearSelection();
            }
        } else {
            if (this.upDown) {
                ListSelectionModel selModel = this.selList.getSelectionModel();
                boolean firstSelected = false;
                boolean lastSelected = false;
                boolean anySelected = !selModel.isSelectionEmpty();
                boolean numInList = false;
                if (anySelected) {
                    if (selModel.isSelectedIndex(0)) {
                        firstSelected = true;
                    }
                    if (selModel.isSelectedIndex(this.selList.getModel().getSize() - 1)) {
                        lastSelected = true;
                    }
                }
                this.upButton.setEnabled(anySelected && !firstSelected);
                this.downButton.setEnabled(anySelected && !lastSelected);
            }
            if (hasDestinationSelections && hasSourceSelections) {
                this.srcList.clearSelection();
            }
        }
    }

    protected void addPressed() {
        DefaultListModel selListModel = (DefaultListModel)this.selList.getModel();
        DefaultListModel srcListModel = (DefaultListModel)this.srcList.getModel();
        List selectedIndices = TUpDownListSelector.enumSelectedIndices(this.srcList);
        this.srcList.clearSelection();
        int selectedPosition = selListModel.size();
        for (Integer index : selectedIndices) {
            Object element = srcListModel.remove(index);
            selListModel.add(selectedPosition, element);
        }
        this.srcList.validate();
        this.selList.validate();
    }

    private void removePressed() {
        DefaultListModel selListModel = (DefaultListModel)this.selList.getModel();
        DefaultListModel srcListModel = (DefaultListModel)this.srcList.getModel();
        List selectedIndices = TUpDownListSelector.enumSelectedIndices(this.selList);
        this.selList.clearSelection();
        int selectedPosition = selListModel.size();
        for (Integer index : selectedIndices) {
            Object element = selListModel.remove(index);
            int size = srcListModel.size();
            boolean going = true;
            int i = 0;
            while (going && i < size) {
                Object item = srcListModel.get(i);
                String str = item.toString();
                if (str.compareTo(element.toString()) < 0) {
                    ++i;
                    continue;
                }
                going = false;
            }
            srcListModel.add(i, element);
        }
        this.srcList.validate();
        this.selList.validate();
    }

    private void downPressed() {
        ListSelectionModel selModel = this.selList.getSelectionModel();
        DefaultListModel selListModel = (DefaultListModel)this.selList.getModel();
        List ranges = TUpDownListSelector.enumSelectedRanges(this.selList);
        this.selList.clearSelection();
        for (Range range : ranges) {
            Object element = selListModel.remove(range.last + 1);
            selListModel.add(range.first, element);
        }
        TUpDownListSelector.reselect(this.selList, ranges, 1);
    }

    private void upPressed() {
        ListSelectionModel selModel = this.selList.getSelectionModel();
        DefaultListModel selListModel = (DefaultListModel)this.selList.getModel();
        List ranges = TUpDownListSelector.enumSelectedRanges(this.selList);
        this.selList.clearSelection();
        for (Range range : ranges) {
            Object element = selListModel.remove(range.first - 1);
            selListModel.add(range.last, element);
        }
        TUpDownListSelector.reselect(this.selList, ranges, -1);
    }

    private static List enumSelectedRanges(JList listCtrl) {
        Range current = null;
        ListSelectionModel model = listCtrl.getSelectionModel();
        LinkedList<Range> result = new LinkedList<Range>();
        int max = listCtrl.getModel().getSize();
        for (int i = 0; i < max; ++i) {
            if (model.isSelectedIndex(i)) {
                if (current != null) {
                    current.last = i;
                    continue;
                }
                current = new Range(i);
                continue;
            }
            if (current == null) continue;
            result.add(current);
            current = null;
        }
        if (current != null) {
            result.add(current);
        }
        return result;
    }

    protected static List enumSelectedIndices(JList listCtrl) {
        ListSelectionModel model = listCtrl.getSelectionModel();
        LinkedList<Integer> result = new LinkedList<Integer>();
        int i = listCtrl.getModel().getSize();
        while (i > 0) {
            if (!model.isSelectedIndex(--i)) continue;
            result.add(new Integer(i));
        }
        return result;
    }

    private static void reselect(JList listCtrl, List rangeList, int delta) {
        ListSelectionModel model = listCtrl.getSelectionModel();
        for (Range range : rangeList) {
            model.addSelectionInterval(range.first + delta, range.last + delta);
        }
    }

    public void setMnemonicForTitles(String leftTitleMnemonic, String rightTitleMnemonic) {
        this.leftTitle.setDisplayedMnemonic(GuiUtil.getMnemonic(leftTitleMnemonic));
        this.rightTitle.setDisplayedMnemonic(GuiUtil.getMnemonic(rightTitleMnemonic));
    }

    private static class Range {
        public int first;
        public int last;

        public Range(int index) {
            this.first = index;
            this.last = index;
        }
    }
}

