/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JTable;
import javax.swing.RepaintManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class TablePrinter
extends Component
implements Printable {
    private JTable pTable;
    private String pTitle;
    private PrinterJob printJob = PrinterJob.getPrinterJob();
    private PageFormat pageFormat = this.printJob.defaultPage();
    private JTableHeader tableHeader;
    private int[] pageWidths = null;
    private boolean pageinfoCalculated = false;
    private int totalNumPages = 0;
    private int prevPageIndex = 0;
    private int subPageIndex = 0;
    private int numPagesWide = 1;
    private double tableHeightOnFullPage;
    private double headerHeight;
    private double pageWidth;
    private double pageHeight;
    private int fontHeight;
    private int fontDesent;
    private double tableHeight;
    private double rowHeight;

    public static void printTable(JTable table, String title) {
        TablePrinter tp = new TablePrinter();
        tp.pTable = table;
        tp.pTitle = title;
        RepaintManager.currentManager(tp).setDoubleBufferingEnabled(false);
        tp.pageFormat.setOrientation(0);
        tp.printJob.setPrintable(tp, tp.pageFormat);
        try {
            tp.printJob.print();
        }
        catch (Exception printException) {
            System.err.println(printException);
            printException.printStackTrace();
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        if (!this.pageinfoCalculated) {
            this.getPageInfo(g, pageFormat);
        }
        g2.setColor(Color.black);
        if (pageIndex >= this.totalNumPages) {
            return 1;
        }
        if (this.prevPageIndex != pageIndex) {
            ++this.subPageIndex;
            if (this.subPageIndex == this.numPagesWide) {
                this.subPageIndex = 0;
            }
        }
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int rowIndex = pageIndex / this.numPagesWide;
        this.printTablePart(g2, pageFormat, rowIndex, this.subPageIndex);
        this.prevPageIndex = pageIndex;
        return 0;
    }

    public void getPageInfo(Graphics g, PageFormat pageFormat) {
        this.pageWidths = null;
        this.prevPageIndex = 0;
        this.fontHeight = g.getFontMetrics().getHeight();
        this.fontDesent = g.getFontMetrics().getDescent();
        this.tableHeader = this.pTable.getTableHeader();
        double headerWidth = this.tableHeader.getWidth();
        this.headerHeight = this.tableHeader.getHeight() + this.pTable.getRowMargin();
        this.pageHeight = pageFormat.getImageableHeight();
        this.pageWidth = pageFormat.getImageableWidth();
        double tableWidth = this.pTable.getColumnModel().getTotalColumnWidth();
        this.tableHeight = this.pTable.getHeight();
        this.rowHeight = this.pTable.getRowHeight() + this.pTable.getRowMargin();
        this.tableHeightOnFullPage = (int)(this.pageHeight - this.headerHeight - (double)(this.fontHeight * 2));
        this.tableHeightOnFullPage = (double)((int)(this.tableHeightOnFullPage / this.rowHeight)) * this.rowHeight;
        TableColumnModel tableColumnModel = this.tableHeader.getColumnModel();
        int columns = tableColumnModel.getColumnCount();
        int columnMargin = tableColumnModel.getColumnMargin();
        int[] temp = new int[columns];
        temp[0] = 0;
        int length = 0;
        this.numPagesWide = 1;
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            int columnWidth = tableColumnModel.getColumn(columnIndex).getWidth();
            if ((double)(length + columnWidth + columnMargin) > this.pageWidth) {
                temp[this.numPagesWide] = temp[this.numPagesWide - 1] + length;
                length = columnWidth;
                ++this.numPagesWide;
                continue;
            }
            length += columnWidth + columnMargin;
        }
        temp[this.numPagesWide] = temp[this.numPagesWide - 1] + length;
        this.pageWidths = new int[this.numPagesWide + 1];
        for (int i = 0; i <= this.numPagesWide; ++i) {
            this.pageWidths[i] = temp[i];
        }
        this.totalNumPages = (int)(this.tableHeight / this.tableHeightOnFullPage);
        if (this.tableHeight % this.tableHeightOnFullPage >= this.rowHeight) {
            ++this.totalNumPages;
        }
        this.totalNumPages *= this.numPagesWide;
        this.pageinfoCalculated = true;
    }

    public void printTablePart(Graphics2D g2, PageFormat pageFormat, int rowIndex, int columnIndex) {
        String pageNumber = "Page: " + (rowIndex + 1);
        if (this.numPagesWide > 1) {
            pageNumber = pageNumber + "-" + (columnIndex + 1);
        }
        int clipLeft = this.pageWidths[columnIndex];
        int clipRight = this.pageWidths[columnIndex + 1];
        g2.drawString(this.pTitle, 5, (int)(this.pageHeight - (double)this.fontHeight));
        g2.drawString(pageNumber, (int)this.pageWidth - 70, (int)(this.pageHeight - (double)this.fontHeight));
        double clipHeight = Math.min(this.tableHeightOnFullPage, this.tableHeight - (double)rowIndex * this.tableHeightOnFullPage);
        int clipWidth = clipRight - clipLeft;
        g2.translate(-this.pageWidths[columnIndex], 0);
        g2.setClip(clipLeft, 0, clipWidth, (int)this.headerHeight);
        this.tableHeader.paint(g2);
        g2.translate(0.0, this.headerHeight);
        g2.translate(0.0, -this.tableHeightOnFullPage * (double)rowIndex);
        g2.setClip(clipLeft, (int)this.tableHeightOnFullPage * rowIndex, clipWidth, (int)clipHeight);
        this.pTable.paint(g2);
        double pageTop = this.tableHeightOnFullPage * (double)rowIndex - this.headerHeight;
        double pageBottom = pageTop + clipHeight + this.headerHeight;
        g2.drawRect(clipLeft, (int)pageTop, clipWidth, (int)(clipHeight + this.headerHeight));
    }
}

