/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.NameListTreeCellRenderer;
import org.eclipse.aperi.gui.Selector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.xmsg.MessageLog;

public class TreeSelector
extends Selector
implements TreeSelectionListener,
MouseListener,
KeyListener {
    protected JTree sourceTree;
    protected JTree selectedTree;
    private int configuredCleanupDepth = 1;
    boolean multipleObjectsDisallowed = false;
    boolean returningDbTsSubtree = false;
    private static final int EXCLUDE_ROOT = Integer.MIN_VALUE;
    private Map excludeMap;
    private Reparenter reparenter;

    public static void expandAll(JTree tree) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (node.getChildCount() > 0) continue;
            TreePath path = new TreePath(node.getPath());
            path = path.getParentPath();
            tree.expandPath(path);
        }
    }

    public void setCleanupDepth(int cleanupDepth) {
        this.configuredCleanupDepth = cleanupDepth;
    }

    public void setUpExcludes() {
        this.excludeMap = new HashMap();
        TreeSelectorNode excludeRoot = this.getExcludeRoot();
        if (excludeRoot != null) {
            Enumeration<TreeNode> e = excludeRoot.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                TreeSelectorNode node = (TreeSelectorNode)e.nextElement();
                if (!node.excludable) continue;
                ExcludeList list = new ExcludeList();
                list.excluded = true;
                NameList name = node.getNameList();
                MutableInteger key = new MutableInteger(name.nlID);
                this.excludeMap.put(key, list);
                node.excludeParents = list;
            }
        }
        TreeSelector.expandAll(this.selectedTree);
    }

    public TreeSelector(JTree sourceTree, JTree selectedTree, Reparenter pReparenter, boolean groupByClusterButton) {
        super(sourceTree, selectedTree, groupByClusterButton);
        this.sourceTree = sourceTree;
        this.selectedTree = selectedTree;
        this.setTreeOptions(sourceTree);
        this.setTreeOptions(selectedTree);
        sourceTree.putClientProperty("JTree.lineStyle", "Angled");
        selectedTree.putClientProperty("JTree.lineStyle", "Angled");
        this.setUpExcludes();
        selectedTree.addMouseListener(this);
        sourceTree.addMouseListener(this);
        this.reparenter = pReparenter;
        sourceTree.setSelectionRow(0);
        selectedTree.setSelectionRow(0);
    }

    public TreeSelector(JTree sourceTree, JTree selectedTree, Reparenter pReparenter) {
        this(sourceTree, selectedTree, pReparenter, false);
    }

    public TreeSelector(JTree sourceTree, JTree selectedTree, boolean clusteringPossible) {
        this(sourceTree, selectedTree, null, clusteringPossible);
    }

    public TreeSelector(JTree sourceTree, JTree selectedTree) {
        this(sourceTree, selectedTree, null, false);
    }

    private void setTreeOptions(JTree tree) {
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.addTreeSelectionListener(this);
        tree.setCellRenderer(new NameListTreeCellRenderer());
    }

    public void setEnabled(boolean state) {
        if (!state) {
            this.sourceTree.clearSelection();
            this.selectedTree.clearSelection();
        }
        this.sourceTree.setEnabled(state);
        this.selectedTree.setEnabled(state);
        this.setEnabledPane(this.rightPane, state);
        this.setEnabledPane(this.leftPane, state);
    }

    private void setEnabledPane(JPanel pane, boolean state) {
        Component[] compArray = pane.getComponents();
        for (int i = 0; i < compArray.length; ++i) {
            compArray[i].setEnabled(state);
        }
    }

    public void disableMultipleSelection() {
        this.multipleObjectsDisallowed = true;
    }

    public void returnEntireDbTsSubtree() {
        this.returningDbTsSubtree = true;
    }

    public NameList getNameList() {
        return this.getNameList(this.selectedTree);
    }

    private NameList getNameList(JTree tree) {
        NameList listHead = null;
        NameList listTail = null;
        String dbRoot = null;
        if (this.returningDbTsSubtree) {
            dbRoot = MessageLog.getMessageNoID("DBG0518L");
        }
        boolean dbTree = false;
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        TreeSelectorNode node = (TreeSelectorNode)model.getRoot();
        Enumeration<TreeNode> e = node.preorderEnumeration();
        TreeSelectorNode badGuy = null;
        while (e.hasMoreElements()) {
            node = (TreeSelectorNode)e.nextElement();
            NameList name = node.getNameList();
            if (this.returningDbTsSubtree && name.nlName != null && dbRoot.compareTo(name.nlName) == 0) {
                dbTree = true;
            }
            if (name.nlID <= 0 && !dbTree) continue;
            if (node.expandOnRightOnly) {
                badGuy = node;
            } else if (node.isNodeAncestor(badGuy)) continue;
            if (!node.selectable && !node.excludable && !dbTree) continue;
            name.nlNext = null;
            if (listHead == null) {
                listHead = name;
            } else {
                listTail.nlNext = name;
            }
            listTail = name;
        }
        return listHead;
    }

    public NameList getReportingNameList() {
        return this.getReportingNameList(this.selectedTree);
    }

    private NameList getReportingNameList(JTree tree) {
        NameList listHead = null;
        NameList listTail = null;
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        TreeSelectorNode node = (TreeSelectorNode)model.getRoot();
        Enumeration<TreeNode> e = node.preorderEnumeration();
        TreeSelectorNode badGuy = null;
        while (e.hasMoreElements()) {
            node = (TreeSelectorNode)e.nextElement();
            NameList name = node.getNameList();
            if (name.nlID <= 0) continue;
            if (node.expandOnRightOnly) {
                badGuy = node;
            } else if (node.isNodeAncestor(badGuy)) continue;
            name.nlNext = null;
            if (listHead == null) {
                listHead = name;
            } else {
                listTail.nlNext = name;
            }
            listTail = name;
        }
        return listHead;
    }

    public void exclude(TreePath path) {
        TreeSelectorNode excludeRoot = this.getExcludeRoot();
        if (excludeRoot == null) {
            excludeRoot = TreeSelector.addExcludeRoot(this.selectedTree);
        }
        TreeSelectorNode excludedNode = (TreeSelectorNode)path.getLastPathComponent();
        NameList name = excludedNode.getNameList();
        name.nlState = (byte)(name.nlState | 1);
        ExcludeList list = excludedNode.excludeParents;
        list.excluded = true;
        DefaultTreeModel model = (DefaultTreeModel)this.selectedTree.getModel();
        int i = list.size();
        TreeNode[] array = new TreeNode[i];
        Iterator iterator = list.iterator();
        while (i > 0) {
            MutableTreeNode node = (MutableTreeNode)iterator.next();
            array[--i] = node.getParent();
            iterator.remove();
            model.removeNodeFromParent(node);
        }
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        Object[] fromPath = path.getParentPath().getPath();
        int levels = 1;
        if (this.reparenter != null) {
            MutableInteger obj = new MutableInteger(levels);
            excludeRoot = this.reparenter.reparent(excludeRoot, name, obj);
            levels = obj.value;
        }
        TreeSelectorNode toParent = this.getToParent(model, fromPath, path.getPathCount() - levels, excludeRoot);
        this.addChild(model, toParent, excludedNode);
        excludedNode.setButtonFlag(false);
        TreePath tp = new TreePath(excludedNode.getPath());
        this.selectedTree.makeVisible(tp);
        this.selectedTree.getSelectionModel().setSelectionPath(tp);
    }

    private TreeSelectorNode getExcludeRoot() {
        TreeSelectorNode root = (TreeSelectorNode)this.selectedTree.getModel().getRoot();
        if (root.getChildCount() > 0) {
            TreeSelectorNode lastChild = (TreeSelectorNode)root.getLastChild();
            if (lastChild.getNameList().nlID == Integer.MIN_VALUE) {
                return lastChild;
            }
        }
        return null;
    }

    public void pruneExcluded(TreeSelectorNode subRoot) {
        TreeSelectorNode excludeRoot = this.getExcludeRoot();
        Enumeration<TreeNode> pruneEnum = subRoot.depthFirstEnumeration();
        TreeSelectorNode excludedNode = null;
        LinkedList<TreeSelectorNode> pruneList = new LinkedList<TreeSelectorNode>();
        MutableInteger key = new MutableInteger();
        while (pruneEnum.hasMoreElements()) {
            TreeSelectorNode pruneCandidate = (TreeSelectorNode)pruneEnum.nextElement();
            if (!pruneCandidate.excludable) continue;
            NameList name = pruneCandidate.getNameList();
            key.value = name.nlID;
            ExcludeList list = (ExcludeList)this.excludeMap.get(key);
            if (list == null) {
                list = new ExcludeList();
                list.excluded = false;
                this.excludeMap.put(key, list);
                key = new MutableInteger();
            }
            pruneCandidate.excludeParents = list;
            if (!list.excluded) {
                list.add(pruneCandidate);
                continue;
            }
            list.add(pruneCandidate.getParent());
            boolean found = false;
            Enumeration<TreeNode> excludeEnum = excludeRoot.depthFirstEnumeration();
            while (!found && excludeEnum.hasMoreElements()) {
                excludedNode = (TreeSelectorNode)excludeEnum.nextElement();
                if (!excludedNode.excludable) continue;
                name = excludedNode.getNameList();
                if (name.nlID != key.value) continue;
                found = true;
            }
            if (!found) continue;
            pruneList.add(pruneCandidate);
        }
        if (pruneList.size() > 0) {
            DefaultTreeModel model = (DefaultTreeModel)this.selectedTree.getModel();
            for (TreeSelectorNode pruneCandidate : pruneList) {
                model.removeNodeFromParent(pruneCandidate);
            }
        }
    }

    public void unExclude(TreePath path) {
        TreeSelectorNode excludedNode = (TreeSelectorNode)path.getLastPathComponent();
        DefaultTreeModel model = (DefaultTreeModel)this.selectedTree.getModel();
        model.removeNodeFromParent(excludedNode);
        Object[] fromPath = path.getParentPath().getPath();
        this.cleanupPath(model, fromPath, fromPath.length - 1, 0);
        ExcludeList list = excludedNode.excludeParents;
        if (list == null) {
            return;
        }
        list.excluded = false;
        int i = list.size();
        if (i <= 0) {
            return;
        }
        NameList name = excludedNode.getNameList();
        name.nlState = (byte)(name.nlState & 0xFFFFFFFE);
        TreeSelectorNode[] array = new TreeSelectorNode[i];
        Iterator iterator = list.iterator();
        while (i > 0) {
            TreeSelectorNode parent = (TreeSelectorNode)iterator.next();
            array[--i] = new TreeSelectorNode(name, excludedNode.selectable, true, excludedNode.getAllowsChildren(), excludedNode.expandOnRightOnly, excludedNode.selectErrorMsgID, parent.showClusterName, parent.showVsName);
            array[i].excludeParents = list;
            array[i].setButtonFlag(array[i].canSelect());
            iterator.remove();
            this.addChild(model, parent, array[i]);
        }
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        TreePath tp = new TreePath(excludedNode.getPath());
        this.selectedTree.getSelectionModel().setSelectionPath(tp);
    }

    public void pruneSelected(TreeSelectorNode subTree, int selectedTreeKey) {
        TreeSelectorNode selectedSubTree;
        DefaultTreeModel model = (DefaultTreeModel)this.selectedTree.getModel();
        Enumeration<TreeNode> childEnum = ((TreeSelectorNode)model.getRoot()).children();
        do {
            if (!childEnum.hasMoreElements()) {
                return;
            }
            selectedSubTree = (TreeSelectorNode)childEnum.nextElement();
        } while (selectedSubTree.hiOrderSortKey != selectedTreeKey);
        model = (DefaultTreeModel)this.sourceTree.getModel();
        Enumeration<TreeNode> selectedEnum = selectedSubTree.depthFirstEnumeration();
        block1: while (selectedEnum.hasMoreElements()) {
            TreeSelectorNode selectedNode = (TreeSelectorNode)selectedEnum.nextElement();
            if (!selectedNode.selectable) continue;
            Enumeration<TreeNode> pruneEnum = subTree.depthFirstEnumeration();
            while (pruneEnum.hasMoreElements()) {
                TreeSelectorNode pruneCandidate = (TreeSelectorNode)pruneEnum.nextElement();
                if (pruneCandidate.compareTo(selectedNode) != 0) continue;
                TreeSelectorNode parent = (TreeSelectorNode)pruneCandidate.getParent();
                Object[] path = parent.getPath();
                model.removeNodeFromParent(pruneCandidate);
                this.cleanupPath(model, path, path.length - 1, 1);
                continue block1;
            }
        }
    }

    public static TreeSelectorNode makeExcludeRoot() {
        NameList name = new NameList();
        name.nlName = MessageLog.getMessageNoID("GUI0248L");
        name.nlID = Integer.MIN_VALUE;
        name.nlInfo = (short)-1;
        TreeSelectorNode exclude = new TreeSelectorNode(name, false, false, true);
        exclude.setButtonFlag(false);
        exclude.setSortKey(Short.MAX_VALUE);
        return exclude;
    }

    private static TreeSelectorNode addExcludeRoot(JTree tree) {
        TreeSelectorNode exclude = TreeSelector.makeExcludeRoot();
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        TreeSelectorNode root = (TreeSelectorNode)model.getRoot();
        model.insertNodeInto(exclude, root, root.getChildCount());
        return exclude;
    }

    public void valueChanged(TreeSelectionEvent event) {
        boolean buttonFlag = false;
        JTree changedTree = (JTree)event.getSource();
        TreePath[] selectedPaths = changedTree.getSelectionPaths();
        TreeSelectionModel tsm = null;
        TreeSelectorNode selectedNode = null;
        if (selectedPaths != null) {
            for (int i = 0; i < selectedPaths.length; ++i) {
                selectedNode = (TreeSelectorNode)selectedPaths[i].getLastPathComponent();
                if (!selectedNode.selectable) continue;
                buttonFlag = true;
            }
        }
        if (changedTree == this.sourceTree) {
            this.addButton.setEnabled(buttonFlag);
            if (buttonFlag) {
                this.delButton.setEnabled(false);
                tsm = this.selectedTree.getSelectionModel();
                selectedPaths = tsm.getSelectionPaths();
                if (selectedPaths != null) {
                    tsm.removeSelectionPaths(selectedPaths);
                }
            }
        } else {
            this.delButton.setEnabled(buttonFlag);
            if (buttonFlag) {
                this.addButton.setEnabled(false);
                tsm = this.sourceTree.getSelectionModel();
                selectedPaths = tsm.getSelectionPaths();
                if (selectedPaths != null) {
                    tsm.removeSelectionPaths(selectedPaths);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof JButton) {
            JButton button = (JButton)event.getSource();
            if (button == this.addButton) {
                if (this.multipleObjectsDisallowed) {
                    this.removeSelection();
                }
                this.processSelections(this.sourceTree, this.selectedTree);
                this.addButton.setEnabled(false);
                this.sourceTree.setSelectionRow(0);
                this.sourceTree.requestFocus();
            } else if (button == this.delButton) {
                this.processSelections(this.selectedTree, this.sourceTree);
                this.delButton.setEnabled(false);
                this.selectedTree.setSelectionRow(0);
                this.selectedTree.requestFocus();
            }
        }
    }

    private void removeNode(List list, TreeSelectorNode node) {
        if (list.size() <= 0) {
            return;
        }
        list.remove(node);
        if (list.size() <= 0) {
            NameList name = node.getNameList();
            MutableInteger key = new MutableInteger(name.nlID);
            this.excludeMap.remove(key);
        }
    }

    private void purgeFromExcluded(TreeSelectorNode excludeRoot, TreeSelectorNode node) {
        Enumeration<TreeNode> e = excludeRoot.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            TreeSelectorNode current = (TreeSelectorNode)e.nextElement();
            if (current.excludeParents == null) continue;
            this.removeNode(current.excludeParents, node);
        }
    }

    public void nodeUnselected(TreeSelectorNode subTree) {
        TreeSelectorNode excludeRoot;
        TreeSelectorNode node;
        Enumeration<TreeNode> e;
        int maxLevel = -1;
        if (subTree.getChildCount() > 0) {
            e = subTree.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                ExcludeList list;
                node = (TreeSelectorNode)e.nextElement();
                int level = node.getLevel();
                if (level > maxLevel) {
                    maxLevel = level;
                }
                if (!node.excludable || (list = node.excludeParents) == null) continue;
                this.removeNode(list, node);
            }
        }
        if ((excludeRoot = this.getExcludeRoot()) == null) {
            return;
        }
        if ((maxLevel -= subTree.getLevel()) <= 1) {
            this.purgeFromExcluded(excludeRoot, subTree);
        } else {
            e = subTree.children();
            while (e.hasMoreElements()) {
                node = (TreeSelectorNode)e.nextElement();
                this.purgeFromExcluded(excludeRoot, node);
            }
        }
    }

    public void processSelections(JTree fromTree, JTree toTree) {
        DefaultTreeModel fromModel = (DefaultTreeModel)fromTree.getModel();
        DefaultTreeModel toModel = (DefaultTreeModel)toTree.getModel();
        TreePath[] selectedPaths = fromTree.getSelectionPaths();
        if (selectedPaths != null) {
            for (int i = 0; i < selectedPaths.length; ++i) {
                TreePath path = selectedPaths[i];
                TreeSelectorNode selectedNode = (TreeSelectorNode)path.getLastPathComponent();
                if (!selectedNode.selectable) continue;
                fromModel.removeNodeFromParent(selectedNode);
                if (toTree == this.sourceTree && selectedNode.expandOnRightOnly) {
                    this.nodeUnselected(selectedNode);
                }
                Object[] fromPath = path.getParentPath().getPath();
                TreeSelectorNode toRoot = (TreeSelectorNode)toModel.getRoot();
                boolean toTreeIsEmpty = toRoot.getChildCount() == 0;
                TreeSelectorNode toParent = this.getToParent(toModel, fromPath, 1, toRoot);
                this.addChild(toModel, toParent, selectedNode);
                NameList name = selectedNode.getNameList();
                int cleanupDepth = 0;
                if (toTree == this.selectedTree) {
                    cleanupDepth = this.configuredCleanupDepth;
                    toTree.makeVisible(new TreePath(selectedNode.getPath()));
                } else if (toTreeIsEmpty) {
                    toTree.makeVisible(new TreePath(selectedNode.getPath()));
                }
                this.cleanupPath(fromModel, fromPath, fromPath.length - 1, cleanupDepth);
            }
        }
    }

    public void removeSelection() {
        int deleteRow = this.selectedTree.getRowCount();
        if (deleteRow > 0) {
            DefaultTreeModel model = (DefaultTreeModel)this.selectedTree.getModel();
            DefaultTreeModel toModel = (DefaultTreeModel)this.sourceTree.getModel();
            TreePath path = this.selectedTree.getPathForRow(deleteRow - 1);
            TreeSelectorNode selectedNode = (TreeSelectorNode)path.getLastPathComponent();
            model.removeNodeFromParent(selectedNode);
            Object[] fromPath = path.getParentPath().getPath();
            TreeSelectorNode toParent = this.getToParent(toModel, fromPath, 1, (TreeSelectorNode)toModel.getRoot());
            this.addChild(toModel, toParent, selectedNode);
            this.cleanupPath(model, fromPath, fromPath.length - 1, 0);
        }
    }

    private TreeSelectorNode getToParent(DefaultTreeModel model, Object[] fromPath, int pathDepth, TreeSelectorNode toParent) {
        if (pathDepth == fromPath.length) {
            return toParent;
        }
        TreeSelectorNode fromNode = (TreeSelectorNode)fromPath[pathDepth];
        TreeSelectorNode toClone = null;
        int childIndex = 0;
        Enumeration<TreeNode> childEnum = toParent.children();
        while (childEnum.hasMoreElements()) {
            TreeSelectorNode child = (TreeSelectorNode)childEnum.nextElement();
            int cmp = child.compareTo(fromNode);
            if (cmp == 0) {
                toClone = child;
                break;
            }
            if (cmp > 0 && !fromNode.isNonClusteredLabel) break;
            ++childIndex;
        }
        if (toClone == null) {
            toClone = (TreeSelectorNode)fromNode.clone();
            toClone.selectable = false;
            toClone.expandOnRightOnly = false;
            model.insertNodeInto(toClone, toParent, childIndex);
        }
        return this.getToParent(model, fromPath, ++pathDepth, toClone);
    }

    public void addChild(DefaultTreeModel model, TreeSelectorNode parent, TreeSelectorNode newChild) {
        TreeSelectorNode oldChild;
        int childIndex = 0;
        Enumeration<TreeNode> childEnum = parent.children();
        while (childEnum.hasMoreElements() && (oldChild = (TreeSelectorNode)childEnum.nextElement()).compareTo(newChild) <= 0) {
            ++childIndex;
        }
        if (newChild.expandOnRightOnly) {
            boolean allowChildren;
            boolean bl = allowChildren = model == this.selectedTree.getModel();
            if (!allowChildren) {
                newChild.removeAllChildren();
                newChild.childrenFetched = false;
            }
            newChild.setAllowsChildren(true);
        }
        model.insertNodeInto(newChild, parent, childIndex);
    }

    private void cleanupPath(DefaultTreeModel model, Object[] fromPath, int pathDepth, int minDepth) {
        if (pathDepth <= minDepth) {
            return;
        }
        TreeSelectorNode node = (TreeSelectorNode)fromPath[pathDepth];
        if (node.getChildCount() == 0) {
            model.removeNodeFromParent(node);
            this.cleanupPath(model, fromPath, pathDepth - 1, minDepth);
        }
    }

    private void checkPopup(MouseEvent event) {
        if (!event.isPopupTrigger()) {
            return;
        }
        if (event.getSource() != this.selectedTree) {
            return;
        }
        if (this.selectedTree.getRowForLocation(event.getX(), event.getY()) > -1) {
            TreePath path = this.selectedTree.getPathForLocation(event.getX(), event.getY());
            TreeSelectorNode node = (TreeSelectorNode)path.getLastPathComponent();
            if (node.excludable) {
                NameList nodeName = node.getNameList();
                this.showPopupMenu(event, path, nodeName);
            }
        }
    }

    private void showPopupMenu(MouseEvent event, TreePath path, NameList name) {
        Component invoker = event.getComponent();
        int x = event.getX();
        int y = event.getY();
        JPopupMenu popup = new JPopupMenu();
        JMenuItem exclude = new JMenuItem();
        if ((name.nlState & 1) == 0) {
            exclude.setText(MessageLog.getMessageNoID("STG4031L"));
        } else {
            exclude.setText(MessageLog.getMessageNoID("STG4035L"));
        }
        ExcludeListener listener = new ExcludeListener(path, name);
        exclude.addActionListener(listener);
        popup.add(exclude);
        popup.show(invoker, x, y);
    }

    public void mousePressed(MouseEvent event) {
        this.checkPopup(event);
    }

    public void mouseReleased(MouseEvent event) {
        this.checkPopup(event);
    }

    public void mouseClicked(MouseEvent event) {
        JTree other;
        int y;
        if (event.getClickCount() != 2) {
            return;
        }
        Object obj = event.getSource();
        if (!(obj instanceof JTree)) {
            return;
        }
        JTree tree = (JTree)obj;
        int x = event.getX();
        TreePath path = tree.getPathForLocation(x, y = event.getY());
        if (path == null) {
            return;
        }
        TreeSelectorNode node = (TreeSelectorNode)path.getLastPathComponent();
        if (!node.selectable) {
            return;
        }
        if (!node.getButtonFlag()) {
            return;
        }
        if (tree == this.selectedTree) {
            other = this.sourceTree;
        } else {
            if (this.multipleObjectsDisallowed) {
                this.removeSelection();
            }
            other = this.selectedTree;
        }
        this.processSelections(tree, other);
    }

    public void keyPressed(KeyEvent e) {
        if (e.isAltDown() && e.getKeyCode() == 65) {
            this.sourceTree.setSelectionRow(0);
            this.sourceTree.requestFocus();
        } else if (e.isAltDown() && e.getKeyCode() == 78) {
            this.selectedTree.setSelectionRow(0);
            this.selectedTree.requestFocus();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public NameList getSelectedList() {
        return this.getNameList(this.selectedTree);
    }

    public NameList getAvailableList() {
        return this.getNameList(this.sourceTree);
    }

    public void replaceTrees(JTree available, JTree selected) {
        this.selectedTree.setModel(selected.getModel());
        this.sourceTree.setModel(available.getModel());
        this.sourceTree.setSelectionRow(0);
        this.selectedTree.setSelectionRow(0);
    }

    public void disableAddButton() {
        this.addButton.setEnabled(false);
    }

    private class ExcludeListener
    implements ActionListener {
        private TreePath path;
        private NameList name;

        public ExcludeListener(TreePath pPath, NameList pName) {
            this.path = pPath;
            this.name = pName;
        }

        public void actionPerformed(ActionEvent event) {
            if ((this.name.nlState & 1) == 0) {
                TreeSelector.this.exclude(this.path);
            } else {
                TreeSelector.this.unExclude(this.path);
            }
        }
    }

    public static interface Reparenter {
        public TreeSelectorNode reparent(TreeSelectorNode var1, NameList var2, MutableInteger var3);
    }

    public static class ExcludeList
    extends LinkedList {
        public boolean excluded;
    }
}

