/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.admin.ChangeDeviceServerPasswordDialog;
import org.eclipse.aperi.gui.admin.DeviceServerData;
import org.eclipse.aperi.gui.admin.GenericDeviceServiceTreeNode;

public class DeviceServerServiceTreeNode
extends GenericDeviceServiceTreeNode
implements ActionListener {
    private static String deviceServerServiceName = Util.getString("DEVICE_SERVER");
    private static String CHANGEPWD = Util.getString("CHANGE_PWD");
    private String actionCommand;
    public JPopupMenu popup = null;
    private int port;
    private String jdbcUrl;
    private String jdbcDriver;
    private String dbPoolCount;
    private int inactiveAgents;
    private int totalAgents;
    private long vmSize;
    private long elapsedTime;
    private long startTime;

    public DeviceServerServiceTreeNode(String requestType, String uniqueType, byte state, int port, long vms, long et, long st, String url, String dri, String cnt, int tot, int ina) {
        super(deviceServerServiceName, requestType, uniqueType, state);
        this.jdbcUrl = url;
        this.jdbcDriver = dri;
        this.dbPoolCount = cnt;
        this.totalAgents = tot;
        this.inactiveAgents = ina;
        this.vmSize = vms;
        this.elapsedTime = et;
        this.startTime = st;
    }

    public void showPopupMenu(MouseEvent event) {
        boolean showPopup = true;
        if (event == null) {
            showPopup = false;
        }
        this.popup = this.getPopupMenu();
        JMenuItem changePwd = new JMenuItem(CHANGEPWD);
        changePwd.setName(CHANGEPWD);
        changePwd.setEnabled(DeviceServerServiceTreeNode.guiMain.getUserPrefs().administrator);
        changePwd.setActionCommand(CHANGEPWD);
        changePwd.addActionListener(this);
        this.popup.add(changePwd);
        if (showPopup) {
            this.showPopupMenu(this.popup, event);
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.actionCommand = event.getActionCommand();
        if (this.actionCommand == CHANGEPWD) {
            this.changePassword();
        }
    }

    private void changePassword() {
        ChangeDeviceServerPasswordDialog chgp = new ChangeDeviceServerPasswordDialog(guiMain.getFrame(), Util.getString("CHANGE_PWD"), true);
        GuiUtil.centerDialog(chgp);
        chgp.displayDialog();
    }

    public boolean isRepresentingTheServerService() {
        return false;
    }

    public JPanel getPanel() {
        return new DeviceServerData(this);
    }

    public String getDbPoolCount() {
        return this.dbPoolCount;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public int getPort() {
        return this.port;
    }

    public void setDbPoolCount(String string) {
        this.dbPoolCount = string;
    }

    public void setJdbcDriver(String string) {
        this.jdbcDriver = string;
    }

    public void setJdbcUrl(String string) {
        this.jdbcUrl = string;
    }

    public void setPort(int i) {
        this.port = i;
    }

    public int getInactiveAgents() {
        return this.inactiveAgents;
    }

    public int getTotalAgents() {
        return this.totalAgents;
    }

    public void setInactiveAgents(int i) {
        this.inactiveAgents = i;
    }

    public void setTotalAgents(int i) {
        this.totalAgents = i;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public long getVMSize() {
        return this.vmSize;
    }
}

