/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.admin.DeviceNonserverServiceTreeNode;
import org.eclipse.aperi.gui.admin.DeviceServerServiceTreeNode;
import org.eclipse.aperi.gui.admin.GenericServiceTreeNode;
import org.eclipse.aperi.gui.admin.ServicesDDI;
import org.eclipse.aperi.gui.admin.ServicesTreeLabel;
import org.eclipse.aperi.server.req.DeviceServerStatusResp;

public class DeviceServicesTreeLabel
extends ServicesTreeLabel
implements ActionListener {
    protected String getLabelUIName() {
        return "DEVICE_SERVER";
    }

    protected void getServices() {
        GenericServiceTreeNode child;
        String currRequestType = null;
        DataDisplayInfo curr = DataDisplayInfo.getCurrent();
        if (curr != null && curr instanceof ServicesDDI) {
            currRequestType = ((GenericServiceTreeNode)curr.treeNode).getUniqueType();
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            child = (GenericServiceTreeNode)e.nextElement();
            if (child.ddi == null) continue;
            child.ddi.remove();
        }
        this.removeAllChildren();
        if (GuiClient.deviceServerStatus() <= 4) {
            DeviceServerStatusResp status = GuiClient.deviceServerStatusResp;
            this.add(new DeviceServerServiceTreeNode(status.getRequestType(), status.getUniqueRequestType(), status.getState(), status.getPort(), status.getVmSize(), status.getElapsedTime(), status.getStartTime(), status.getJdbcUrl(), status.getJdbcDriver(), status.getDbPoolCount(), status.getTotalAgents(), status.getInactiveAgents()));
            ArrayList services = status.getNonserverServices();
            for (int i = 0; i < services.size(); ++i) {
                DeviceServerStatusResp.NonserverService service = (DeviceServerStatusResp.NonserverService)services.get(i);
                this.add(new DeviceNonserverServiceTreeNode(service.getServiceName(), service.getRequestType(), service.getUniqueRequestType(), service.getState(), service.getDescription(), service.getVersion(), service.getInstallStatus(), service.getAvailable(), service.getDeployedStatus()));
            }
        }
        BaseTree.MyTree.nodeStructureChanged(this);
        if (currRequestType != null) {
            e = this.children();
            while (e.hasMoreElements()) {
                child = (GenericServiceTreeNode)e.nextElement();
                if (!child.getUniqueType().equals(currRequestType)) continue;
                child.select(null);
                break;
            }
        }
    }
}

