/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.LogViewerDDI;
import org.eclipse.aperi.gui.admin.AgentTreeNode;
import org.eclipse.aperi.gui.admin.InbandFabricAgentDDI;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.InbandFabricAgentInfo;
import org.eclipse.aperi.xmsg.MessageLog;

public class InbandFabricAgentTreeNode
extends AgentTreeNode
implements GuiRequestor,
ActionListener {
    private String node_name;
    private int node_id;
    private int node_state;
    private JPopupMenu popup;
    private static String checkMenuItemString;
    private static String viewLogMenuItemString;
    private static String removeMenuItemString;
    private static String refreshMenuItemString;

    public InbandFabricAgentTreeNode(Object name, int id, byte agentstate) {
        super(name, id, agentstate);
        this.node_name = (String)name;
        this.node_id = id;
        this.node_state = agentstate;
        this.setUserObject(name);
        this.setAllowsChildren(false);
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        switch (this.node_state) {
            case 1: {
                renderer.setIcon(IconFactory.getStateUpIcon());
                break;
            }
            case 0: {
                renderer.setIcon(IconFactory.getStateDownIcon());
            }
        }
    }

    public void showPopupMenu(MouseEvent event) {
        this.popup = this.getPopupMenu();
        checkMenuItemString = FabricGuiUtil.getString("FabricInBand_Check");
        JMenuItem checkMenu = new JMenuItem(checkMenuItemString);
        checkMenu.setActionCommand(checkMenuItemString);
        checkMenu.addActionListener(this);
        checkMenu.setEnabled(true);
        this.popup.add(checkMenu);
        viewLogMenuItemString = FabricGuiUtil.getString("FabricInBand_ViewLog");
        JMenuItem viewLogMenu = new JMenuItem(viewLogMenuItemString);
        viewLogMenu.setActionCommand(viewLogMenuItemString);
        viewLogMenu.addActionListener(this);
        if (this.node_state == 1) {
            viewLogMenu.setEnabled(true);
            this.popup.add(viewLogMenu);
        }
        removeMenuItemString = MessageLog.getMessageNoID("ADG0262L");
        JMenuItem removeMenu = new JMenuItem(removeMenuItemString);
        removeMenu.setToolTipText(MessageLog.getMessageNoID("ADG0263T"));
        removeMenu.setActionCommand(removeMenuItemString);
        removeMenu.addActionListener(this);
        removeMenu.setEnabled(true);
        this.popup.add(removeMenu);
        refreshMenuItemString = MessageLog.getMessageNoID("ADG0003L");
        JMenuItem refreshMenu = new JMenuItem(refreshMenuItemString);
        refreshMenu.setToolTipText(MessageLog.getMessageNoID("ADG0004T"));
        refreshMenu.setActionCommand(refreshMenuItemString);
        refreshMenu.addActionListener(this);
        refreshMenu.setEnabled(true);
        this.popup.add(refreshMenu);
        super.showPopupMenu(this.popup, event);
    }

    public void setNodeIconBasedOnStatusFromServer(int status) {
        this.node_state = status;
        BaseTree.MyTree.nodeChanged(this);
    }

    public void handleResponse(short status, Response response) {
        if (status == 0) {
            InbandFabricAgentInfo ifai = (InbandFabricAgentInfo)response.responseData;
            switch (ifai.request_type) {
                case 3: {
                    this.setNodeIconBasedOnStatusFromServer(ifai.status);
                    if (ifai.status == 1) {
                        String msg = MessageLog.getMessageNoID("ADG0294M", this.node_name);
                        JOptionPane.showMessageDialog(guiMain.getFrame(), msg, MessageLog.getMessageNoID("ADG0295T"), 1);
                        break;
                    }
                    String msg = this.node_name + " " + FabricGuiUtil.getInbandFabricAgentStatusString(ifai.status);
                    JOptionPane.showMessageDialog(guiMain.getFrame(), msg, MessageLog.getMessageNoID("ADG0295T"), 1);
                    break;
                }
                case 2: {
                    BaseTree.MyTree.removeNodeFromParent(this);
                    if (this.ddi == null) break;
                    this.ddi.remove();
                }
            }
        } else if (status == 12 && response.responseData != null) {
            InbandFabricAgentInfo ifai = (InbandFabricAgentInfo)response.responseData;
            if (ifai.request_type == 3 && ifai.message_status == 2) {
                BaseTree.MyTree.removeNodeFromParent(this);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        String actionCommand = event.getActionCommand();
        if (actionCommand.equals(checkMenuItemString)) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.fabric.InBandFabricAgentHandler";
            request.userName = GuiUtil.getUserName();
            InbandFabricAgentInfo ifai = new InbandFabricAgentInfo();
            request.requestData = ifai;
            request.flags = (byte)4;
            ifai.request_type = 3;
            ifai.hostname = this.node_name;
            ifai.hostId = this.node_id;
            GuiClient.doRequest(this, request);
        } else if (actionCommand.equals(removeMenuItemString)) {
            if (this.node_state == 0) {
                String desc = Util.getString("CONFIRM_DELETE", this.node_name);
                String title = MessageLog.getMessageNoID("ADG0262L");
                int choice = JOptionPane.showConfirmDialog(guiMain.getFrame(), desc, title, 0, 2);
                if (choice == 0) {
                    Request request = new Request();
                    request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
                    request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
                    request.subType = "org.eclipse.aperi.server.handler.gui.fabric.InBandFabricAgentHandler";
                    request.userName = GuiUtil.getUserName();
                    InbandFabricAgentInfo ifai = new InbandFabricAgentInfo();
                    request.requestData = ifai;
                    request.flags = (byte)4;
                    ifai.request_type = 2;
                    ifai.hostId = this.node_id;
                    GuiClient.doRequest(this, request);
                }
            } else {
                String[] inserts = new String[]{this.node_name, FabricGuiUtil.getInbandFabricAgentStatusString(this.node_state), FabricGuiUtil.getInbandFabricAgentStatusString(0)};
                String agentMessage = Util.getString("FMSG_InBand_RemoveInvalidState", inserts);
                String title = FabricGuiUtil.getString("FabricInBand_RemoveErrorTitle");
                JOptionPane.showMessageDialog(guiMain.getFrame(), agentMessage, title, 0);
            }
        } else if (actionCommand.equals(viewLogMenuItemString)) {
            new LogViewer(this.node_id, (BaseTreeNode)this, LogViewerDDI.AGENT_INBAND);
        } else if (actionCommand.equals(refreshMenuItemString)) {
            this.refresh();
        }
    }

    private void refresh() {
        if (this.ddi == null) {
            InbandFabricAgentDDI addi = new InbandFabricAgentDDI(this.node_name, this.node_id);
            this.ddi = addi;
            this.ddi.treeNode = this;
            this.ddi.setDescription(MessageLog.getMessageNoID("ADG0201L") + ":  " + this.getUserObject());
        }
        this.ddi.reDisplay();
        BaseTree.MyTree.nodeChanged(this);
    }

    public void select(TreeSelectionEvent event) {
        this.refresh();
    }
}

