/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.admin.OutOfBandAgentPanel;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;

public class OutOfBandAgentDialog
extends JDialog
implements ActionListener {
    private JPanel jContentPane = null;
    private String rememberedUN = null;
    private String rememberedPW = null;
    private BaseTreeNode parentNode;
    private OutOfBandAgentPanel outOfBandAgentPanel = null;

    public OutOfBandAgentDialog() {
        this.initialize();
    }

    public OutOfBandAgentDialog(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.initialize();
        this.configureHelp();
    }

    private void initialize() {
        this.setTitle(FabricGuiUtil.getString("FabricOutOfBand_AddDialogTitle"));
        this.setDefaultCloseOperation(1);
        this.setSize(470, 200);
        this.setContentPane(this.getJContentPane());
        GuiUtil.centerDialog(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK") || e.getActionCommand().equals("CANCEL")) {
            this.dispose();
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            BorderLayout borderLayout20 = new BorderLayout();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(borderLayout20);
            borderLayout20.setHgap(0);
            borderLayout20.setVgap(0);
            this.jContentPane.add((Component)this.getOutOfBandAgentPanel(), "Center");
        }
        return this.jContentPane;
    }

    public static void addSorted(BaseTreeNode parent, BaseTreeNode child) {
        BaseTreeNode node;
        int index;
        String childKey = child.getUserObject().toString();
        int childCount = parent.getChildCount();
        int comp = 1;
        for (index = 0; index < childCount && (comp = childKey.compareTo((node = (BaseTreeNode)parent.getChildAt(index)).getUserObject().toString())) > 0; ++index) {
        }
        if (comp != 0) {
            BaseTree.MyTree.insertNodeInto(child, parent, index);
        }
    }

    private OutOfBandAgentPanel getOutOfBandAgentPanel() {
        if (this.outOfBandAgentPanel == null) {
            this.outOfBandAgentPanel = new OutOfBandAgentPanel(2);
            this.outOfBandAgentPanel.addActionListener(this);
        }
        return this.outOfBandAgentPanel;
    }

    public BaseTreeNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(BaseTreeNode parentNode) {
        this.parentNode = parentNode;
        this.getOutOfBandAgentPanel().setParentNode(parentNode);
    }

    private void configureHelp() {
        String helpID = FabricGuiUtil.FHELP_AGENT_OUTBAND_ADD;
        Help.setHelpID(this.getRootPane(), helpID);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
    }
}

