/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.admin.OutOfBandFabricAgentDDI;
import org.eclipse.aperi.gui.admin.OutOfBandFabricAgentTreeNode;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.OutOfBandFabricAgentInfo;

public class OutOfBandAgentPanel
extends JPanel
implements GuiRequestor,
ActionListener,
Serializable {
    private Vector listeners = new Vector();
    private String node_name;
    private String node_ip;
    private OutOfBandFabricAgentDDI node_ddi;
    private JTextField jStatus = null;
    private JTextField jIPAddress = null;
    private JLabel jStatusLabel = null;
    private JLabel jIPAddressLabel = null;
    private JPanel jContentPane = null;
    private JPanel jOkCancelPanel = null;
    private JPanel jMainPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JPanel jGeneralInfoPanel = null;
    private JPanel jGeneralInfoLabelPanel = null;
    private JPanel jGeneralInfoControlPanel = null;
    private JLabel jHostLabel = null;
    private JTextField jHostTextField = null;
    private JLabel jSNMPCommunityLabel = null;
    private JTextField jSNMPCommunityTextField = null;
    private JLabel jGeneralInfoLabel = null;
    private JLabel jUserNameLabel = null;
    private JTextField jUsernameTextField = null;
    private JLabel jPasswordLabel = null;
    private JPasswordField jPasswordField = null;
    private String rememberedUN = null;
    private String rememberedPW = null;
    private final int SPACER_WIDTH = 30;
    private final int SPACER_HEIGHT = 10;
    public static final int PROPERTY_PAGE = 1;
    public static final int DIALOG_BOX = 2;
    private int displayMode = 1;
    private BaseTreeNode parentNode;
    private JPanel jEastSpacer = null;
    private JPanel jWestSpacer = null;
    private JPanel jNorthSpacer = null;
    private OutOfBandFabricAgentInfo oobInitialValues;
    private static String OOBFA_SNMP_COMMUNITY = "public";
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    private void enableOkAndCancelButtons(boolean enable) {
        if (enable) {
            this.okButton.setEnabled(true);
            this.cancelButton.setEnabled(true);
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.okButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listeners.addElement(l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listeners.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAction(ActionEvent actionEvt) {
        Vector targets;
        OutOfBandAgentPanel outOfBandAgentPanel = this;
        synchronized (outOfBandAgentPanel) {
            targets = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < targets.size(); ++i) {
            ActionListener target = (ActionListener)targets.elementAt(i);
            target.actionPerformed(actionEvt);
        }
    }

    public OutOfBandAgentPanel(int displayMode) {
        this.displayMode = displayMode;
        this.initialize();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            this.enableOkAndCancelButtons(false);
            this.savePanelChanges();
            return;
        }
        if (e.getActionCommand().equals("CANCEL") && this.displayMode == 1) {
            this.stateChanged();
        }
        this.fireAction(e);
    }

    private boolean checkForPrivateField(String comName) {
        char[] chars = comName.toCharArray();
        boolean firstSpace = false;
        boolean colon = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!firstSpace && chars[i] == ' ') {
                firstSpace = true;
                continue;
            }
            if (!colon && firstSpace && chars[i] == ':') {
                colon = true;
                continue;
            }
            if (!colon || !firstSpace || chars[i] != ' ') continue;
            return true;
        }
        return false;
    }

    private void savePanelChanges() {
        OutOfBandFabricAgentInfo oobfai = new OutOfBandFabricAgentInfo();
        oobfai.request_type = this.displayMode == 2 ? 2 : 5;
        String hostorip = this.jHostTextField.getText();
        if (oobfai.request_type == 5) {
            oobfai.hostname = this.node_name;
            oobfai.ipaddress = this.node_ip;
        } else {
            oobfai.hostname = hostorip;
            oobfai.ipaddress = hostorip;
        }
        String comFieldStr = this.jSNMPCommunityTextField.getText();
        if (this.checkForPrivateField(comFieldStr)) {
            StringTokenizer st = new StringTokenizer(comFieldStr, ":");
            oobfai.communityname = st.nextToken().trim();
            oobfai.communityname_rw = st.nextToken().trim();
        } else {
            oobfai.communityname = comFieldStr.trim();
        }
        oobfai.username = null;
        oobfai.password = null;
        oobfai.hostname = oobfai.hostname.trim();
        if (oobfai.username != null) {
            oobfai.username = oobfai.username.trim();
        }
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler";
        request.userName = GuiUtil.getUserName();
        request.requestData = oobfai;
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(150, 150);
        this.add((Component)this.getJContentPane(), "Center");
        GuiUtil.centerDialog(this);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            BorderLayout borderLayout20 = new BorderLayout();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(borderLayout20);
            borderLayout20.setHgap(0);
            borderLayout20.setVgap(0);
            this.jContentPane.add((Component)this.getJNorthSpacer(), "North");
            this.jContentPane.add((Component)this.getJEastSpacer(), "East");
            this.jContentPane.add((Component)this.getJWestSpacer(), "West");
            this.jContentPane.add((Component)this.getJOkCancelPanel(), "South");
            this.jContentPane.add((Component)this.getJMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getJOkCancelPanel() {
        if (this.jOkCancelPanel == null) {
            this.jOkCancelPanel = new JPanel();
            this.jOkCancelPanel.add((Component)this.getOkButton(), null);
            this.jOkCancelPanel.add((Component)this.getCancelButton(), null);
        }
        return this.jOkCancelPanel;
    }

    private JPanel getJMainPanel() {
        if (this.jMainPanel == null) {
            this.jMainPanel = new JPanel();
            this.jMainPanel.setLayout(new BoxLayout(this.jMainPanel, 1));
            this.jMainPanel.add((Component)this.getJGeneralInfoPanel(), null);
        }
        return this.jMainPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setName("OK");
            this.okButton.setText(FabricGuiUtil.getString("FabricOutOfBand_OK"));
            this.okButton.setActionCommand("OK");
            this.okButton.addActionListener(this);
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(FabricGuiUtil.getString("FabricOutOfBand_Cancel"));
            this.cancelButton.setName("Cancel");
            this.cancelButton.setActionCommand("CANCEL");
            this.cancelButton.addActionListener(this);
        }
        return this.cancelButton;
    }

    private JPanel getJGeneralInfoPanel() {
        if (this.jGeneralInfoPanel == null) {
            this.jGeneralInfoPanel = new JPanel();
            this.jGeneralInfoPanel.setLayout(new BoxLayout(this.jGeneralInfoPanel, 1));
            this.jGeneralInfoPanel.add((Component)this.getJGeneralInfoLabelPanel(), null);
            this.jGeneralInfoPanel.add((Component)this.getJGeneralInfoControlPanel(), null);
        }
        return this.jGeneralInfoPanel;
    }

    private JPanel getJGeneralInfoLabelPanel() {
        if (this.jGeneralInfoLabelPanel == null) {
            this.jGeneralInfoLabel = new JLabel();
            FlowLayout flowLayout17 = new FlowLayout();
            this.jGeneralInfoLabelPanel = new JPanel();
            this.jGeneralInfoLabelPanel.setLayout(flowLayout17);
            this.jGeneralInfoLabel.setText(FabricGuiUtil.getString("FabricOutOfBand_GeneralInfo"));
            this.jGeneralInfoLabel.setHorizontalAlignment(10);
            flowLayout17.setAlignment(0);
            this.jGeneralInfoLabelPanel.add((Component)this.jGeneralInfoLabel, null);
        }
        return this.jGeneralInfoLabelPanel;
    }

    private void updateDisplayMode() {
        if (this.displayMode == 1) {
            this.jIPAddressLabel.setVisible(true);
            this.jStatus.setVisible(true);
            this.jIPAddress.setVisible(true);
            this.jStatusLabel.setVisible(true);
            this.okButton.setVisible(false);
            this.okButton.setEnabled(false);
            this.cancelButton.setVisible(false);
            this.cancelButton.setEnabled(false);
        } else {
            this.jHostTextField.setEditable(true);
            this.jSNMPCommunityTextField.setEditable(true);
        }
    }

    private JPanel getJGeneralInfoControlPanel() {
        if (this.jGeneralInfoControlPanel == null) {
            this.jIPAddressLabel = new JLabel();
            this.jStatusLabel = new JLabel();
            this.jSNMPCommunityLabel = new JLabel();
            this.jHostLabel = new JLabel();
            GridBagConstraints gbcHostLabel = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gbcSNMPCommunityLabel = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            GridBagConstraints gbcStatus = new GridBagConstraints();
            GridBagConstraints gbcIPAddress = new GridBagConstraints();
            GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            GridBagConstraints gbcIPAddressLabel = new GridBagConstraints();
            GridBagConstraints gbcStatusLabel = new GridBagConstraints();
            this.jGeneralInfoControlPanel = new JPanel();
            this.jGeneralInfoControlPanel.setLayout(new GridBagLayout());
            gbcHostLabel.gridx = 1;
            gbcHostLabel.gridy = 2;
            gbcHostLabel.anchor = 13;
            gbcHostLabel.insets = new Insets(0, 20, 0, 10);
            gbcIPAddressLabel.gridx = 1;
            gbcIPAddressLabel.gridy = 3;
            gbcIPAddressLabel.anchor = 13;
            gbcIPAddressLabel.insets = new Insets(0, 0, 0, 10);
            this.jStatusLabel.setVisible(false);
            this.jIPAddressLabel.setVisible(false);
            this.jIPAddressLabel.setText(FabricGuiUtil.getString("FabricOutOfBand_IPAddressLabel"));
            this.jGeneralInfoControlPanel.add((Component)this.jIPAddressLabel, gbcIPAddressLabel);
            this.jHostLabel.setText(FabricGuiUtil.getString("FabricOutOfBand_HostLabel"));
            gbcStatus.weightx = 1.0;
            gbcStatus.fill = 2;
            gbcStatus.gridx = 2;
            gbcStatus.gridy = 1;
            gbcStatus.insets = new Insets(0, 0, 0, 40);
            gbcIPAddress.weightx = 1.0;
            gbcIPAddress.fill = 2;
            gbcIPAddress.insets = new Insets(0, 0, 0, 40);
            gbcIPAddress.gridx = 2;
            gbcIPAddress.gridy = 3;
            gridBagConstraints51.anchor = 13;
            gridBagConstraints51.gridx = 1;
            gridBagConstraints51.gridy = 3;
            gridBagConstraints51.insets = new Insets(0, 20, 0, 10);
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.insets = new Insets(0, 20, 0, 10);
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints5.anchor = 10;
            this.jGeneralInfoControlPanel.add((Component)this.jHostLabel, gbcHostLabel);
            gridBagConstraints19.gridx = 2;
            gridBagConstraints19.gridy = 0;
            gbcSNMPCommunityLabel.anchor = 13;
            gbcSNMPCommunityLabel.insets = new Insets(0, 20, 0, 10);
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 40);
            gbcSNMPCommunityLabel.gridx = 1;
            gbcSNMPCommunityLabel.gridy = 4;
            gbcStatusLabel.gridx = 1;
            gbcStatusLabel.gridy = 1;
            gbcStatusLabel.anchor = 13;
            gbcStatusLabel.insets = new Insets(0, 0, 0, 10);
            this.jStatusLabel.setText(FabricGuiUtil.getString("FabricOutOfBand_StatusLabel"));
            this.jGeneralInfoControlPanel.add((Component)this.jStatusLabel, gbcStatusLabel);
            this.jSNMPCommunityLabel.setText(FabricGuiUtil.getString("FabricOutOfBand_SNMPCommunityLabel"));
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.gridy = 4;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.insets = new Insets(0, 0, 0, 40);
            this.jGeneralInfoControlPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
            this.jGeneralInfoControlPanel.add((Component)this.getJIPAddress(), gbcIPAddress);
            this.jGeneralInfoControlPanel.add((Component)this.getJSNMPCommunityTextField(), gridBagConstraints5);
            this.jGeneralInfoControlPanel.add((Component)this.getJHostTextField(), gridBagConstraints3);
            this.jGeneralInfoControlPanel.add((Component)this.jSNMPCommunityLabel, gbcSNMPCommunityLabel);
            this.jGeneralInfoControlPanel.add((Component)this.getJStatus(), gbcStatus);
            this.updateDisplayMode();
        }
        return this.jGeneralInfoControlPanel;
    }

    private JTextField getJHostTextField() {
        if (this.jHostTextField == null) {
            this.jHostTextField = new JTextField();
            this.jHostTextField.setToolTipText(FabricGuiUtil.getString("FabricOutOfBand_HostnameTip"));
            this.jHostTextField.setEditable(false);
        }
        return this.jHostTextField;
    }

    private JTextField getJSNMPCommunityTextField() {
        if (this.jSNMPCommunityTextField == null) {
            this.jSNMPCommunityTextField = new JTextField();
            this.jSNMPCommunityTextField.setToolTipText(FabricGuiUtil.getString("FabricOutOfBand_SNMPCommunityTip"));
            this.jSNMPCommunityTextField.setEditable(false);
            this.jSNMPCommunityTextField.setText(OOBFA_SNMP_COMMUNITY);
        }
        return this.jSNMPCommunityTextField;
    }

    private static void addSorted(BaseTreeNode parent, BaseTreeNode child) {
        BaseTreeNode node;
        int index;
        String childKey = child.getUserObject().toString();
        int childCount = parent.getChildCount();
        int comp = 1;
        for (index = 0; index < childCount && (comp = childKey.compareTo((node = (BaseTreeNode)parent.getChildAt(index)).getUserObject().toString())) > 0; ++index) {
        }
        if (comp != 0) {
            BaseTree.MyTree.insertNodeInto(child, parent, index);
        }
    }

    public void updateData(String nodename, String nodeip, OutOfBandFabricAgentDDI ddi) {
        this.node_name = nodename;
        this.node_ip = nodeip;
        this.node_ddi = ddi;
        this.stateChanged();
    }

    private void stateChanged() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler";
        request.userName = GuiUtil.getUserName();
        OutOfBandFabricAgentInfo oobfai = new OutOfBandFabricAgentInfo();
        request.requestData = oobfai;
        request.flags = (byte)4;
        oobfai.request_type = 1;
        oobfai.hostname = this.node_name;
        oobfai.ipaddress = this.node_ip;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        this.enableOkAndCancelButtons(true);
        if (status <= 4) {
            OutOfBandFabricAgentInfo oobfai = (OutOfBandFabricAgentInfo)response.responseData;
            switch (oobfai.request_type) {
                case 5: {
                    if (oobfai.message_status == 4) {
                        String agentMessage = Util.getString("FMSG_OutOfBand_PaswordUsernameInvalid");
                        JOptionPane.showMessageDialog(this.guiMain.getFrame(), agentMessage, "Username or Password Invalid", 0);
                        break;
                    }
                    if (oobfai.message_status == 5) {
                        String agentMessage = Util.getString("FMSG_OutOfBand_NotABrocadeAgent");
                        JOptionPane.showMessageDialog(this.guiMain.getFrame(), agentMessage, "Not A Brocade Agent", 0);
                        break;
                    }
                    if (oobfai.message_status == 2 || oobfai.message_status == 3) {
                        this.oobInitialValues = null;
                        if (this.displayMode != 1) break;
                        this.stateChanged();
                        break;
                    }
                    JOptionPane.showMessageDialog(this.guiMain.getFrame(), "Unexpected Server Response", "Unexpected server response message_status=" + oobfai.message_status, 0);
                    break;
                }
                case 2: {
                    if (oobfai.message_status == 4) {
                        String agentMessage = Util.getString("FMSG_OutOfBand_PaswordUsernameInvalid");
                        JOptionPane.showMessageDialog(this.guiMain.getFrame(), agentMessage, "Username or Password Invalid", 0);
                        break;
                    }
                    if (oobfai.message_status == 5) {
                        String agentMessage = Util.getString("FMSG_OutOfBand_NotABrocadeAgent");
                        JOptionPane.showMessageDialog(this.guiMain.getFrame(), agentMessage, "Not A Brocade Agent", 0);
                        break;
                    }
                    if (oobfai.message_status == 2 || oobfai.message_status == 3) {
                        byte node_state = 0;
                        if (oobfai.message_status == 2) {
                            node_state = 1;
                        }
                        OutOfBandFabricAgentTreeNode node = new OutOfBandFabricAgentTreeNode((Object)oobfai.hostname, oobfai.ipaddress, node_state);
                        if (this.displayMode == 2) {
                            OutOfBandAgentPanel.addSorted(this.parentNode, node);
                        }
                        this.oobInitialValues = null;
                        ActionEvent ae = new ActionEvent(this, 0, "OK");
                        this.fireAction(ae);
                        break;
                    }
                    JOptionPane.showMessageDialog(this.guiMain.getFrame(), "Unexpected Server Response", "Unexpected server response message_status=" + oobfai.message_status, 0);
                    break;
                }
                case 1: {
                    if (this.node_ddi != null) {
                        this.node_ddi.setNodeIconBasedOnStatusFromServer(oobfai.status);
                    }
                    this.oobInitialValues = oobfai;
                    this.setStatusStringBasedOnStatusFromServer(oobfai.status);
                    this.getJIPAddress().setText(oobfai.ipaddress);
                    this.getJHostTextField().setText(oobfai.hostname);
                    this.getJSNMPCommunityTextField().setText(oobfai.communityname);
                    this.jSNMPCommunityTextField.setEditable(true);
                    if (oobfai.username != null) break;
                    oobfai.username = "";
                }
            }
        }
    }

    private void setStatusStringBasedOnStatusFromServer(int status) {
        switch (status) {
            case 2: {
                this.getJStatus().setText((String)FabricGuiUtil.getStatusString(0));
                break;
            }
            default: {
                this.getJStatus().setText((String)FabricGuiUtil.getStatusString(-1));
            }
        }
    }

    private JPanel getJEastSpacer() {
        if (this.jEastSpacer == null) {
            this.jEastSpacer = new JPanel();
            this.jEastSpacer.setPreferredSize(new Dimension(30, 10));
        }
        return this.jEastSpacer;
    }

    private JPanel getJWestSpacer() {
        if (this.jWestSpacer == null) {
            this.jWestSpacer = new JPanel();
            this.jWestSpacer.setPreferredSize(new Dimension(30, 10));
        }
        return this.jWestSpacer;
    }

    private JPanel getJNorthSpacer() {
        if (this.jNorthSpacer == null) {
            this.jNorthSpacer = new JPanel();
        }
        return this.jNorthSpacer;
    }

    public BaseTreeNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(BaseTreeNode parentNode) {
        this.parentNode = parentNode;
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(int displayMode) {
        this.displayMode = displayMode;
    }

    private JTextField getJStatus() {
        if (this.jStatus == null) {
            this.jStatus = new JTextField();
            this.jStatus.setVisible(false);
            this.jStatus.setEditable(false);
        }
        return this.jStatus;
    }

    private JTextField getJIPAddress() {
        if (this.jIPAddress == null) {
            this.jIPAddress = new JTextField();
            this.jIPAddress.setVisible(false);
            this.jIPAddress.setEditable(false);
        }
        return this.jIPAddress;
    }

    public boolean changesPending() {
        return this.oobInitialValues != null && !this.getJSNMPCommunityTextField().getText().equals(this.oobInitialValues.communityname);
    }

    public void saveAndClose() {
        this.savePanelChanges();
    }
}

