/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.TreeNode;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.admin.GenericServiceTreeNode;
import org.eclipse.aperi.gui.admin.ServicesDDI;
import org.eclipse.aperi.gui.admin.ServicesTreeNode;
import org.eclipse.aperi.server.req.ServerStatusResp;
import org.eclipse.aperi.xmsg.MessageLog;

public class ServicesTreeLabel
extends BaseTreeNode
implements ActionListener {
    public ServicesTreeLabel() {
        this.setUserObject(Util.getString(this.getLabelUIName()));
    }

    public void showPopupMenu(MouseEvent event) {
        JPopupMenu popup = this.getPopupMenu();
        JMenuItem refresh = new JMenuItem(MessageLog.getMessageNoID("ADG0003L"));
        refresh.setToolTipText(MessageLog.getMessageNoID("ADG0004T"));
        refresh.addActionListener(this);
        popup.add(refresh);
        this.showPopupMenu(popup, event);
    }

    public void actionPerformed(ActionEvent event) {
        this.getServices();
    }

    public void expand(TreeExpansionEvent event) {
        this.getServices();
    }

    protected void getServices() {
        ServicesTreeNode child;
        String currRequestType = null;
        DataDisplayInfo curr = DataDisplayInfo.getCurrent();
        if (curr != null && curr instanceof ServicesDDI) {
            currRequestType = ((GenericServiceTreeNode)curr.treeNode).getRequestType();
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            child = (ServicesTreeNode)e.nextElement();
            if (child.ddi == null) continue;
            child.ddi.remove();
        }
        this.removeAllChildren();
        if (GuiClient.serverStatus() <= 4) {
            ServerStatusResp.Service serviceStatus;
            int i;
            ServerStatusResp status = GuiClient.serverStatusResp;
            int serviceCount = status.services.length;
            for (i = 0; i < serviceCount; ++i) {
                serviceStatus = status.services[i];
                if (serviceStatus.requestType != "org.eclipse.aperi.server.svp.ServerSvp") continue;
                this.add(new ServicesTreeNode(RequestTypeManager.getExternalName(serviceStatus.requestType), serviceStatus.requestType, serviceStatus.state, serviceStatus.pendingRequests, serviceStatus.processedRequests, serviceStatus.threadsWaiting));
                break;
            }
            for (i = 0; i < serviceCount; ++i) {
                serviceStatus = status.services[i];
                if (serviceStatus.requestType == "org.eclipse.aperi.server.svp.ServerSvp") continue;
                this.add(new ServicesTreeNode(RequestTypeManager.getExternalName(serviceStatus.requestType), serviceStatus.requestType, serviceStatus.state, serviceStatus.pendingRequests, serviceStatus.processedRequests, serviceStatus.threadsWaiting));
            }
        }
        BaseTree.MyTree.nodeStructureChanged(this);
        if (currRequestType != null) {
            e = this.children();
            while (e.hasMoreElements()) {
                child = (ServicesTreeNode)e.nextElement();
                if (!child.getRequestType().equals(currRequestType)) continue;
                child.select(null);
                break;
            }
        }
    }

    protected String getLabelUIName() {
        return "DATA_SERVER";
    }
}

