/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.charting;

import javax.swing.JPanel;

public abstract class AperiChartAdapter
extends JPanel {
    public static final int CHART_TYPE_HISTORY = 0;
    public static final int CHART_TYPE_PIE = 1;
    public static final int CHART_TYPE_BAR = 2;
    public static final int CHART_TYPE_STACKEDBAR = 3;
    public static final int CHART_SUBTYPE_EXPLOSIVE = 0;
    public static final int CHART_SUBTYPE_MULTICHART = 1;
    public static final int ORIENT_HORIZONTAL = 0;
    public static final int ORIENT_VERTICAL = 1;
    public static final int ANCHOR_NORTH = 0;
    public static final int ANCHOR_NORTH_EAST = 1;
    public static final int ANCHOR_EAST = 2;
    public static final int ANCHOR_SOUTH_EAST = 3;
    public static final int ANCHOR_SOUTH = 4;
    public static final int ANCHOR_SOUTH_WEST = 5;
    public static final int ANCHOR_WEST = 6;
    public static final int ANCHOR_NORTH_WEST = 7;
    public static final int SCALING_ABSOLUTE = 0;
    public static final int SCALING_PERCENT = 1;
    public static final int SCALING_LOGARITHMIC = 2;
    public static final int FORMAT_NONE = 0;
    public static final int FORMAT_BYTES = 1;
    public static final int FORMAT_DECIMAL = 2;
    public static final int FORMAT_MILLISECONDS = 3;
    public static final int FORMAT_DURATION = 4;
    public static final int FORMAT_DATETIME = 5;
    public static final int FORMAT_NUMBER = 6;
    public static final int FORMAT_TEXT = 7;
    public static final int FORMAT_PERCENT = 8;
    private int chartType = 1;
    private int chartSubtype = 0;
    private int chartOrientation = 1;
    private String chartTitle = "Chart";
    private boolean chartTitleVisible = true;
    private boolean legendVisible = true;
    private int legendOrientation = 0;
    private int legendAnchor = 4;
    private String yAxisTitleText = "Y Axis";
    private boolean yAxisTitleVisible = false;
    private int yAxisTitleOrientation = 1;
    private int yAxisScaling = 0;
    private int yValueFormat = 2;
    private boolean yValueLabelsVisible = true;
    private int yValueLabelsOrientation = 1;
    private boolean yValuePointsVisible = true;
    private String xAxisTitleText = "X Axis";
    private int xValueFormat = 2;
    private boolean xAxisTitleVisible = false;
    private int xAxisTitleOrientation = 0;
    private String[] ySeriesNames = null;
    private Number[][] ySeries = null;
    private Object[] xCategories = null;
    private double[][] yValues = null;
    private double[][] xValues = null;
    private boolean trendLineVisible = true;
    protected double[][] yTrend = null;
    protected double[][] xTrend = null;
    private int seriesOffset = 0;
    private int seriesPerChart = Integer.MAX_VALUE;
    private int categoryOffset = 0;
    private int chartsPerView = Integer.MAX_VALUE;

    public int getChartType() {
        return this.chartType;
    }

    public void setChartType(int chartType) {
        this.checkChartType(chartType);
        this.chartType = chartType;
    }

    public int getChartOrientation() {
        return this.chartOrientation;
    }

    public void setChartOrientation(int chartOrientation) {
        this.checkOrientation(chartOrientation);
        this.chartOrientation = chartOrientation;
    }

    public boolean isLegendVisible() {
        return this.legendVisible;
    }

    public void setLegendVisible(boolean chartLegendVisible) {
        this.legendVisible = chartLegendVisible;
    }

    public int getLegendAnchor() {
        return this.legendAnchor;
    }

    public void setLegendAnchor(int chartLegendAnchor) {
        this.checkAnchor(chartLegendAnchor);
        this.legendAnchor = chartLegendAnchor;
    }

    public int getLegendOrientation() {
        return this.legendOrientation;
    }

    public void setLegendOrientation(int chartLegendOrientation) {
        this.checkOrientation(chartLegendOrientation);
        this.legendOrientation = chartLegendOrientation;
    }

    public String getXAxisTitleText() {
        return this.xAxisTitleText;
    }

    public void setXAxisTitleText(String axisLabelText) {
        this.xAxisTitleText = axisLabelText;
    }

    public boolean isXAxisTitleVisible() {
        return this.xAxisTitleVisible;
    }

    public void setXAxisTitleVisible(boolean axisLabelVisible) {
        this.xAxisTitleVisible = axisLabelVisible;
    }

    public String getYAxisTitleText() {
        return this.yAxisTitleText;
    }

    public void setYAxisTitleText(String axisLabelText) {
        this.yAxisTitleText = axisLabelText;
    }

    public boolean isYAxisTitleVisible() {
        return this.yAxisTitleVisible;
    }

    public void setYAxisTitleVisible(boolean axisLabelVisible) {
        this.yAxisTitleVisible = axisLabelVisible;
    }

    public Number[][] getYSeries() {
        return this.ySeries;
    }

    public void setYSeries(Number[][] series) {
        if (this.getChartType() == 0) {
            throw new RuntimeException("Chart type must not be CHART_TYPE_HISTORY for category charts");
        }
        this.ySeries = series;
    }

    public Object[] getXCategories() {
        return this.xCategories;
    }

    public void setXCategories(Object[] series) {
        if (this.getChartType() == 0) {
            throw new RuntimeException("Chart type must not be CHART_TYPE_HISTORY for category charts");
        }
        this.xCategories = series;
    }

    public String[] getYSeriesNames() {
        return this.ySeriesNames;
    }

    public void setYSeriesNames(String[] seriesNames) {
        this.ySeriesNames = seriesNames;
    }

    public int getYAxisScaling() {
        return this.yAxisScaling;
    }

    public void setYAxisScaling(int axisScaling) {
        this.yAxisScaling = axisScaling;
    }

    private void checkChartType(int chartType) {
        if (chartType < 0 || chartType > 3) {
            throw new RuntimeException("Bad Chart Type " + chartType);
        }
    }

    private void checkAnchor(int anchor) {
        if (anchor < 0 || anchor > 7) {
            throw new RuntimeException("Bad Chart Legend Anchor " + anchor);
        }
    }

    private void checkOrientation(int orientation) {
        if (orientation < 0 || orientation > 2) {
            throw new RuntimeException("Bad Orientation " + orientation);
        }
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public void setChartTitle(String chartTitle) {
        this.chartTitle = chartTitle;
    }

    public boolean isChartTitleVisible() {
        return this.chartTitleVisible;
    }

    public void setChartTitleVisible(boolean chartTitleVisible) {
        this.chartTitleVisible = chartTitleVisible;
    }

    public int getYAxisTitleOrientation() {
        return this.yAxisTitleOrientation;
    }

    public void setYAxisTitleOrientation(int axisLabelOrientation) {
        this.yAxisTitleOrientation = axisLabelOrientation;
    }

    public int getXAxisTitleOrientation() {
        return this.xAxisTitleOrientation;
    }

    public void setXAxisTitleOrientation(int xisLabelOrientation) {
        this.xAxisTitleOrientation = xisLabelOrientation;
    }

    public boolean isYValueLabelsVisible() {
        return this.yValueLabelsVisible;
    }

    public void setYValueLabelsVisible(boolean valueLabelsVisible) {
        this.yValueLabelsVisible = valueLabelsVisible;
    }

    public boolean isYValuePointsVisible() {
        return this.yValuePointsVisible;
    }

    public void setYValuePointsVisible(boolean valuePointsVisible) {
        this.yValuePointsVisible = valuePointsVisible;
    }

    public int getYValueLabelsOrientation() {
        return this.yValueLabelsOrientation;
    }

    public void setYValueLabelsOrientation(int valueLabelsOrientation) {
        this.yValueLabelsOrientation = valueLabelsOrientation;
    }

    public int getYValueFormat() {
        return this.yValueFormat;
    }

    public void setYValueFormat(int valueFormat) {
        if (valueFormat < 0 || valueFormat > 8) {
            throw new RuntimeException("Bad value format " + valueFormat);
        }
        this.yValueFormat = valueFormat;
    }

    public int getXValueFormat() {
        return this.xValueFormat;
    }

    public void setXValueFormat(int valueFormat) {
        this.xValueFormat = valueFormat;
    }

    public double[][] getXValues() {
        return this.xValues;
    }

    public double[][] getYValues() {
        return this.yValues;
    }

    private void setXValues(double[][] values) {
        this.xValues = values;
    }

    private void setYValues(double[][] values) {
        this.yValues = values;
    }

    public void setXYValues(double[][] xValues, double[][] yValues) {
        if (this.getChartType() != 0) {
            throw new RuntimeException("Chart type must be CHART_TYPE_HISTORY for (x,y) plot");
        }
        if (xValues == null || yValues == null) {
            throw new RuntimeException();
        }
        if (xValues.length == 0 || yValues.length == 0) {
            throw new RuntimeException("X and Y vectors must be greater than zero length");
        }
        if (xValues.length != yValues.length) {
            throw new RuntimeException("X and Y series vectors must be the same length");
        }
        for (int i = 0; i < xValues.length; ++i) {
            if (!(xValues[i] instanceof double[]) || !(yValues[i] instanceof double[])) {
                throw new RuntimeException("X and Y vectors must be of type Double[]");
            }
            if (xValues[i].length != yValues[i].length) {
                throw new RuntimeException("Corresponding X and Y vector pairs must be the same length");
            }
            for (int j = 0; j < xValues[i].length; ++j) {
                if (!(xValues[i][j] < 0.0) && !(yValues[i][j] < 0.0)) continue;
                throw new RuntimeException("Negatives not allowed in X or Y vectors");
            }
        }
        this.setXValues(xValues);
        this.setYValues(yValues);
    }

    public boolean isTrendLineVisible() {
        return this.trendLineVisible;
    }

    public void setTrendLineVisible(boolean trendLineVisible) {
        this.trendLineVisible = trendLineVisible;
    }

    protected void createTrendValues() {
        if (this.getChartType() != 0) {
            throw new RuntimeException();
        }
        if (this.xValues == null || this.yValues == null) {
            throw new RuntimeException();
        }
        int lines = this.getXValues().length;
        this.xTrend = new double[lines][2];
        this.yTrend = new double[lines][2];
        for (int ln = 0; ln < lines; ++ln) {
            int pt;
            double sumXX = 0.0;
            double sumXY = 0.0;
            double sumX = 0.0;
            double sumY = 0.0;
            for (pt = 0; pt < this.getXValues()[ln].length; ++pt) {
                sumXX += this.getXValues()[ln][pt] * this.getXValues()[ln][pt];
                sumXY += this.getXValues()[ln][pt] * this.getYValues()[ln][pt];
                sumX += this.getXValues()[ln][pt];
                sumY += this.getYValues()[ln][pt];
            }
            if (pt < 2) {
                this.xTrend[ln][0] = Double.MIN_VALUE;
                this.yTrend[ln][0] = Double.MIN_VALUE;
                this.xTrend[ln][1] = Double.MIN_VALUE;
                this.yTrend[ln][1] = Double.MIN_VALUE;
                continue;
            }
            double xx = sumXX - sumX * sumX / (double)pt;
            double xy = sumXY - sumX * sumY / (double)pt;
            double b = xy / xx;
            double a = (sumY - b * sumX) / (double)pt;
            this.xTrend[ln][0] = this.getXValues()[ln][pt - 1];
            this.yTrend[ln][0] = this.getYValues()[ln][pt - 1];
            this.xTrend[ln][1] = this.getXValues()[ln][pt - 1] + (this.getXValues()[ln][pt - 1] - this.getXValues()[ln][0]) / 2.0;
            this.yTrend[ln][1] = a + b * this.xTrend[ln][1];
            if (!(this.yTrend[ln][1] < 0.0)) continue;
            double Xdiff = this.xTrend[ln][1] - this.xTrend[ln][0];
            double Ydiff = this.yTrend[ln][1] - this.yTrend[ln][0];
            double slope = Xdiff / Ydiff;
            this.yTrend[ln][1] = 0.0;
            this.xTrend[ln][1] = this.xTrend[ln][0] - slope * this.yTrend[ln][0];
        }
    }

    public void setSeriesPerChart(int start, int count) {
        this.seriesOffset = start;
        this.seriesPerChart = count;
    }

    protected int getSeriesOffset() {
        return this.seriesOffset;
    }

    protected int getSeriesPerChart() {
        return this.seriesPerChart;
    }

    public void setChartsPerView(int start, int count) {
        this.categoryOffset = start;
        this.chartsPerView = count;
    }

    protected int getChartsPerView() {
        return this.chartsPerView;
    }

    protected int getCategoryOffset() {
        return this.categoryOffset;
    }

    public int getChartSubtype() {
        return this.chartSubtype;
    }

    public void setChartSubtype(int chartSubtype) {
        if (this.getChartType() == 0) {
            throw new RuntimeException("Chart subtype cannot be applied to HISTORY charts");
        }
        if (chartSubtype < 0 || chartSubtype > 1) {
            throw new RuntimeException("Bad chart subtype " + chartSubtype);
        }
        this.chartSubtype = chartSubtype;
    }
}

