/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.charting;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationKey;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class AperiChartCustomizationManager {
    private HashMap customMap = new HashMap();
    private String userID;
    private static AperiChartCustomizationManager staticReference = null;

    private AperiChartCustomizationManager() {
    }

    private AperiChartCustomizationManager(String userID, ArrayList al) {
        this.setUserID(userID);
        for (GuiChartSettingsReq gcsr : al) {
            AperiChartCustomizationKey key = new AperiChartCustomizationKey(gcsr);
            this.getCustomMap().put(key, gcsr.options);
        }
    }

    public ChartOptions getChartCustomization(AperiChartCustomizationKey key) {
        return (ChartOptions)this.getCustomMap().get(key);
    }

    private GuiChartSettingsReq newGCSR(AperiChartCustomizationKey key, ChartOptions options) {
        GuiChartSettingsReq gcsr = new GuiChartSettingsReq();
        gcsr.reportId = key.reportId;
        gcsr.reportSubtype = key.reportSubtype;
        gcsr.chartId = key.chartId;
        gcsr.chartSubtype = key.chartSubtype;
        gcsr.batchId = key.batchId;
        gcsr.creator = this.getUserID();
        gcsr.options = options;
        return gcsr;
    }

    private Request newRequest(GuiChartSettingsReq gcsr) {
        Request r = new Request();
        r.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        r.serviceName = RequestTypeManager.getInternalName(r.typeCode);
        r.subType = "org.eclipse.aperi.server.handler.gui.ChartSettingsHndlr";
        r.userName = GuiUtil.getUserName();
        r.flags = (byte)4;
        r.requestData = gcsr;
        return r;
    }

    public void saveChartCustomization(AperiChartCustomizationKey key, ChartOptions options) {
        GuiChartSettingsReq gcsr = this.newGCSR(key, options);
        gcsr.reqType = 2;
        this.getCustomMap().put(key, options.clone());
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, this.newRequest(gcsr));
    }

    public void deleteChartCustomization(AperiChartCustomizationKey key) {
        GuiChartSettingsReq gcsr = this.newGCSR(key, null);
        gcsr.reqType = 3;
        this.getCustomMap().remove(key);
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, this.newRequest(gcsr));
    }

    private HashMap getCustomMap() {
        return this.customMap;
    }

    private String getUserID() {
        return this.userID;
    }

    private void setUserID(String userID) {
        this.userID = userID;
    }

    public static AperiChartCustomizationManager getManager() {
        if (staticReference == null) {
            throw new RuntimeException("AperiChartCustomizationManager not initialzed");
        }
        return staticReference;
    }

    public static void initManager(String userName, ArrayList al) {
        staticReference = new AperiChartCustomizationManager(userName, al);
    }
}

