/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.common.CIMOMMgmtAddCIMOMDialog;
import org.eclipse.aperi.gui.common.CIMOMMgmtAgentTreeNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class CIMOMMgmtAgentTreeLabel
extends BaseTreeNode {
    public CIMOMMgmtAgentTreeLabel() {
        super(Util.getString("CIMOM_MGMT_LABEL"));
    }

    public void expand(TreeExpansionEvent event) {
        this.launchCIMOMCollector();
    }

    public void showPopupMenu(MouseEvent event) {
        if (event != null) {
            JPopupMenu popup = this.getPopupMenu();
            popup.add(this.refreshMenu());
            popup.add(this.addCIMOMMenu());
            this.showPopupMenu(popup, event);
        }
    }

    private JMenuItem addCIMOMMenu() {
        JMenuItem addCimomMenu = new JMenuItem(Util.getString("CIMOM_MGMT_ADD"));
        addCimomMenu.setToolTipText(Util.getString("CIMOM_MGMT_ADD_TIP"));
        final CIMOMMgmtAgentTreeLabel selfReference = this;
        addCimomMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                new CIMOMMgmtAddCIMOMDialog(guiMain.getFrame(), Util.getString("CIMOM_MGMT_ADD_TITLE"), selfReference);
            }
        });
        addCimomMenu.setEnabled(this.capabilities.isAperiAdmin());
        return addCimomMenu;
    }

    private JMenuItem refreshMenu() {
        JMenuItem refresh = new JMenuItem(MessageLog.getMessageNoID("ADG0003L"));
        refresh.setToolTipText(MessageLog.getMessageNoID("ADG0004T"));
        refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                CIMOMMgmtAgentTreeLabel.this.launchCIMOMCollector();
            }
        });
        return refresh;
    }

    private void launchCIMOMCollector() {
        Request request = GuiUtil.newGUIDeviceRequest("org.eclipse.aperi.server.handler.gui.cimom.CIMOMMgmtGetCIMOMsHandler");
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4) {
                    CIMOMMgmtAgentTreeLabel.this.buildCIMOMList((CIMOM[])response.responseData);
                }
            }
        }, request);
    }

    public void buildCIMOMList(CIMOM[] cimoms) {
        HashMap nodeStates = this.cleanAndRemoveChildren();
        this.addAndRenewChildren(cimoms, nodeStates);
        BaseTree.MyTree.nodeStructureChanged(this);
    }

    private void addAndRenewChildren(CIMOM[] cimoms, HashMap nodeStates) {
        for (int i = 0; i < cimoms.length; ++i) {
            CIMOMMgmtAgentTreeNode node = new CIMOMMgmtAgentTreeNode(cimoms[i]);
            node.setState(nodeStates.get(node.getUniqueID()));
            this.addSorted(node);
        }
    }

    private HashMap cleanAndRemoveChildren() {
        HashMap<Object, Object> nodeStates = new HashMap<Object, Object>();
        if (this.children != null) {
            for (CIMOMMgmtAgentTreeNode node : this.children) {
                nodeStates.put(node.getUniqueID(), node.getState());
                node.cleanYourself();
            }
            this.removeAllChildren();
        }
        return nodeStates;
    }
}

