/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.common.DirtyListenerInterface;
import org.eclipse.aperi.gui.common.ElementManagerManager;
import org.eclipse.aperi.gui.common.HashMapDetailsPanel;

public class EditElementManagerConfigDialog
extends JDialog
implements ActionListener,
DirtyListenerInterface {
    HashMapDetailsPanel hashMapPanel;
    private static final String CANCEL_ACTION = Util.getString("LABEL_CANCEL");
    private static final String SAVE_ACTION = Util.getString("LABEL_SAVE");
    private static final String RESET_ACTION = Util.getString("LABEL_RESET");
    private JButton saveButton;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public EditElementManagerConfigDialog(Frame owner) throws HeadlessException {
        super(owner, Util.getString("ELEMENT_MANAGER_CONFIG_DIALOG_TITLE"));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.buildPanel(this.getContentPane());
        this.enableHelp();
        this.pack();
        GuiUtil.centerDialog(this);
        this.setVisible(true);
    }

    private void enableHelp() {
        Help.setHelpID(this.getRootPane(), "adm_dlg_cfg_configureelementlauncher");
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
    }

    private void buildPanel(Container contentPane) {
        this.hashMapPanel = new HashMapDetailsPanel(ElementManagerManager.getInstance().getConfig());
        this.hashMapPanel.makeAllEditable();
        this.hashMapPanel.addDirtyListener(this);
        contentPane.add((Component)this.hashMapPanel, "North");
        contentPane.add((Component)this.buildButtonPanel(), "South");
    }

    public void actionPerformed(ActionEvent e) {
        boolean result = true;
        if (e.getActionCommand().equals(SAVE_ACTION)) {
            result = ElementManagerManager.getInstance().setConfig(this.hashMapPanel.getModel());
            if (result) {
                this.setVisible(false);
                this.dispose();
            }
        } else if (e.getActionCommand().equals(RESET_ACTION)) {
            result = ElementManagerManager.getInstance().setConfig(null);
            if (result) {
                this.setVisible(false);
                this.dispose();
                new EditElementManagerConfigDialog(this.guiMain.getFrame());
            }
        } else if (e.getActionCommand().equals(CANCEL_ACTION)) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.saveButton = this.buildButton(SAVE_ACTION);
        this.saveButton.setEnabled(false);
        buttonPanel.add(this.saveButton);
        buttonPanel.add(this.buildButton(CANCEL_ACTION));
        buttonPanel.add(this.buildButton(RESET_ACTION));
        return buttonPanel;
    }

    private JButton buildButton(String labelAction) {
        JButton button = new JButton(labelAction);
        button.setActionCommand(labelAction);
        button.addActionListener(this);
        button.setEnabled(true);
        GuiUtil.setAccessible(button, button.getText(), button.getText());
        return button;
    }

    public void dirtyTalk(JComponent component, String label) {
        this.saveButton.setEnabled(true);
    }
}

