/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.common.DDIInitialState;
import org.eclipse.aperi.gui.common.DDIState;
import org.eclipse.aperi.gui.common.DDIStateInterface;
import org.eclipse.aperi.gui.common.DirtyListenerInterface;
import org.eclipse.aperi.gui.common.ElementManagerManager;
import org.eclipse.aperi.gui.common.ManageElementManagersPanel;

public class ManageElementManagerDDI
extends DataDisplayInfo
implements DDIStateInterface,
DirtyListenerInterface {
    private DDIState state = DDIInitialState.getInstance();
    ManageElementManagerDDI selfReference;
    ActionListener saveActionListener;
    boolean saveStatus = true;
    String[][] model = null;
    TreeSet modifiedLines = new TreeSet();

    private void refreshModel(Serializable smodel) {
        this.model = (String[][])smodel;
    }

    public void dirtyPanel() {
        guiMain.setSaveActionEnabled(true, false);
        guiMain.addSaveActionListener(this.saveActionListener);
    }

    public void cleanPanel() {
        guiMain.setSaveActionEnabled(false, false);
        guiMain.setSaveActionToolTip(null);
        guiMain.removeSaveActionListener(this.saveActionListener);
    }

    public void showPanel() {
        this.show();
    }

    public void buildPanel() {
        this.panel = new ManageElementManagersPanel(this.model);
        ((ManageElementManagersPanel)this.panel).addDirtyListener(this);
    }

    public void destroyPanel() {
        this.panel = null;
    }

    public void saveState() {
        this.model = ((ManageElementManagersPanel)this.panel).getModel(this.modifiedLines);
    }

    public void persistState() {
        String[][] modifiedModel = new String[this.modifiedLines.size()][];
        TreeSet copy = (TreeSet)this.modifiedLines.clone();
        int j = 0;
        for (int i = 0; i < this.model.length; ++i) {
            if (!copy.remove(this.model[i][0])) continue;
            modifiedModel[j++] = (String[])this.model[i].clone();
        }
        Iterator k = copy.iterator();
        while (k.hasNext()) {
            modifiedModel[j] = new String[1];
            modifiedModel[j][0] = (String)k.next();
            ++j;
        }
        this.saveStatus = ElementManagerManager.getInstance().setModifiedUserDefinedManagers(modifiedModel);
        if (this.saveStatus) {
            this.modifiedLines.clear();
        }
    }

    public void fetchModel() {
        this.refreshModel((Serializable)ElementManagerManager.getInstance().getAllUserDefinedManagers());
        this.modifiedLines.clear();
    }

    public ManageElementManagerDDI(BaseTreeNode node) {
        super(Util.getString("ELEMENT_MANAGER_DDI_TITLE"));
        this.treeNode = node;
        this.selfReference = this;
        this.saveActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ManageElementManagerDDI.this.state = ManageElementManagerDDI.this.state.persist(ManageElementManagerDDI.this.selfReference);
                if (ManageElementManagerDDI.this.saveStatus) {
                    ManageElementManagerDDI.this.state = ManageElementManagerDDI.this.state.saved(ManageElementManagerDDI.this.selfReference);
                }
            }
        };
        this.fetchModel();
        this.state = this.state.show(this);
    }

    public void dirtyTalk(JComponent component, String label) {
        this.state = this.state.dirty(this.selfReference);
    }

    public void panelToBeNulled() {
        this.state = this.state.nullPanel(this);
    }

    public boolean changesPending() {
        return this.state.isDirty();
    }

    public boolean isEditable() {
        return true;
    }

    public void saveAndClose() {
        this.state = this.state.persist(this);
        this.remove();
    }

    public void losingFocus() {
        this.state = this.state.hide(this);
    }

    public void reDisplay() {
        this.state = this.state.show(this);
    }

    public void goingAway() {
        this.treeNode.ddi = null;
    }

    public String getHelpID() {
        return "adm_dlg_cfg_elementmgr";
    }
}

